/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.ConvertJSONToSQL;
import org.apache.nifi.processors.standard.PutSQL;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConvertJSONToSQL {
    private static final String DERBY_LOG_PROPERTY = "derby.stream.error.file";
    protected static DBCPService service;

    @BeforeAll
    public static void setupDerbyLog() throws ProcessException {
        File derbyLog = new File(TestConvertJSONToSQL.getSystemTemporaryDirectory(), "derby.log");
        derbyLog.deleteOnExit();
        System.setProperty(DERBY_LOG_PROPERTY, derbyLog.getAbsolutePath());
    }

    @BeforeEach
    public void setup() throws SQLException {
        File dbDir = new File(this.getEmptyDirectory(), "db");
        dbDir.deleteOnExit();
        service = new MockDBCPService(dbDir.getAbsolutePath());
        String createPersons = "CREATE TABLE PERSONS (id integer primary key, name varchar(100), code integer)";
        try (Connection conn = service.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TABLE PERSONS (id integer primary key, name varchar(100), code integer)");
        }
    }

    @AfterAll
    public static void cleanupDerbyLog() {
        System.clearProperty(DERBY_LOG_PROPERTY);
    }

    @Test
    public void testInsert() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testInsertStatementType() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "Use statement.type Attribute");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "INSERT");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]), attrs);
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testInsertQuotedIdentifiers() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.QUOTED_IDENTIFIERS, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO PERSONS (\"ID\", \"NAME\", \"CODE\") VALUES (?, ?, ?)");
    }

    @Test
    public void testInsertQuotedTableIdentifier() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.QUOTED_TABLE_IDENTIFIER, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO \"PERSONS\" (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testInsertWithNullValue() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-null-code.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeNotExists("sql.args.3.value");
        out.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testInsertBoolToInteger() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-bool.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Bool");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "1");
        out.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testUpdateWithNullValue() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-null-code.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.1.value", "Mark");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(4));
        out.assertAttributeNotExists("sql.args.2.value");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "1");
        out.assertContentEquals("UPDATE PERSONS SET NAME = ?, CODE = ? WHERE ID = ?");
    }

    @Test
    public void testUpdateQuotedTableIdentifier() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.QUOTED_TABLE_IDENTIFIER, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-null-code.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.1.value", "Mark");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(4));
        out.assertAttributeNotExists("sql.args.2.value");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "1");
        out.assertContentEquals("UPDATE \"PERSONS\" SET NAME = ?, CODE = ? WHERE ID = ?");
    }

    @Test
    public void testMultipleInserts() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/persons.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "5");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 5);
        List mffs = runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL);
        for (MockFlowFile mff : mffs) {
            mff.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
            for (int i = 1; i <= 3; ++i) {
                mff.assertAttributeExists("sql.args." + i + ".type");
                mff.assertAttributeExists("sql.args." + i + ".value");
            }
        }
    }

    @Test
    public void testMultipleInsertsQuotedIdentifiers() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.QUOTED_IDENTIFIERS, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/persons.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "5");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 5);
        List mffs = runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL);
        for (MockFlowFile mff : mffs) {
            mff.assertContentEquals("INSERT INTO PERSONS (\"ID\", \"NAME\", \"CODE\") VALUES (?, ?, ?)");
            for (int i = 1; i <= 3; ++i) {
                mff.assertAttributeExists("sql.args." + i + ".type");
                mff.assertAttributeExists("sql.args." + i + ".value");
            }
        }
    }

    @Test
    public void testUpdateBasedOnPrimaryKey() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.1.value", "Mark");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.2.value", "48");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "1");
        out.assertContentEquals("UPDATE PERSONS SET NAME = ?, CODE = ? WHERE ID = ?");
    }

    @Test
    public void testUpdateBasedOnPrimaryKeyQuotedIdentifier() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.QUOTED_IDENTIFIERS, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.1.value", "Mark");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.2.value", "48");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "1");
        out.assertContentEquals("UPDATE PERSONS SET \"NAME\" = ?, \"CODE\" = ? WHERE \"ID\" = ?");
    }

    @Test
    public void testUnmappedFieldBehavior() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_FIELD_BEHAVIOR, ConvertJSONToSQL.IGNORE_UNMATCHED_FIELD.getValue());
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-extra-field.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
        runner.clearTransferState();
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_FIELD_BEHAVIOR, ConvertJSONToSQL.FAIL_UNMATCHED_FIELD.getValue());
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-extra-field.json", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertJSONToSQL.REL_FAILURE, 1);
    }

    @Test
    public void testUpdateBasedOnUpdateKey() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "code");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("UPDATE PERSONS SET ID = ?, NAME = ? WHERE CODE = ?");
    }

    @Test
    public void testUpdateBasedOnUpdateKeyQuotedIdentifier() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "code");
        runner.setProperty(ConvertJSONToSQL.QUOTED_IDENTIFIERS, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("UPDATE PERSONS SET \"ID\" = ?, \"NAME\" = ? WHERE \"CODE\" = ?");
    }

    @Test
    public void testUpdateBasedOnCompoundUpdateKey() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(FragmentAttributes.FRAGMENT_ID.key());
        originalFlowFile.assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("UPDATE PERSONS SET ID = ? WHERE NAME = ? AND CODE = ?");
    }

    @Test
    public void testUpdateWithMissingFieldBasedOnCompoundUpdateKey() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-without-code.json", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertJSONToSQL.REL_FAILURE, 1);
    }

    @Test
    public void testUpdateWithMalformedJson() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/malformed-person-extra-comma.json", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertJSONToSQL.REL_FAILURE, 1);
    }

    @Test
    public void testInsertWithMissingField() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-without-id.json", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertJSONToSQL.REL_FAILURE, 1);
    }

    @Test
    public void testInsertWithMissingColumnFail() throws InitializationException, ProcessException, SQLException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        try (Connection conn = service.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TABLE PERSONS3 (id integer, name varchar(100), code integer, generated_key integer primary key)");
        }
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS3");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_COLUMN_BEHAVIOR, ConvertJSONToSQL.FAIL_UNMATCHED_COLUMN);
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertJSONToSQL.REL_FAILURE, 1);
    }

    @Test
    public void testInsertWithMissingColumnWarning() throws InitializationException, ProcessException, SQLException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        try (Connection conn = service.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TABLE PERSONS2 (id integer, name varchar(100), code integer, generated_key integer primary key)");
        }
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS2");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_COLUMN_BEHAVIOR, ConvertJSONToSQL.WARNING_UNMATCHED_COLUMN);
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO PERSONS2 (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testInsertWithMissingColumnIgnore() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_COLUMN_BEHAVIOR, "Ignore Unmatched Columns");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO PERSONS (ID, NAME, CODE) VALUES (?, ?, ?)");
    }

    @Test
    public void testUpdateWithMissingColumnFail() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code, extra");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_COLUMN_BEHAVIOR, ConvertJSONToSQL.FAIL_UNMATCHED_COLUMN);
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ConvertJSONToSQL.REL_FAILURE, 1);
    }

    @Test
    public void testUpdateWithMissingColumnWarning() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code, extra");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_COLUMN_BEHAVIOR, ConvertJSONToSQL.WARNING_UNMATCHED_COLUMN);
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("UPDATE PERSONS SET ID = ? WHERE NAME = ? AND CODE = ?");
    }

    @Test
    public void testUpdateWithMissingColumnIgnore() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "UPDATE");
        runner.setProperty(ConvertJSONToSQL.UPDATE_KEY, "name,  code, extra");
        runner.setProperty(ConvertJSONToSQL.UNMATCHED_COLUMN_BEHAVIOR, "Ignore Unmatched Columns");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("UPDATE PERSONS SET ID = ? WHERE NAME = ? AND CODE = ?");
    }

    @Test
    public void testCreateSqlStringValue() throws ProcessException, SQLException, IOException, InitializationException {
        TestRunner putSqlRunner = TestRunners.newTestRunner(PutSQL.class);
        AtomicInteger id = new AtomicInteger(20);
        putSqlRunner.addControllerService("dbcp", (ControllerService)service);
        putSqlRunner.enableControllerService((ControllerService)service);
        putSqlRunner.setProperty(PutSQL.OBTAIN_GENERATED_KEYS, "false");
        putSqlRunner.setProperty(PutSQL.CONNECTION_POOL, "dbcp");
        String tableName = "DIFTYPES";
        ObjectMapper mapper = new ObjectMapper();
        try (Connection conn = service.getConnection();){
            try (Statement stmt = conn.createStatement();){
                String createDifferentTypes = "CREATE TABLE DIFTYPES (id integer primary key, b boolean, f float, dbl double, dcml decimal, d date)";
                stmt.executeUpdate(createDifferentTypes);
            }
            ResultSet colrs = conn.getMetaData().getColumns(null, null, tableName, "%");
            while (colrs.next()) {
                int sqlType = colrs.getInt("DATA_TYPE");
                int colSize = colrs.getInt("COLUMN_SIZE");
                switch (sqlType) {
                    case 16: {
                        String json = mapper.writeValueAsString((Object)"true");
                        JsonNode fieldNode = mapper.readTree(json);
                        String booleanString = ConvertJSONToSQL.createSqlStringValue((JsonNode)fieldNode, (Integer)colSize, (int)sqlType);
                        Assertions.assertEquals((Object)"true", (Object)booleanString);
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("sql.args.1.type", String.valueOf(sqlType));
                        attributes.put("sql.args.1.value", booleanString);
                        byte[] data = ("INSERT INTO DIFTYPES (ID, B) VALUES (" + id.incrementAndGet() + ", ?)").getBytes();
                        putSqlRunner.enqueue(data, attributes);
                        putSqlRunner.run();
                        List failed = putSqlRunner.getFlowFilesForRelationship(PutSQL.REL_FAILURE);
                        putSqlRunner.assertTransferCount(PutSQL.REL_SUCCESS, 1);
                        putSqlRunner.assertTransferCount(PutSQL.REL_FAILURE, 0);
                        putSqlRunner.clearTransferState();
                        break;
                    }
                    case 6: 
                    case 8: {
                        String json = mapper.writeValueAsString((Object)"78895654.6575");
                        JsonNode fieldNode = mapper.readTree(json);
                        String numberString = ConvertJSONToSQL.createSqlStringValue((JsonNode)fieldNode, (Integer)colSize, (int)sqlType);
                        Assertions.assertEquals((Object)"78895654.6575", (Object)numberString);
                        HashMap<String, String> attributes = new HashMap();
                        attributes.put("sql.args.1.type", String.valueOf(sqlType));
                        attributes.put("sql.args.1.value", numberString);
                        byte[] data = ("INSERT INTO DIFTYPES (ID, dbl) VALUES (" + id.incrementAndGet() + ", ?)").getBytes();
                        putSqlRunner.enqueue(data, attributes);
                        putSqlRunner.run();
                        List failed = putSqlRunner.getFlowFilesForRelationship(PutSQL.REL_FAILURE);
                        putSqlRunner.assertTransferCount(PutSQL.REL_SUCCESS, 1);
                        putSqlRunner.assertTransferCount(PutSQL.REL_FAILURE, 0);
                        putSqlRunner.clearTransferState();
                        break;
                    }
                }
            }
        }
    }

    @Test
    public void testDelete() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "DELETE");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("DELETE FROM PERSONS WHERE ID = ? AND NAME = ? AND CODE = ?");
    }

    @Test
    public void testDeleteQuotedIdentifiers() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "DELETE");
        runner.setProperty(ConvertJSONToSQL.QUOTED_IDENTIFIERS, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("DELETE FROM PERSONS WHERE \"ID\" = ? AND \"NAME\" = ? AND \"CODE\" = ?");
    }

    @Test
    public void testDeleteQuotedTableIdentifier() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "DELETE");
        runner.setProperty(ConvertJSONToSQL.QUOTED_TABLE_IDENTIFIER, "true");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "48");
        out.assertContentEquals("DELETE FROM \"PERSONS\" WHERE ID = ? AND NAME = ? AND CODE = ?");
    }

    @Test
    public void testDeleteWithNullValue() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "DELETE");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-with-null-code.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.1.value", "1");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.2.value", "Mark");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeNotExists("sql.args.3.value");
        out.assertContentEquals("DELETE FROM PERSONS WHERE ID = ? AND NAME = ? AND CODE = ?");
    }

    @Test
    public void testAttributePrefix() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "INSERT");
        runner.setProperty(ConvertJSONToSQL.QUOTED_IDENTIFIERS, "true");
        runner.setProperty(ConvertJSONToSQL.SQL_PARAM_ATTR_PREFIX, "hiveql");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]));
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("hiveql.args.1.type", String.valueOf(4));
        out.assertAttributeEquals("hiveql.args.1.value", "1");
        out.assertAttributeEquals("hiveql.args.2.type", String.valueOf(12));
        out.assertAttributeEquals("hiveql.args.2.value", "Mark");
        out.assertAttributeEquals("hiveql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("hiveql.args.3.value", "48");
        out.assertContentEquals("INSERT INTO PERSONS (\"ID\", \"NAME\", \"CODE\") VALUES (?, ?, ?)");
    }

    @Test
    public void testUpdateStatementTypeWithStatementTypeAttribute() throws InitializationException, ProcessException, IOException {
        TestRunner runner = TestRunners.newTestRunner(ConvertJSONToSQL.class);
        runner.addControllerService("dbcp", (ControllerService)service);
        runner.enableControllerService((ControllerService)service);
        runner.setProperty(ConvertJSONToSQL.CONNECTION_POOL, "dbcp");
        runner.setProperty(ConvertJSONToSQL.TABLE_NAME, "PERSONS");
        runner.setProperty(ConvertJSONToSQL.STATEMENT_TYPE, "Use statement.type Attribute");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("statement.type", "UPDATE");
        runner.enqueue(Paths.get("src/test/resources/TestConvertJSONToSQL/person-1.json", new String[0]), attrs);
        runner.run();
        runner.assertTransferCount(ConvertJSONToSQL.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_ORIGINAL).get(0)).assertAttributeEquals(FragmentAttributes.FRAGMENT_COUNT.key(), "1");
        runner.assertTransferCount(ConvertJSONToSQL.REL_SQL, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ConvertJSONToSQL.REL_SQL).get(0);
        out.assertAttributeEquals("sql.args.1.type", String.valueOf(12));
        out.assertAttributeEquals("sql.args.1.value", "Mark");
        out.assertAttributeEquals("sql.args.2.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.2.value", "48");
        out.assertAttributeEquals("sql.args.3.type", String.valueOf(4));
        out.assertAttributeEquals("sql.args.3.value", "1");
        out.assertContentEquals("UPDATE PERSONS SET NAME = ?, CODE = ? WHERE ID = ?");
    }

    private File getEmptyDirectory() {
        String randomDirectory = String.format("%s-%s", this.getClass().getSimpleName(), UUID.randomUUID());
        return Paths.get(TestConvertJSONToSQL.getSystemTemporaryDirectory(), randomDirectory).toFile();
    }

    private static String getSystemTemporaryDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    private static class MockDBCPService
    extends AbstractControllerService
    implements DBCPService {
        private final String dbLocation;

        public MockDBCPService(String dbLocation) {
            this.dbLocation = dbLocation;
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                Connection con = DriverManager.getConnection("jdbc:derby:" + this.dbLocation + ";create=true");
                return con;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

