/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.util.Arrays;
import java.util.List;
import org.apache.nifi.processors.standard.ftp.filesystem.DefaultVirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualFileSystem;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualPath;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestVirtualFileSystem {
    private VirtualFileSystem fileSystem;
    private static final List<VirtualPath> ORIGINAL_DIRECTORY_LIST = Arrays.asList(new VirtualPath("/"), new VirtualPath("/Directory1"), new VirtualPath("/Directory1/SubDirectory1"), new VirtualPath("/Directory1/SubDirectory1/SubSubDirectory"), new VirtualPath("/Directory1/SubDirectory2"), new VirtualPath("/Directory2"), new VirtualPath("/Directory2/SubDirectory3"), new VirtualPath("/Directory2/SubDirectory4"));

    @BeforeEach
    public void setup() {
        this.setupVirtualDirectoryStructure();
    }

    private void setupVirtualDirectoryStructure() {
        this.fileSystem = new DefaultVirtualFileSystem();
        for (VirtualPath directory : ORIGINAL_DIRECTORY_LIST) {
            if (directory.equals((Object)VirtualFileSystem.ROOT)) continue;
            this.fileSystem.mkdir(directory);
        }
    }

    @Test
    public void testTryToCreateDirectoryWithNonExistentParents() {
        VirtualPath newDirectory = new VirtualPath("/Directory3/SubDirectory5/SubSubDirectory");
        boolean directoryCreated = this.fileSystem.mkdir(newDirectory);
        Assertions.assertFalse((boolean)directoryCreated);
        this.assertAllDirectoriesAre(ORIGINAL_DIRECTORY_LIST);
    }

    @Test
    public void testListContentsOfDirectory() {
        VirtualPath parent = new VirtualPath("/Directory1");
        Object[] expectedSubDirectories = new VirtualPath[]{new VirtualPath("/Directory1/SubDirectory1"), new VirtualPath("/Directory1/SubDirectory2")};
        List subDirectories = this.fileSystem.listChildren(parent);
        MatcherAssert.assertThat((Object)subDirectories, (Matcher)Matchers.containsInAnyOrder((Object[])expectedSubDirectories));
    }

    @Test
    public void testListContentsOfRoot() {
        VirtualPath parent = new VirtualPath("/");
        Object[] expectedSubDirectories = new VirtualPath[]{new VirtualPath("/Directory1"), new VirtualPath("/Directory2")};
        List subDirectories = this.fileSystem.listChildren(parent);
        MatcherAssert.assertThat((Object)subDirectories, (Matcher)Matchers.containsInAnyOrder((Object[])expectedSubDirectories));
    }

    @Test
    public void testListContentsOfEmptyDirectory() {
        VirtualPath parent = new VirtualPath("/Directory2/SubDirectory3");
        List subDirectories = this.fileSystem.listChildren(parent);
        Assertions.assertEquals((int)0, (int)subDirectories.size());
    }

    @Test
    public void testTryToDeleteNonEmptyDirectory() {
        boolean success = this.fileSystem.delete(new VirtualPath("/Directory1"));
        Assertions.assertFalse((boolean)success);
        this.assertAllDirectoriesAre(ORIGINAL_DIRECTORY_LIST);
    }

    @Test
    public void testDeleteEmptyDirectory() {
        List<VirtualPath> expectedRemainingDirectories = Arrays.asList(new VirtualPath("/"), new VirtualPath("/Directory1"), new VirtualPath("/Directory1/SubDirectory1"), new VirtualPath("/Directory1/SubDirectory1/SubSubDirectory"), new VirtualPath("/Directory1/SubDirectory2"), new VirtualPath("/Directory2"), new VirtualPath("/Directory2/SubDirectory4"));
        boolean success = this.fileSystem.delete(new VirtualPath("/Directory2/SubDirectory3"));
        Assertions.assertTrue((boolean)success);
        this.assertAllDirectoriesAre(expectedRemainingDirectories);
    }

    @Test
    public void testDeleteRoot() {
        boolean success = this.fileSystem.delete(VirtualFileSystem.ROOT);
        Assertions.assertFalse((boolean)success);
        this.assertAllDirectoriesAre(ORIGINAL_DIRECTORY_LIST);
    }

    @Test
    public void testDeleteNonExistentDirectory() {
        boolean success = this.fileSystem.delete(new VirtualPath("/Directory3"));
        Assertions.assertFalse((boolean)success);
        this.assertAllDirectoriesAre(ORIGINAL_DIRECTORY_LIST);
    }

    private void assertAllDirectoriesAre(List<VirtualPath> expectedDirectories) {
        if (expectedDirectories.size() != this.fileSystem.getTotalNumberOfFiles()) {
            Assertions.fail();
        } else {
            for (VirtualPath path : expectedDirectories) {
                if (this.fileSystem.exists(path)) continue;
                Assertions.fail();
            }
        }
    }
}

