/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Paths;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.HashContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHashContent {
    @Test
    public void testSHA256() throws IOException {
        this.test("SHA-256", "dffd6021bb2bd5b0af676290809ec3a53191dd81c7f70a4b28688a362182986f");
    }

    private void test(String hashAlgorithm, String expectedHash) throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new HashContent());
        runner.setProperty(HashContent.ATTRIBUTE_NAME, "hash");
        runner.setProperty(HashContent.HASH_ALGORITHM, hashAlgorithm);
        runner.enqueue(Paths.get("src/test/resources/hello.txt", new String[0]));
        runner.run();
        runner.assertQueueEmpty();
        runner.assertAllFlowFilesTransferred(HashContent.REL_SUCCESS, 1);
        MockFlowFile outFile = (MockFlowFile)runner.getFlowFilesForRelationship(HashContent.REL_SUCCESS).get(0);
        String hashValue = outFile.getAttribute("hash");
        Assertions.assertEquals((Object)expectedHash, (Object)hashValue);
    }
}

