/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.EncryptContent;
import org.apache.nifi.security.util.crypto.OpenPGPPasswordBasedEncryptor;
import org.bouncycastle.shaded.bcpg.ArmoredOutputStream;
import org.bouncycastle.shaded.openpgp.PGPCompressedData;
import org.bouncycastle.shaded.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPEncryptedDataList;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPLiteralData;
import org.bouncycastle.shaded.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPObjectFactory;
import org.bouncycastle.shaded.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.shaded.openpgp.PGPPrivateKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyRing;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPSecretKey;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRing;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.shaded.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.shaded.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPGPKeyBasedEncryptor
implements EncryptContent.Encryptor {
    private static final Logger logger = LoggerFactory.getLogger(OpenPGPPasswordBasedEncryptor.class);
    private String algorithm;
    private Integer cipher;
    private String provider;
    private String keyring;
    private String userId;
    private char[] passphrase;
    private String filename;

    public OpenPGPKeyBasedEncryptor(String algorithm, Integer cipher, String provider, String keyring, String userId, char[] passphrase, String filename) {
        this.algorithm = algorithm;
        this.cipher = cipher;
        this.provider = provider;
        this.keyring = keyring;
        this.userId = userId;
        this.passphrase = passphrase;
        this.filename = filename;
    }

    @Override
    public void updateAttributes(Map<String, String> attributes) throws ProcessException {
    }

    @Override
    public StreamCallback getEncryptionCallback() throws Exception {
        return new OpenPGPEncryptCallback(this.algorithm, this.cipher, this.provider, this.keyring, this.userId, this.filename);
    }

    @Override
    public StreamCallback getDecryptionCallback() throws Exception {
        return new OpenPGPDecryptCallback(this.provider, this.keyring, this.passphrase);
    }

    public static boolean validateKeyring(String provider, String secretKeyringFile, char[] passphrase) throws IOException, PGPException, NoSuchProviderException {
        try {
            OpenPGPKeyBasedEncryptor.getDecryptedPrivateKey(provider, secretKeyringFile, passphrase);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static PGPPrivateKey getDecryptedPrivateKey(String provider, String secretKeyringFile, char[] passphrase) throws IOException, PGPException {
        return OpenPGPKeyBasedEncryptor.getDecryptedPrivateKey(provider, secretKeyringFile, 0L, passphrase);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PGPPrivateKey getDecryptedPrivateKey(String provider, String secretKeyringFile, long keyId, char[] passphrase) throws IOException, PGPException {
        keyInputStream = new FileInputStream(secretKeyringFile);
        try {
            pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection((InputStream)keyInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            decryptor = new JcePBESecretKeyDecryptorBuilder().setProvider(provider).build(passphrase);
            keyringIterator = pgpSecretKeyRingCollection.getKeyRings();
            while (true) {
                if (keyringIterator.hasNext() == false) throw new PGPException("No private key available using passphrase");
                keyRing = (PGPSecretKeyRing)keyringIterator.next();
                if (keyId != 0L) {
                    secretKey = keyRing.getSecretKey(keyId);
                    try {
                        var11_12 = secretKey.extractPrivateKey(decryptor);
                        return var11_12;
                    }
                    catch (Exception e) {
                        throw new PGPException("No private key available using passphrase", e);
                    }
                }
                keyIterator = keyRing.getSecretKeys();
                break;
            }
        }
        finally {
            keyInputStream.close();
        }
        while (true) {
            if (!keyIterator.hasNext()) ** continue;
            secretKey = (PGPSecretKey)keyIterator.next();
            try {
                return secretKey.extractPrivateKey(decryptor);
            }
            catch (Exception var12_14) {
                continue;
            }
            break;
        }
    }

    public static PGPPublicKey getPublicKey(String userId, String publicKeyringFile) throws IOException, PGPException {
        try (FileInputStream keyInputStream = new FileInputStream(publicKeyringFile);){
            PGPPublicKeyRingCollection pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection((InputStream)keyInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            Iterator iter = pgpPublicKeyRingCollection.getKeyRings();
            while (iter.hasNext()) {
                PGPPublicKeyRing keyRing = (PGPPublicKeyRing)iter.next();
                Iterator keyIter = keyRing.getPublicKeys();
                while (keyIter.hasNext()) {
                    PGPPublicKey publicKey = (PGPPublicKey)keyIter.next();
                    Iterator userIdIterator = publicKey.getUserIDs();
                    while (userIdIterator.hasNext()) {
                        String id = (String)userIdIterator.next();
                        if (!userId.equalsIgnoreCase(id)) continue;
                        PGPPublicKey pGPPublicKey = publicKey;
                        return pGPPublicKey;
                    }
                }
            }
        }
        throw new PGPException("Could not find a public key with the given userId");
    }

    private static class OpenPGPEncryptCallback
    implements StreamCallback {
        private String algorithm;
        private Integer cipher;
        private String provider;
        private String publicKeyring;
        private String userId;
        private String filename;

        OpenPGPEncryptCallback(String algorithm, Integer cipher, String provider, String keyring, String userId, String filename) {
            this.algorithm = algorithm;
            this.cipher = cipher;
            this.provider = provider;
            this.publicKeyring = keyring;
            this.userId = userId;
            this.filename = filename;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(InputStream in, OutputStream out) throws IOException {
            PGPPublicKey publicKey;
            boolean isArmored = EncryptContent.isPGPArmoredAlgorithm(this.algorithm);
            try {
                publicKey = OpenPGPKeyBasedEncryptor.getPublicKey(this.userId, this.publicKeyring);
            }
            catch (Exception e) {
                throw new ProcessException("Invalid public keyring - " + e.getMessage());
            }
            try {
                OutputStream output = out;
                if (isArmored) {
                    output = new ArmoredOutputStream(out);
                }
                try {
                    PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(this.cipher.intValue()).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider(this.provider));
                    encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(publicKey).setProvider(this.provider));
                    try (OutputStream encryptedOut = encryptedDataGenerator.open(output, new byte[65536]);){
                        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1, 1);
                        try (OutputStream compressedOut = compressedDataGenerator.open(encryptedOut, new byte[65536]);){
                            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
                            try (OutputStream literalOut = literalDataGenerator.open(compressedOut, 'b', this.filename, new Date(), new byte[65536]);){
                                int len;
                                byte[] buffer = new byte[4096];
                                while ((len = in.read(buffer)) >= 0) {
                                    literalOut.write(buffer, 0, len);
                                }
                            }
                        }
                    }
                }
                finally {
                    if (isArmored) {
                        output.close();
                    }
                }
            }
            catch (Exception e) {
                throw new ProcessException(e.getMessage());
            }
        }
    }

    private static class OpenPGPDecryptCallback
    implements StreamCallback {
        private String provider;
        private String secretKeyringFile;
        private char[] passphrase;

        OpenPGPDecryptCallback(String provider, String secretKeyringFile, char[] passphrase) {
            this.provider = provider;
            this.secretKeyringFile = secretKeyringFile;
            this.passphrase = passphrase;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try (InputStream pgpin = PGPUtil.getDecoderStream((InputStream)in);){
                PGPObjectFactory pgpFactory = new PGPObjectFactory(pgpin, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                Object obj = pgpFactory.nextObject();
                if (!(obj instanceof PGPEncryptedDataList) && !((obj = pgpFactory.nextObject()) instanceof PGPEncryptedDataList)) {
                    throw new ProcessException("Invalid OpenPGP data");
                }
                PGPEncryptedDataList encList = (PGPEncryptedDataList)obj;
                try {
                    PGPPrivateKey privateKey = null;
                    PGPPublicKeyEncryptedData encData = null;
                    Iterator it = encList.getEncryptedDataObjects();
                    while (privateKey == null && it.hasNext()) {
                        obj = it.next();
                        if (!(obj instanceof PGPPublicKeyEncryptedData)) {
                            throw new ProcessException("Invalid OpenPGP data");
                        }
                        encData = (PGPPublicKeyEncryptedData)obj;
                        try {
                            privateKey = OpenPGPKeyBasedEncryptor.getDecryptedPrivateKey(this.provider, this.secretKeyringFile, encData.getKeyID(), this.passphrase);
                        }
                        catch (PGPException pGPException) {}
                    }
                    if (privateKey == null) {
                        throw new ProcessException("Secret keyring does not contain the key required to decrypt");
                    }
                    PublicKeyDataDecryptorFactory dataDecryptor = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(this.provider).build(privateKey);
                    try (InputStream clear = encData.getDataStream(dataDecryptor);){
                        JcaPGPObjectFactory plainFact = new JcaPGPObjectFactory(clear);
                        Object message = plainFact.nextObject();
                        if (message instanceof PGPCompressedData) {
                            PGPCompressedData cData = (PGPCompressedData)message;
                            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(cData.getDataStream());
                            message = pgpFact.nextObject();
                        }
                        if (message instanceof PGPLiteralData) {
                            PGPLiteralData literalData = (PGPLiteralData)message;
                            try (InputStream lis = literalData.getInputStream();){
                                int len;
                                byte[] buffer = new byte[4096];
                                while ((len = lis.read(buffer)) >= 0) {
                                    out.write(buffer, 0, len);
                                }
                            }
                        } else {
                            if (message instanceof PGPOnePassSignatureList) {
                                throw new PGPException("encrypted message contains a signed message - not literal data.");
                            }
                            throw new PGPException("message is not a simple encrypted file - type unknown.");
                        }
                        if (encData.isIntegrityProtected()) {
                            if (!encData.verify()) {
                                throw new PGPException("Failed message integrity check");
                            }
                        } else {
                            logger.warn("No message integrity check");
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProcessException(e.getMessage());
                }
            }
        }
    }
}

