/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.nifi.logging.ComponentLog;

public class WrappedMessageConsumer {
    private final Connection connection;
    private final Session session;
    private final MessageConsumer consumer;
    private boolean closed = false;

    public WrappedMessageConsumer(Connection connection, Session jmsSession, MessageConsumer messageConsumer) {
        this.connection = connection;
        this.session = jmsSession;
        this.consumer = messageConsumer;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageConsumer getConsumer() {
        return this.consumer;
    }

    public void close(ComponentLog logger) {
        this.closed = true;
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            logger.warn("unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", (Throwable)e);
        }
        try {
            this.session.close();
        }
        catch (JMSException e) {
            logger.warn("unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", (Throwable)e);
        }
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            logger.warn("unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

