/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import java.util.Optional;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.UpdateCounter;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUpdateCounter {
    @Test
    public void testwithFileName() {
        TestRunner firstrunner = TestRunners.newTestRunner((Processor)new UpdateCounter());
        firstrunner.setProperty(UpdateCounter.COUNTER_NAME, "firewall");
        firstrunner.setProperty(UpdateCounter.DELTA, "1");
        HashMap attributes = new HashMap();
        firstrunner.enqueue("", attributes);
        firstrunner.run();
        firstrunner.assertAllFlowFilesTransferred(UpdateCounter.SUCCESS, 1);
    }

    @Test
    public void testExpressionLanguage() {
        TestRunner firstrunner = TestRunners.newTestRunner((Processor)new UpdateCounter());
        firstrunner.setProperty(UpdateCounter.COUNTER_NAME, "${filename}");
        firstrunner.setProperty(UpdateCounter.DELTA, "${num}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "test");
        attributes.put("num", "40");
        firstrunner.enqueue(new byte[0], attributes);
        firstrunner.run();
        Long counter = firstrunner.getCounterValue("test");
        Assertions.assertEquals(Optional.ofNullable(counter), Optional.ofNullable(40L));
        firstrunner.assertAllFlowFilesTransferred(UpdateCounter.SUCCESS, 1);
    }
}

