/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ModifyBytes;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestModifyBytes {
    private final Path testFilePath = Paths.get("src/test/resources/TestModifyBytes/testFile.txt", new String[0]);
    private final Path noFooterPath = Paths.get("src/test/resources/TestModifyBytes/noFooter.txt", new String[0]);
    private final Path noHeaderPath = Paths.get("src/test/resources/TestModifyBytes/noHeader.txt", new String[0]);
    private final Path noFooterNoHeaderPath = Paths.get("src/test/resources/TestModifyBytes/noFooter_noHeader.txt", new String[0]);
    private final File testFile = this.testFilePath.toFile();
    private final File noFooterFile = this.noFooterPath.toFile();
    private final File noHeaderFile = this.noHeaderPath.toFile();
    private final File noFooterNoHeaderFile = this.noFooterNoHeaderPath.toFile();

    @Test
    public void testReturnEmptyFile() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "1 MB");
        runner.setProperty(ModifyBytes.END_OFFSET, "1 MB");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        out.assertContentEquals("".getBytes("UTF-8"));
    }

    @Test
    public void testReturnSameFile() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "0 MB");
        runner.setProperty(ModifyBytes.END_OFFSET, "0 MB");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        out.assertContentEquals(this.testFile);
    }

    @Test
    public void testRemoveHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "12 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "0 MB");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        out.assertContentEquals(this.noHeaderFile);
    }

    @Test
    public void testRemoveHeaderEL() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "${numBytes}");
        runner.setProperty(ModifyBytes.END_OFFSET, "0 MB");
        runner.enqueue(this.testFilePath, (Map)new HashMap<String, String>(){
            {
                this.put("numBytes", "12 B");
            }
        });
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        out.assertContentEquals(this.noHeaderFile);
    }

    @Test
    public void testKeepFooter() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "181 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "0 B");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        out.assertContentEquals("<<<FOOTER>>>".getBytes("UTF-8"));
    }

    @Test
    public void testKeepHeader() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "0 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "181 B");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        out.assertContentEquals("<<<HEADER>>>".getBytes("UTF-8"));
    }

    @Test
    public void testKeepHeaderEL() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "0 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "${numBytes}");
        runner.enqueue(this.testFilePath, (Map)new HashMap<String, String>(){
            {
                this.put("numBytes", "181 B");
            }
        });
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        out.assertContentEquals("<<<HEADER>>>".getBytes("UTF-8"));
    }

    @Test
    public void testRemoveFooter() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "0 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "12 B");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        out.assertContentEquals(this.noFooterFile);
    }

    @Test
    public void testRemoveHeaderAndFooter() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "12 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "12 B");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        out.assertContentEquals(this.noFooterNoHeaderFile);
    }

    @Test
    public void testReturnZeroByteFile() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "97 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "97 B");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        out.assertContentEquals("".getBytes("UTF-8"));
    }

    @Test
    public void testDew() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "94 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "96 B");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        String outContent = new String(out.toByteArray(), StandardCharsets.UTF_8);
        System.out.println(outContent);
        out.assertContentEquals("Dew".getBytes("UTF-8"));
    }

    @Test
    public void testRemoveAllContent() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "0 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "0 B");
        runner.setProperty(ModifyBytes.REMOVE_ALL, "true");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        Assertions.assertEquals((long)0L, (long)out.getSize());
    }

    @Test
    public void testRemoveAllOverridesWhenSet() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "10 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "10 B");
        runner.setProperty(ModifyBytes.REMOVE_ALL, "true");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        Assertions.assertEquals((long)0L, (long)out.getSize());
    }

    @Test
    public void testRemoveAllNoOverridesWhenFalse() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.START_OFFSET, "10 B");
        runner.setProperty(ModifyBytes.END_OFFSET, "10 B");
        runner.setProperty(ModifyBytes.REMOVE_ALL, "false");
        runner.enqueue(this.testFilePath);
        runner.run();
        runner.assertAllFlowFilesTransferred(ModifyBytes.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ModifyBytes.REL_SUCCESS).get(0);
        Assertions.assertEquals((long)(this.testFile.length() - 20L), (long)out.getSize());
    }

    @Test
    public void testCheckAllowableValues() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ModifyBytes());
        runner.setProperty(ModifyBytes.REMOVE_ALL, "maybe");
        runner.assertNotValid();
        runner.setProperty(ModifyBytes.REMOVE_ALL, "true");
        runner.assertValid();
        runner.setProperty(ModifyBytes.REMOVE_ALL, "false");
        runner.assertValid();
        runner.setProperty(ModifyBytes.REMOVE_ALL, "certainly");
        runner.assertNotValid();
    }
}

