/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processors.standard.DeleteFile;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class TestDeleteFile {
    private final TestRunner runner = TestRunners.newTestRunner(DeleteFile.class);
    @TempDir
    private Path testDirectory;

    TestDeleteFile() {
    }

    @Test
    void deletesExistingFile() throws IOException {
        Path directoryPath = this.testDirectory.toAbsolutePath();
        String filename = "test.txt";
        MockFlowFile enqueuedFlowFile = this.enqueue(directoryPath.toString(), "test.txt");
        Path fileToDelete = Files.write(this.testDirectory.resolve("test.txt"), "some text".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        TestDeleteFile.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteFile.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteFile.REL_SUCCESS, 1);
        this.runner.assertAllFlowFiles(DeleteFile.REL_SUCCESS, flowFileInRelationship -> Assertions.assertEquals((Object)enqueuedFlowFile, (Object)flowFileInRelationship));
        this.runner.assertProvenanceEvent(ProvenanceEventType.REMOTE_INVOCATION);
    }

    @Test
    void deletesExistingEmptyDirectory() throws IOException {
        Path directoryPath = this.testDirectory.toAbsolutePath();
        String filename = "test-directory";
        this.enqueue(directoryPath.toString(), "test-directory");
        Path fileToDelete = Files.createDirectory(this.testDirectory.resolve("test-directory"), new FileAttribute[0]);
        TestDeleteFile.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteFile.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteFile.REL_SUCCESS);
    }

    @Test
    void sendsFlowFileToNotFoundWhenFileDoesNotExist() {
        Path directoryPath = this.testDirectory.toAbsolutePath();
        String filename = "test.txt";
        this.enqueue(directoryPath.toString(), "test.txt");
        Path fileToDelete = this.testDirectory.resolve("test.txt");
        TestDeleteFile.assertNotExists(fileToDelete);
        this.runner.run();
        TestDeleteFile.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteFile.REL_NOT_FOUND);
    }

    @Test
    void sendsFlowFileToNotFoundWhenDirectoryDoesNotExist() {
        Path directoryPath = this.testDirectory.resolve("non-existing-directory").toAbsolutePath();
        String filename = "test.txt";
        this.enqueue(directoryPath.toString(), "test.txt");
        Path fileToDelete = this.testDirectory.resolve("test.txt");
        TestDeleteFile.assertNotExists(fileToDelete);
        this.runner.run();
        TestDeleteFile.assertNotExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteFile.REL_NOT_FOUND);
    }

    @Test
    void sendsFlowFileToFailureWhenTargetIsAnNonEmptyDirectory() throws IOException {
        Path directoryPath = this.testDirectory.toAbsolutePath();
        String filename = "test-directory";
        this.enqueue(directoryPath.toString(), "test-directory");
        Path fileToDelete = Files.createDirectory(this.testDirectory.resolve("test-directory"), new FileAttribute[0]);
        Files.write(this.testDirectory.resolve("test-directory").resolve("disturbance"), "not empty".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        TestDeleteFile.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteFile.assertExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteFile.REL_FAILURE);
        this.runner.assertPenalizeCount(1);
    }

    @Test
    void sendsFlowFileToFailureWhenFileIsNotADirectChildOfTheDirectory() throws IOException {
        Path directory = Files.createDirectory(this.testDirectory.resolve("test-directory"), new FileAttribute[0]).toAbsolutePath();
        String filename = "../sibling.txt";
        this.enqueue(directory.toString(), "../sibling.txt");
        Path fileToDelete = Files.write(directory.resolve("../sibling.txt"), "sibling content".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        TestDeleteFile.assertExists(fileToDelete);
        this.runner.run();
        TestDeleteFile.assertExists(fileToDelete);
        this.runner.assertAllFlowFilesTransferred(DeleteFile.REL_FAILURE, 1);
        this.runner.assertPenalizeCount(1);
    }

    private MockFlowFile enqueue(String directoryPath, String filename) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.ABSOLUTE_PATH.key(), directoryPath);
        attributes.put(CoreAttributes.FILENAME.key(), filename);
        return this.runner.enqueue("data", attributes);
    }

    private static void assertNotExists(Path filePath) {
        Assertions.assertTrue((boolean)Files.notExists(filePath, new LinkOption[0]), () -> "File " + filePath + "still exists");
    }

    private static void assertExists(Path filePath) {
        Assertions.assertTrue((boolean)Files.exists(filePath, new LinkOption[0]), () -> "File " + filePath + "does not exist");
    }
}

