/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.socket;

import com.exceptionfactory.socketbroker.BrokeredSocketFactory;
import java.net.Proxy;
import javax.net.SocketFactory;
import org.apache.nifi.processors.standard.socket.ProxySocketFactory;
import org.apache.nifi.processors.standard.socket.StandardSocketFactoryProvider;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StandardSocketFactoryProviderTest {
    private static final String HOST = "localhost";
    private static final int PORT = 1080;
    private static final String USERNAME = "user";
    private static final String PASSWORD = "password";
    private StandardSocketFactoryProvider provider;

    @BeforeEach
    public void setProvider() {
        this.provider = new StandardSocketFactoryProvider();
    }

    @Test
    public void testGetSocketFactoryWithoutCredentials() {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        proxyConfiguration.setProxyType(Proxy.Type.SOCKS);
        proxyConfiguration.setProxyServerHost(HOST);
        proxyConfiguration.setProxyServerPort(Integer.valueOf(1080));
        SocketFactory socketFactory = this.provider.getSocketFactory(proxyConfiguration);
        Assertions.assertEquals(ProxySocketFactory.class, socketFactory.getClass());
    }

    @Test
    public void testGetSocketFactoryWithUsername() {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        proxyConfiguration.setProxyType(Proxy.Type.SOCKS);
        proxyConfiguration.setProxyServerHost(HOST);
        proxyConfiguration.setProxyServerPort(Integer.valueOf(1080));
        proxyConfiguration.setProxyUserName(USERNAME);
        SocketFactory socketFactory = this.provider.getSocketFactory(proxyConfiguration);
        Assertions.assertEquals(BrokeredSocketFactory.class, socketFactory.getClass());
    }

    @Test
    public void testGetSocketFactoryWithUsernamePassword() {
        ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
        proxyConfiguration.setProxyType(Proxy.Type.SOCKS);
        proxyConfiguration.setProxyServerHost(HOST);
        proxyConfiguration.setProxyServerPort(Integer.valueOf(1080));
        proxyConfiguration.setProxyUserName(USERNAME);
        proxyConfiguration.setProxyUserPassword(PASSWORD);
        SocketFactory socketFactory = this.provider.getSocketFactory(proxyConfiguration);
        Assertions.assertEquals(BrokeredSocketFactory.class, socketFactory.getClass());
    }
}

