/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.UpdateDatabaseTable;
import org.apache.nifi.processors.standard.db.impl.DerbyDatabaseAdapter;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestUpdateDatabaseTable {
    private static final String createPersons = "CREATE TABLE \"persons\" (\"id\" integer primary key, \"name\" varchar(100), \"code\" integer)";
    @TempDir
    public static File tempDir;
    private static String derbyErrorFile;
    private TestRunner runner;
    private UpdateDatabaseTable processor;
    private static DBCPService service;

    @BeforeAll
    public static void setupClass() throws ProcessException {
        derbyErrorFile = System.getProperty("derby.stream.error.file", "");
        System.setProperty("derby.stream.error.file", "target/derby.log");
        File dbDir = new File(tempDir, "db");
        service = new MockDBCPService(dbDir.getAbsolutePath());
    }

    @AfterAll
    public static void restoreDefaults() {
        System.setProperty("derby.stream.error.file", derbyErrorFile);
        File dbDir = new File(tempDir, "db");
        dbDir.deleteOnExit();
        try {
            DriverManager.getConnection("jdbc:derby:" + dbDir + ";shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @BeforeEach
    public void setup() {
        this.processor = new UpdateDatabaseTable();
        try (Statement s = service.getConnection().createStatement();){
            s.execute("DROP TABLE \"persons\"");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTable() throws Exception {
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        MockRecordParser readerFactory = new MockRecordParser();
        readerFactory.addSchemaField(new RecordField("id", RecordFieldType.INT.getDataType(), false));
        readerFactory.addSchemaField(new RecordField("name", RecordFieldType.STRING.getDataType(), true));
        readerFactory.addSchemaField(new RecordField("code", RecordFieldType.INT.getDataType(), (Object)0, true));
        readerFactory.addSchemaField(new RecordField("newField", RecordFieldType.STRING.getDataType(), (Object)0, true));
        readerFactory.addRecord(new Object[]{1, "name1", 10});
        this.runner.addControllerService("mock-reader-factory", (ControllerService)readerFactory);
        this.runner.enableControllerService((ControllerService)readerFactory);
        this.runner.setProperty(UpdateDatabaseTable.RECORD_READER, "mock-reader-factory");
        this.runner.setProperty(UpdateDatabaseTable.TABLE_NAME, "${table.name}");
        this.runner.setProperty(UpdateDatabaseTable.CREATE_TABLE, UpdateDatabaseTable.CREATE_IF_NOT_EXISTS);
        this.runner.setProperty(UpdateDatabaseTable.QUOTE_TABLE_IDENTIFIER, "false");
        this.runner.setProperty(UpdateDatabaseTable.QUOTE_COLUMN_IDENTIFIERS, "true");
        this.runner.setProperty(UpdateDatabaseTable.DB_TYPE, new DerbyDatabaseAdapter().getName());
        this.runner.addControllerService("dbcp", (ControllerService)service);
        this.runner.enableControllerService((ControllerService)service);
        this.runner.setProperty(UpdateDatabaseTable.DBCP_SERVICE, "dbcp");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("db.name", "default");
        attrs.put("table.name", "newTable");
        this.runner.enqueue(new byte[0], attrs);
        this.runner.run();
        this.runner.assertTransferCount(UpdateDatabaseTable.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateDatabaseTable.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals("output.table", "newTable");
        try (Statement s = service.getConnection().createStatement();){
            ResultSet rs = s.executeQuery("select * from sys.syscolumns where referenceid = (select tableid from sys.systables where tablename = 'NEWTABLE') order by columnnumber");
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((Object)"id", (Object)rs.getString(2));
            Assertions.assertEquals((int)1, (int)rs.getInt(3));
            Assertions.assertEquals((Object)"INTEGER NOT NULL", (Object)rs.getString(4));
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((Object)"name", (Object)rs.getString(2));
            Assertions.assertEquals((int)2, (int)rs.getInt(3));
            Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((Object)"code", (Object)rs.getString(2));
            Assertions.assertEquals((int)3, (int)rs.getInt(3));
            Assertions.assertEquals((Object)"INTEGER", (Object)rs.getString(4));
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((Object)"newField", (Object)rs.getString(2));
            Assertions.assertEquals((int)4, (int)rs.getInt(3));
            Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
            Assertions.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testAddColumnToExistingTable() throws Exception {
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        try (Connection conn = service.getConnection();){
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate(createPersons);
            }
            MockRecordParser readerFactory = new MockRecordParser();
            readerFactory.addSchemaField(new RecordField("id", RecordFieldType.INT.getDataType(), false));
            readerFactory.addSchemaField(new RecordField("name", RecordFieldType.STRING.getDataType(), true));
            readerFactory.addSchemaField(new RecordField("code", RecordFieldType.INT.getDataType(), (Object)0, true));
            readerFactory.addSchemaField(new RecordField("newField", RecordFieldType.STRING.getDataType(), (Object)0, true));
            readerFactory.addRecord(new Object[]{1, "name1", null, "test"});
            this.runner.addControllerService("mock-reader-factory", (ControllerService)readerFactory);
            this.runner.enableControllerService((ControllerService)readerFactory);
            this.runner.setProperty(UpdateDatabaseTable.RECORD_READER, "mock-reader-factory");
            this.runner.setProperty(UpdateDatabaseTable.TABLE_NAME, "${table.name}");
            this.runner.setProperty(UpdateDatabaseTable.CREATE_TABLE, UpdateDatabaseTable.FAIL_IF_NOT_EXISTS);
            this.runner.setProperty(UpdateDatabaseTable.QUOTE_TABLE_IDENTIFIER, "true");
            this.runner.setProperty(UpdateDatabaseTable.QUOTE_COLUMN_IDENTIFIERS, "false");
            this.runner.setProperty(UpdateDatabaseTable.DB_TYPE, new DerbyDatabaseAdapter().getName());
            this.runner.addControllerService("dbcp", (ControllerService)service);
            this.runner.enableControllerService((ControllerService)service);
            this.runner.setProperty(UpdateDatabaseTable.DBCP_SERVICE, "dbcp");
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("db.name", "default");
            attrs.put("table.name", "persons");
            this.runner.enqueue(new byte[0], attrs);
            this.runner.run();
            this.runner.assertTransferCount(UpdateDatabaseTable.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateDatabaseTable.REL_SUCCESS).get(0);
            flowFile.assertAttributeEquals("output.table", "persons");
            try (Statement s = conn.createStatement();){
                ResultSet rs = s.executeQuery("SELECT * FROM SYS.SYSCOLUMNS WHERE referenceid = (SELECT tableid FROM SYS.SYSTABLES WHERE tablename = 'persons') ORDER BY columnnumber");
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"id", (Object)rs.getString(2));
                Assertions.assertEquals((int)1, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER NOT NULL", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"name", (Object)rs.getString(2));
                Assertions.assertEquals((int)2, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"code", (Object)rs.getString(2));
                Assertions.assertEquals((int)3, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"NEWFIELD", (Object)rs.getString(2));
                Assertions.assertEquals((int)4, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
                Assertions.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testAddExistingColumnTranslateFieldNames() throws Exception {
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        try (Connection conn = service.getConnection();){
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate(createPersons);
            }
            MockRecordParser readerFactory = new MockRecordParser();
            readerFactory.addSchemaField(new RecordField("ID", RecordFieldType.INT.getDataType(), false));
            readerFactory.addSchemaField(new RecordField("NAME", RecordFieldType.STRING.getDataType(), true));
            readerFactory.addSchemaField(new RecordField("CODE", RecordFieldType.INT.getDataType(), (Object)0, true));
            readerFactory.addRecord(new Object[]{1, "name1", null, "test"});
            this.runner.addControllerService("mock-reader-factory", (ControllerService)readerFactory);
            this.runner.enableControllerService((ControllerService)readerFactory);
            this.runner.setProperty(UpdateDatabaseTable.RECORD_READER, "mock-reader-factory");
            this.runner.setProperty(UpdateDatabaseTable.TABLE_NAME, "${table.name}");
            this.runner.setProperty(UpdateDatabaseTable.CREATE_TABLE, UpdateDatabaseTable.FAIL_IF_NOT_EXISTS);
            this.runner.setProperty(UpdateDatabaseTable.TRANSLATE_FIELD_NAMES, "true");
            this.runner.setProperty(UpdateDatabaseTable.QUOTE_TABLE_IDENTIFIER, "true");
            this.runner.setProperty(UpdateDatabaseTable.QUOTE_COLUMN_IDENTIFIERS, "false");
            this.runner.setProperty(UpdateDatabaseTable.DB_TYPE, new DerbyDatabaseAdapter().getName());
            this.runner.addControllerService("dbcp", (ControllerService)service);
            this.runner.enableControllerService((ControllerService)service);
            this.runner.setProperty(UpdateDatabaseTable.DBCP_SERVICE, "dbcp");
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("db.name", "default");
            attrs.put("table.name", "persons");
            this.runner.enqueue(new byte[0], attrs);
            this.runner.run();
            this.runner.assertTransferCount(UpdateDatabaseTable.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateDatabaseTable.REL_SUCCESS).get(0);
            flowFile.assertAttributeEquals("output.table", "persons");
            try (Statement s = conn.createStatement();){
                ResultSet rs = s.executeQuery("SELECT * FROM SYS.SYSCOLUMNS WHERE referenceid = (SELECT tableid FROM SYS.SYSTABLES WHERE tablename = 'persons') ORDER BY columnnumber");
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"id", (Object)rs.getString(2));
                Assertions.assertEquals((int)1, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER NOT NULL", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"name", (Object)rs.getString(2));
                Assertions.assertEquals((int)2, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"code", (Object)rs.getString(2));
                Assertions.assertEquals((int)3, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER", (Object)rs.getString(4));
                Assertions.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testAddExistingColumnNoTranslateFieldNames() throws Exception {
        this.runner = TestRunners.newTestRunner((Processor)this.processor);
        try (Connection conn = service.getConnection();){
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate(createPersons);
                stmt.execute("ALTER TABLE \"persons\" ADD COLUMN \"ID\" INTEGER");
            }
            MockRecordParser readerFactory = new MockRecordParser();
            readerFactory.addSchemaField(new RecordField("ID", RecordFieldType.INT.getDataType(), false));
            readerFactory.addSchemaField(new RecordField("NAME", RecordFieldType.STRING.getDataType(), true));
            readerFactory.addSchemaField(new RecordField("code", RecordFieldType.INT.getDataType(), (Object)0, true));
            readerFactory.addRecord(new Object[]{1, "name1", null, "test"});
            this.runner.addControllerService("mock-reader-factory", (ControllerService)readerFactory);
            this.runner.enableControllerService((ControllerService)readerFactory);
            this.runner.setProperty(UpdateDatabaseTable.RECORD_READER, "mock-reader-factory");
            this.runner.setProperty(UpdateDatabaseTable.TABLE_NAME, "${table.name}");
            this.runner.setProperty(UpdateDatabaseTable.CREATE_TABLE, UpdateDatabaseTable.FAIL_IF_NOT_EXISTS);
            this.runner.setProperty(UpdateDatabaseTable.TRANSLATE_FIELD_NAMES, "false");
            this.runner.setProperty(UpdateDatabaseTable.QUOTE_TABLE_IDENTIFIER, "true");
            this.runner.setProperty(UpdateDatabaseTable.QUOTE_COLUMN_IDENTIFIERS, "false");
            this.runner.setProperty(UpdateDatabaseTable.DB_TYPE, new DerbyDatabaseAdapter().getName());
            this.runner.addControllerService("dbcp", (ControllerService)service);
            this.runner.enableControllerService((ControllerService)service);
            this.runner.setProperty(UpdateDatabaseTable.DBCP_SERVICE, "dbcp");
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("db.name", "default");
            attrs.put("table.name", "persons");
            this.runner.enqueue(new byte[0], attrs);
            this.runner.run();
            this.runner.assertTransferCount(UpdateDatabaseTable.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateDatabaseTable.REL_SUCCESS).get(0);
            flowFile.assertAttributeEquals("output.table", "persons");
            try (Statement s = conn.createStatement();){
                ResultSet rs = s.executeQuery("SELECT * FROM SYS.SYSCOLUMNS WHERE referenceid = (SELECT tableid FROM SYS.SYSTABLES WHERE tablename = 'persons') ORDER BY columnnumber");
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"id", (Object)rs.getString(2));
                Assertions.assertEquals((int)1, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER NOT NULL", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"name", (Object)rs.getString(2));
                Assertions.assertEquals((int)2, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"code", (Object)rs.getString(2));
                Assertions.assertEquals((int)3, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"ID", (Object)rs.getString(2));
                Assertions.assertEquals((int)4, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"INTEGER", (Object)rs.getString(4));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"NAME", (Object)rs.getString(2));
                Assertions.assertEquals((int)5, (int)rs.getInt(3));
                Assertions.assertEquals((Object)"VARCHAR(100)", (Object)rs.getString(4));
                Assertions.assertFalse((boolean)rs.next());
            }
        }
    }

    private static class MockDBCPService
    extends AbstractControllerService
    implements DBCPService {
        private final String dbLocation;

        public MockDBCPService(String dbLocation) {
            this.dbLocation = dbLocation;
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                return DriverManager.getConnection("jdbc:derby:" + this.dbLocation + ";create=true");
            }
            catch (Exception e) {
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

