/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.standard.relp.event.RELPMessage;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.frame.RELPFrameDecoder;
import org.apache.nifi.util.MockComponentLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RELPFrameDecoderTest {
    final ComponentLog logger = new MockComponentLog(this.getClass().getSimpleName(), (Object)this);
    public static final String OPEN_FRAME_DATA = "relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog";
    public static final String SYSLOG_FRAME_DATA = "this is a syslog message here";
    static final RELPFrame OPEN_FRAME = new RELPFrame.Builder().txnr(1L).command("open").dataLength("relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog".length()).data("relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog".getBytes(StandardCharsets.UTF_8)).build();
    static final RELPFrame SYSLOG_FRAME = new RELPFrame.Builder().txnr(2L).command("syslog").dataLength("this is a syslog message here".length()).data("this is a syslog message here".getBytes(StandardCharsets.UTF_8)).build();
    static final RELPFrame CLOSE_FRAME = new RELPFrame.Builder().txnr(3L).command("close").dataLength(0).data(new byte[0]).build();

    RELPFrameDecoderTest() {
    }

    @Test
    void testDecodeRELPEvents() throws IOException {
        List<RELPFrame> frames = this.getFrames(5);
        ByteBufOutputStream eventBytes = new ByteBufOutputStream(Unpooled.buffer());
        this.sendFrames(frames, (OutputStream)eventBytes);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RELPFrameDecoder(this.logger, StandardCharsets.UTF_8)});
        assert (channel.writeInbound(new Object[]{eventBytes.buffer()}));
        Assertions.assertEquals((int)5, (int)channel.inboundMessages().size());
        RELPMessage event = (RELPMessage)channel.readInbound();
        Assertions.assertEquals(RELPMessage.class, event.getClass());
        Assertions.assertEquals((Object)SYSLOG_FRAME_DATA, (Object)new String(event.getMessage(), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)2, (int)channel.outboundMessages().size());
    }

    private void sendFrames(List<RELPFrame> frames, OutputStream outputStream) throws IOException {
        RELPEncoder encoder = new RELPEncoder(StandardCharsets.UTF_8);
        for (RELPFrame frame : frames) {
            byte[] encodedFrame = encoder.encode(frame);
            outputStream.write(encodedFrame);
            outputStream.flush();
        }
    }

    private List<RELPFrame> getFrames(int syslogFrames) {
        ArrayList<RELPFrame> frames = new ArrayList<RELPFrame>();
        frames.add(OPEN_FRAME);
        for (int i = 0; i < syslogFrames; ++i) {
            frames.add(SYSLOG_FRAME);
        }
        frames.add(CLOSE_FRAME);
        return frames;
    }
}

