/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ExtractText;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExtractTextNamedGroups {
    final String SAMPLE_STRING = "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n";

    @Test
    public void testProcessor() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty("regex.result1", "(?s)(?<ALL>.*)");
        testRunner.setProperty("regex.result2", "(?s).*(?<BAR1>bar1).*");
        testRunner.setProperty("regex.result3", "(?s).*?(?<BAR1>bar\\d).*");
        testRunner.setProperty("regex.result4", "(?s).*?(?:bar\\d).*?(?<BAR2>bar\\d).*?(?<BAR3>bar3).*");
        testRunner.setProperty("regex.result5", "(?s).*(?<BAR3>bar\\d).*");
        testRunner.setProperty("regex.result6", "(?s)^(?<ALL>.*)$");
        testRunner.setProperty("regex.result7", "(?s)(?<MISS>XXX)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        Map attributes = out.getAttributes();
        out.assertAttributeEquals("regex.result1.ALL", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result2.BAR1", "bar1");
        out.assertAttributeEquals("regex.result3.BAR1", "bar1");
        out.assertAttributeEquals("regex.result4.BAR2", "bar2");
        out.assertAttributeEquals("regex.result4.BAR3", "bar3");
        out.assertAttributeEquals("regex.result5.BAR3", "bar3");
        out.assertAttributeEquals("regex.result6.ALL", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result7.MISS", null);
    }

    @Test
    public void testWithUnmatchedOptionalCapturingGroup() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty("regex", "abc(?<DEF>def)?(?<G>g)");
        testRunner.enqueue("abcg");
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeNotExists("regex.DEF");
        out.assertAttributeEquals("regex.G", "g");
        testRunner.clearTransferState();
        testRunner.enqueue("abcdefg");
        testRunner.run();
        MockFlowFile out2 = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out2.assertAttributeEquals("regex.DEF", "def");
        out2.assertAttributeEquals("regex.G", "g");
    }

    @Test
    public void testProcessorWithDotall() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty("regex.result1", "(?<TOUT>.*)");
        testRunner.setProperty("regex.result2", ".*(?<BAR1>bar1).*");
        testRunner.setProperty("regex.result3", ".*?(?<BAR1>bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(?<BAR2>bar\\d).*");
        testRunner.setProperty("regex.result5", ".*(?<BAR3>bar\\d).*");
        testRunner.setProperty("regex.result6", "^(?<TOUT>.*)$");
        testRunner.setProperty("regex.result7", "^(?<NO>XXX)$");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1.TOUT", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result2.BAR1", "bar1");
        out.assertAttributeEquals("regex.result3.BAR1", "bar1");
        out.assertAttributeEquals("regex.result4.BAR2", "bar2");
        out.assertAttributeEquals("regex.result5.BAR3", "bar3");
        out.assertAttributeEquals("regex.result6.TOUT", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result7.NO", null);
    }

    @Test
    public void testProcessorWithMultiline() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        testRunner.setProperty("regex.result1", "(?<ALL>.*)");
        testRunner.setProperty("regex.result2", "(?<BAR1>bar1)");
        testRunner.setProperty("regex.result3", ".*?(?<BAR1>bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(?<NULL>bar\\d).*");
        testRunner.setProperty("regex.result4b", "bar\\d\\r\\n(?<BAR2>bar\\d)");
        testRunner.setProperty("regex.result5", ".*(?<BAR2>bar\\d).*");
        testRunner.setProperty("regex.result5b", "(?:bar\\d\\r?\\n)*(?<BAR3>bar\\d)");
        testRunner.setProperty("regex.result6", "^(?<ALL>.*)$");
        testRunner.setProperty("regex.result7", "^(?<NO>XXX)$");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1.ALL", "foo");
        out.assertAttributeEquals("regex.result2.BAR1", "bar1");
        out.assertAttributeEquals("regex.result3.BAR1", "bar1");
        out.assertAttributeEquals("regex.result4.NULL", null);
        out.assertAttributeEquals("regex.result4b.BAR2", "bar2");
        out.assertAttributeEquals("regex.result5.BAR2", "bar1");
        out.assertAttributeEquals("regex.result5b.BAR3", "bar3");
        out.assertAttributeEquals("regex.result6.ALL", "foo");
        out.assertAttributeEquals("regex.result7.NO", null);
    }

    @Test
    public void testProcessorWithMultilineAndDotall() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty("regex.result1", "(?<ALL>.*)");
        testRunner.setProperty("regex.result2", "(?<BAR1>bar1)");
        testRunner.setProperty("regex.result3", ".*?(?<BAR1>bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(?<BAR2>bar\\d).*");
        testRunner.setProperty("regex.result4b", "bar\\d\\r\\n(?<BAR2>bar\\d)");
        testRunner.setProperty("regex.result5", ".*(?<BAR3>bar\\d).*");
        testRunner.setProperty("regex.result5b", "(?:bar\\d\\r?\\n)*(?<BAR3>bar\\d)");
        testRunner.setProperty("regex.result6", "^(?<ALL>.*)$");
        testRunner.setProperty("regex.result7", "^(?<MISS>XXX)$");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1.ALL", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result2.BAR1", "bar1");
        out.assertAttributeEquals("regex.result3.BAR1", "bar1");
        out.assertAttributeEquals("regex.result4.BAR2", "bar2");
        out.assertAttributeEquals("regex.result4b.BAR2", "bar2");
        out.assertAttributeEquals("regex.result5.BAR3", "bar3");
        out.assertAttributeEquals("regex.result5b.BAR3", "bar3");
        out.assertAttributeEquals("regex.result6.ALL", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result7.MISS", null);
    }

    @Test
    public void testProcessorWithNoMatches() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty("regex.result2", "(?<NONE>bar1)");
        testRunner.setProperty("regex.result3", ".*?(?<NONE>bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(?<NONE>bar\\d).*");
        testRunner.setProperty("regex.result4b", "bar\\d\\r\\n(?<NONE>bar\\d)");
        testRunner.setProperty("regex.result5", ".*(?<NONE>bar\\d).*");
        testRunner.setProperty("regex.result5b", "(?:bar\\d\\r?\\n)*(?<NONE>bar\\d)");
        testRunner.setProperty("regex.result7", "^(?<NONE>XXX)$");
        testRunner.enqueue("YYY".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_NO_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_NO_MATCH).get(0);
        out.assertAttributeEquals("regex.result1.NONE", null);
        out.assertAttributeEquals("regex.result2.NONE", null);
        out.assertAttributeEquals("regex.result3.NONE", null);
        out.assertAttributeEquals("regex.result4.NONE", null);
        out.assertAttributeEquals("regex.result4b.NONE", null);
        out.assertAttributeEquals("regex.result5.NONE", null);
        out.assertAttributeEquals("regex.result5b.NONE", null);
        out.assertAttributeEquals("regex.result6.NONE", null);
        out.assertAttributeEquals("regex.result7.NONE", null);
    }

    @Test
    public void testNoFlowFile() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 0);
    }

    @Test
    public void testMatchOutsideBuffer() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.MAX_BUFFER_SIZE, "3 B");
        testRunner.setProperty("regex.result1", "(?<FOO>foo)");
        testRunner.setProperty("regex.result2", "(?<WORLD>world)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1.FOO", "foo");
        out.assertAttributeEquals("regex.result2.WORLD", null);
    }

    @Test
    public void testIncludeZeroCaptureGroupProperty() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s)(?<ALL>.*)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeExists("regex.result");
        out.assertAttributeExists("regex.result.ALL");
        out.assertAttributeEquals("regex.result", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result.ALL", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
    }

    @Test
    public void testFindAll() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.ENABLE_REPEATING_CAPTURE_GROUP, "true");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s)(?<W>\\w+)");
        testRunner.enqueue("This is my text".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeExists("regex.result");
        out.assertAttributeExists("regex.result.W");
        out.assertAttributeExists("regex.result.W.1");
        out.assertAttributeExists("regex.result.W.2");
        out.assertAttributeExists("regex.result.W.3");
        out.assertAttributeEquals("regex.result", "This");
        out.assertAttributeEquals("regex.result.W", "This");
        out.assertAttributeEquals("regex.result.W.1", "is");
        out.assertAttributeEquals("regex.result.W.2", "my");
        out.assertAttributeEquals("regex.result.W.3", "text");
    }

    @Test
    public void testFindAllPair() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.ENABLE_REPEATING_CAPTURE_GROUP, "true");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?<LEFT>\\w+)=(?<RIGHT>\\d+)");
        testRunner.enqueue("a=1,b=10,c=100".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeExists("regex.result");
        out.assertAttributeExists("regex.result.LEFT");
        out.assertAttributeExists("regex.result.RIGHT");
        out.assertAttributeExists("regex.result.LEFT.1");
        out.assertAttributeExists("regex.result.RIGHT.1");
        out.assertAttributeExists("regex.result.LEFT.2");
        out.assertAttributeExists("regex.result.RIGHT.2");
        out.assertAttributeNotExists("regex.result.LEFT.3");
        out.assertAttributeNotExists("regex.result.RIGHT.3");
        out.assertAttributeEquals("regex.result", "a=1");
        out.assertAttributeEquals("regex.result.LEFT", "a");
        out.assertAttributeEquals("regex.result.RIGHT", "1");
        out.assertAttributeEquals("regex.result.LEFT.1", "b");
        out.assertAttributeEquals("regex.result.RIGHT.1", "10");
        out.assertAttributeEquals("regex.result.LEFT.2", "c");
        out.assertAttributeEquals("regex.result.RIGHT.2", "100");
    }

    @Test
    public void testIgnoreZeroCaptureGroupProperty() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.INCLUDE_CAPTURE_GROUP_ZERO, "false");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s)(?<ALL>.*)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeNotExists("regex.result");
        out.assertAttributeEquals("regex.result.ALL", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
    }

    @Test
    public void testShouldAllowNoCaptureGroups() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s).*");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
    }

    @Test
    public void testShouldNotAllowNoCaptureGroupsIfZeroDisabled() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.INCLUDE_CAPTURE_GROUP_ZERO, "false");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s).*");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(AssertionError.class, () -> testRunner.run());
    }

    @Test
    public void testInvalidIfGroupCountsDoNotMatch() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_NAMED_GROUPS, "true");
        testRunner.setProperty(ExtractText.INCLUDE_CAPTURE_GROUP_ZERO, "false");
        String attributeKey = "notValidOne";
        testRunner.setProperty("notValidOne", "^(beginning)\\s(middle)\\s(?<END>end)$");
        testRunner.enqueue("beginning middle end".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(AssertionError.class, () -> testRunner.run());
    }
}

