/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.processors.standard.SplitContent;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Test;

public class TestSplitContent {
    @Test
    public void testTextFormatLeadingPosition() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.FORMAT, SplitContent.UTF8_FORMAT.getValue());
        runner.setProperty(SplitContent.BYTE_SEQUENCE, "ub");
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.LEADING_POSITION.getValue());
        runner.enqueue("rub-a-dub-dub".getBytes());
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 4);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("r");
        ((MockFlowFile)splits.get(1)).assertContentEquals("ub-a-d");
        ((MockFlowFile)splits.get(2)).assertContentEquals("ub-d");
        ((MockFlowFile)splits.get(3)).assertContentEquals("ub");
    }

    @Test
    public void testTextFormatSplits() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.FORMAT, SplitContent.UTF8_FORMAT.getValue());
        runner.setProperty(SplitContent.BYTE_SEQUENCE, "test");
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.LEADING_POSITION.getValue());
        byte[] input = "This is a test. This is another test. And this is yet another test. Finally this is the last Test.".getBytes();
        runner.enqueue(input);
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 4);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("This is a ");
        ((MockFlowFile)splits.get(1)).assertContentEquals("test. This is another ");
        ((MockFlowFile)splits.get(2)).assertContentEquals("test. And this is yet another ");
        ((MockFlowFile)splits.get(3)).assertContentEquals("test. Finally this is the last Test.");
        runner.clearTransferState();
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.enqueue(input);
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 4);
        splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("This is a ");
        ((MockFlowFile)splits.get(1)).assertContentEquals(". This is another ");
        ((MockFlowFile)splits.get(2)).assertContentEquals(". And this is yet another ");
        ((MockFlowFile)splits.get(3)).assertContentEquals(". Finally this is the last Test.");
        runner.clearTransferState();
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.TRAILING_POSITION.getValue());
        runner.enqueue(input);
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 4);
        splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("This is a test");
        ((MockFlowFile)splits.get(1)).assertContentEquals(". This is another test");
        ((MockFlowFile)splits.get(2)).assertContentEquals(". And this is yet another test");
        ((MockFlowFile)splits.get(3)).assertContentEquals(". Finally this is the last Test.");
        runner.clearTransferState();
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.TRAILING_POSITION.getValue());
        runner.enqueue("This is a test. This is another test. And this is yet another test. Finally this is the last test".getBytes());
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "4");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 4);
        splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("This is a test");
        ((MockFlowFile)splits.get(1)).assertContentEquals(". This is another test");
        ((MockFlowFile)splits.get(2)).assertContentEquals(". And this is yet another test");
        ((MockFlowFile)splits.get(3)).assertContentEquals(". Finally this is the last test");
        runner.clearTransferState();
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.LEADING_POSITION.getValue());
        runner.enqueue("This is a test. This is another test. And this is yet another test. Finally this is the last test".getBytes());
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "5");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 5);
        splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("This is a ");
        ((MockFlowFile)splits.get(1)).assertContentEquals("test. This is another ");
        ((MockFlowFile)splits.get(2)).assertContentEquals("test. And this is yet another ");
        ((MockFlowFile)splits.get(3)).assertContentEquals("test. Finally this is the last ");
        ((MockFlowFile)splits.get(4)).assertContentEquals("test");
        runner.clearTransferState();
    }

    @Test
    public void testTextFormatTrailingPosition() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.FORMAT, SplitContent.UTF8_FORMAT.getValue());
        runner.setProperty(SplitContent.BYTE_SEQUENCE, "ub");
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.TRAILING_POSITION.getValue());
        runner.enqueue("rub-a-dub-dub".getBytes());
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "3");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 3);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals("rub");
        ((MockFlowFile)splits.get(1)).assertContentEquals("-a-dub");
        ((MockFlowFile)splits.get(2)).assertContentEquals("-dub");
    }

    @Test
    public void testSmallSplits() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "FFFF");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, -1, -1, -1, 5, 4, 3, 2, 1});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 2);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        MockFlowFile split2 = (MockFlowFile)splits.get(1);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4, 5});
        split2.assertContentEquals(new byte[]{-1, 5, 4, 3, 2, 1});
    }

    @Test
    public void testWithSingleByteSplit() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "FF");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, -1, 5, 4, 3, 2, 1});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 2);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        MockFlowFile split2 = (MockFlowFile)splits.get(1);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4, 5});
        split2.assertContentEquals(new byte[]{5, 4, 3, 2, 1});
    }

    @Test
    public void testWithLargerSplit() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "05050505");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, 5, 5, 5, 5, 5, 4, 3, 2, 1});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        MockFlowFile originalFlowFile = (MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0);
        originalFlowFile.assertAttributeExists(SplitContent.FRAGMENT_ID);
        originalFlowFile.assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 2);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        MockFlowFile split2 = (MockFlowFile)splits.get(1);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4});
        split2.assertContentEquals(new byte[]{5, 5, 4, 3, 2, 1});
    }

    @Test
    public void testKeepingSequence() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "05050505");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, 5, 5, 5, 5, 5, 4, 3, 2, 1});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 2);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        MockFlowFile split2 = (MockFlowFile)splits.get(1);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4, 5, 5, 5, 5});
        split2.assertContentEquals(new byte[]{5, 5, 4, 3, 2, 1});
    }

    @Test
    public void testEndsWithSequence() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "05050505");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, 5, 5, 5});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "1");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 1);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4});
    }

    @Test
    public void testEndsWithSequenceAndKeepSequence() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "05050505");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, 5, 5, 5});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "1");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 1);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4, 5, 5, 5, 5});
    }

    @Test
    public void testStartsWithSequence() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "05050505");
        runner.enqueue(new byte[]{5, 5, 5, 5, 1, 2, 3, 4});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "1");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 1);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4});
    }

    @Test
    public void testStartsWithSequenceAndKeepSequence() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "05050505");
        runner.enqueue(new byte[]{5, 5, 5, 5, 1, 2, 3, 4});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 2);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals(new byte[]{5, 5, 5, 5});
        ((MockFlowFile)splits.get(1)).assertContentEquals(new byte[]{1, 2, 3, 4});
    }

    @Test
    public void testSmallSplitsThenMerge() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "true");
        runner.setProperty(SplitContent.BYTE_SEQUENCE.getName(), "FFFF");
        runner.enqueue(new byte[]{1, 2, 3, 4, 5, -1, -1, -1, 5, 4, 3, 2, 1});
        runner.run();
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        ((MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_ORIGINAL).get(0)).assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "2");
        runner.assertTransferCount(SplitContent.REL_SPLITS, 2);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        MockFlowFile split1 = (MockFlowFile)splits.get(0);
        MockFlowFile split2 = (MockFlowFile)splits.get(1);
        split1.assertContentEquals(new byte[]{1, 2, 3, 4, 5, -1, -1});
        split2.assertContentEquals(new byte[]{-1, 5, 4, 3, 2, 1});
        TestRunner mergeRunner = TestRunners.newTestRunner((Processor)new MergeContent());
        mergeRunner.setProperty(MergeContent.MERGE_FORMAT, MergeContent.MERGE_FORMAT_CONCAT);
        mergeRunner.setProperty(MergeContent.MERGE_STRATEGY, MergeContent.MERGE_STRATEGY_DEFRAGMENT);
        mergeRunner.enqueue((FlowFile[])splits.toArray(new MockFlowFile[0]));
        mergeRunner.run();
        mergeRunner.assertTransferCount(MergeContent.REL_MERGED, 1);
        mergeRunner.assertTransferCount(MergeContent.REL_ORIGINAL, 2);
        mergeRunner.assertTransferCount(MergeContent.REL_FAILURE, 0);
        List packed = mergeRunner.getFlowFilesForRelationship(MergeContent.REL_MERGED);
        ((MockFlowFile)packed.get(0)).assertContentEquals(new byte[]{1, 2, 3, 4, 5, -1, -1, -1, 5, 4, 3, 2, 1});
    }

    @Test
    public void testNoSplitterInString() {
        String content = "UVAT";
        TestRunner runner = TestRunners.newTestRunner((Processor)new SplitContent());
        runner.setProperty(SplitContent.FORMAT, SplitContent.UTF8_FORMAT.getValue());
        runner.setProperty(SplitContent.BYTE_SEQUENCE, ",");
        runner.setProperty(SplitContent.KEEP_SEQUENCE, "false");
        runner.setProperty(SplitContent.BYTE_SEQUENCE_LOCATION, SplitContent.TRAILING_POSITION.getValue());
        runner.enqueue(content.getBytes());
        runner.run();
        runner.assertTransferCount(SplitContent.REL_SPLITS, 1);
        MockFlowFile splitResult = (MockFlowFile)runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS).get(0);
        splitResult.assertAttributeExists(SplitContent.FRAGMENT_ID);
        splitResult.assertAttributeExists(SplitContent.SEGMENT_ORIGINAL_FILENAME);
        splitResult.assertAttributeEquals(SplitContent.FRAGMENT_COUNT, "1");
        splitResult.assertAttributeEquals(SplitContent.FRAGMENT_INDEX, "1");
        runner.assertTransferCount(SplitContent.REL_ORIGINAL, 1);
        runner.assertQueueEmpty();
        List splits = runner.getFlowFilesForRelationship(SplitContent.REL_SPLITS);
        ((MockFlowFile)splits.get(0)).assertContentEquals(content);
    }
}

