/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;
import org.apache.nifi.security.util.crypto.AbstractEncryptor;
import org.apache.nifi.security.util.crypto.CipherProviderFactory;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.KeyedCipherProvider;
import org.apache.nifi.security.util.crypto.RandomIVPBECipherProvider;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedEncryptor
extends AbstractEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(KeyedEncryptor.class);
    private EncryptionMethod encryptionMethod;
    private SecretKey key;
    private byte[] iv;
    private static final int DEFAULT_MAX_ALLOWED_KEY_LENGTH = 128;
    private static boolean isUnlimitedStrengthCryptographyEnabled;

    public KeyedEncryptor(EncryptionMethod encryptionMethod, SecretKey key) {
        this(encryptionMethod, key == null ? new byte[]{} : key.getEncoded(), new byte[0]);
    }

    public KeyedEncryptor(EncryptionMethod encryptionMethod, SecretKey key, byte[] iv) {
        this(encryptionMethod, key == null ? new byte[]{} : key.getEncoded(), iv);
    }

    public KeyedEncryptor(EncryptionMethod encryptionMethod, byte[] keyBytes) {
        this(encryptionMethod, keyBytes, new byte[0]);
    }

    public KeyedEncryptor(EncryptionMethod encryptionMethod, byte[] keyBytes, byte[] iv) {
        try {
            if (encryptionMethod == null) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with null encryption method");
            }
            if (!encryptionMethod.isKeyedCipher()) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with encryption method " + encryptionMethod.name());
            }
            this.encryptionMethod = encryptionMethod;
            if (keyBytes == null || keyBytes.length == 0) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with empty key");
            }
            if (!CipherUtility.isValidKeyLengthForAlgorithm((int)(keyBytes.length * 8), (String)encryptionMethod.getAlgorithm())) {
                throw new IllegalArgumentException("Cannot instantiate a keyed encryptor with key of length " + keyBytes.length);
            }
            String cipherName = CipherUtility.parseCipherFromAlgorithm((String)encryptionMethod.getAlgorithm());
            this.key = new SecretKeySpec(keyBytes, cipherName);
            this.iv = iv;
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public static int getMaxAllowedKeyLength(String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return 128;
        }
        String parsedCipher = CipherUtility.parseCipherFromAlgorithm((String)algorithm);
        try {
            return Cipher.getMaxAllowedKeyLength(parsedCipher);
        }
        catch (NoSuchAlgorithmException e) {
            return 128;
        }
    }

    public static boolean supportsUnlimitedStrength() {
        return isUnlimitedStrengthCryptographyEnabled;
    }

    @Override
    public StreamCallback getEncryptionCallback() throws ProcessException {
        return new EncryptCallback();
    }

    @Override
    public StreamCallback getDecryptionCallback() throws ProcessException {
        return new DecryptCallback();
    }

    static {
        try {
            isUnlimitedStrengthCryptographyEnabled = Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            isUnlimitedStrengthCryptographyEnabled = false;
        }
    }

    private class EncryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            Cipher cipher;
            KeyedCipherProvider cipherProvider = (KeyedCipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)KeyDerivationFunction.NONE);
            ByteCountingInputStream bcis = CipherUtility.wrapStreamForCounting((InputStream)in);
            ByteCountingOutputStream bcos = CipherUtility.wrapStreamForCounting((OutputStream)out);
            try {
                cipher = cipherProvider.getCipher(KeyedEncryptor.this.encryptionMethod, KeyedEncryptor.this.key, KeyedEncryptor.this.iv, true);
                cipherProvider.writeIV(cipher.getIV(), (OutputStream)bcos);
                CipherUtility.processStreams((Cipher)cipher, (InputStream)bcis, (OutputStream)bcos);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            KeyedEncryptor.this.flowfileAttributes.putAll(AbstractEncryptor.writeAttributes(KeyedEncryptor.this.encryptionMethod, KeyDerivationFunction.NONE, cipher.getIV(), bcis, bcos, true));
        }
    }

    private class DecryptCallback
    implements StreamCallback {
        public void process(InputStream in, OutputStream out) throws IOException {
            KeyedCipherProvider cipherProvider = (KeyedCipherProvider)CipherProviderFactory.getCipherProvider((KeyDerivationFunction)KeyDerivationFunction.NONE);
            ByteCountingInputStream bcis = CipherUtility.wrapStreamForCounting((InputStream)in);
            ByteCountingOutputStream bcos = CipherUtility.wrapStreamForCounting((OutputStream)out);
            try {
                if (!bcis.markSupported()) {
                    logger.warn("The incoming cipher text stream does not support #mark(); unable to scan for possible salt");
                } else {
                    bcis.mark(100);
                    byte[] first80Bytes = new byte[80];
                    IOUtils.read((InputStream)bcis, (byte[])first80Bytes, (int)0, (int)first80Bytes.length);
                    int saltDelimiterStart = CipherUtility.findSequence((byte[])first80Bytes, (byte[])RandomIVPBECipherProvider.SALT_DELIMITER);
                    bcis.reset();
                    if (saltDelimiterStart != -1) {
                        byte[] saltBytes = new byte[saltDelimiterStart + RandomIVPBECipherProvider.SALT_DELIMITER.length];
                        IOUtils.readFully((InputStream)bcis, (byte[])saltBytes);
                        logger.info("Detected salt in incoming cipher text; skipped {} bytes", (Object)saltBytes.length);
                    }
                }
                if (KeyedEncryptor.this.iv.length == 0) {
                    KeyedEncryptor.this.iv = cipherProvider.readIV((InputStream)bcis);
                }
                Cipher cipher = cipherProvider.getCipher(KeyedEncryptor.this.encryptionMethod, KeyedEncryptor.this.key, KeyedEncryptor.this.iv, false);
                CipherUtility.processStreams((Cipher)cipher, (InputStream)bcis, (OutputStream)bcos);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            KeyedEncryptor.this.flowfileAttributes.putAll(AbstractEncryptor.writeAttributes(KeyedEncryptor.this.encryptionMethod, KeyDerivationFunction.NONE, KeyedEncryptor.this.iv, bcis, bcos, false));
        }
    }
}

