/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.EncryptContent;
import org.bouncycastle.shaded.bcpg.ArmoredOutputStream;
import org.bouncycastle.shaded.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.shaded.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPUtil {
    private static final Logger logger = LoggerFactory.getLogger(PGPUtil.class);
    public static final int BUFFER_SIZE = 65536;
    public static final int BLOCK_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(InputStream in, OutputStream out, String algorithm, String provider, int cipher, String filename, PGPKeyEncryptionMethodGenerator encryptionMethodGenerator) throws IOException, PGPException {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            throw new IllegalArgumentException("The algorithm must be specified");
        }
        boolean isArmored = EncryptContent.isPGPArmoredAlgorithm(algorithm);
        OutputStream output = out;
        if (isArmored) {
            output = new ArmoredOutputStream(out);
        }
        if (cipher == 0) {
            logger.warn("Null encryption not allowed; defaulting to AES-128");
            cipher = 7;
        }
        try {
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(cipher).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider(provider));
            encryptedDataGenerator.addMethod(encryptionMethodGenerator);
            try (OutputStream encryptedOut = encryptedDataGenerator.open(output, new byte[65536]);){
                PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1, 1);
                try (OutputStream compressedOut = compressedDataGenerator.open(encryptedOut, new byte[65536]);){
                    PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
                    try (OutputStream literalOut = literalDataGenerator.open(compressedOut, 'b', filename, new Date(), new byte[65536]);){
                        int len;
                        byte[] buffer = new byte[4096];
                        while ((len = in.read(buffer)) > -1) {
                            literalOut.write(buffer, 0, len);
                        }
                    }
                }
            }
        }
        finally {
            if (isArmored) {
                output.close();
            }
        }
    }
}

