/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.InvokeHTTP;
import org.apache.nifi.processors.standard.util.HTTPUtils;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.Tuple;

@Deprecated
@DeprecationNotice(alternatives={InvokeHTTP.class}, reason="This processor is deprecated and may be removed in future releases.")
@Tags(value={"get", "fetch", "poll", "http", "https", "ingest", "source", "input"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Please be aware this processor is deprecated and may be removed in the near future. Use InvokeHTTP instead. Fetches data from an HTTP or HTTPS URL and writes the data to the content of a FlowFile. Once the content has been fetched, the ETag and Last Modified dates are remembered (if the web server supports these concepts). This allows the Processor to fetch new data only if the remote data has changed or until the state is cleared. That is, once the content has been fetched from the given URL, it will not be fetched again until the content on the remote server changes. Note that due to limitations on state management, stored \"last modified\" and etag fields never expire. If the URL in GetHttp uses Expression Language that is unbounded, there is the potential for Out of Memory Errors to occur.")
@DynamicProperties(value={@DynamicProperty(name="Header Name", value="The Expression Language to be used to populate the header value", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="The additional headers to be sent by the processor whenever making a new HTTP request. \n Setting a dynamic property name to XYZ and value to ${attribute} will result in the header 'XYZ: attribute_value' being sent to the HTTP endpoint")})
@WritesAttributes(value={@WritesAttribute(attribute="filename", description="The filename is set to the name of the file on the remote server"), @WritesAttribute(attribute="mime.type", description="The MIME Type of the FlowFile, as reported by the HTTP Content-Type header")})
@Stateful(scopes={Scope.LOCAL}, description="Stores Last Modified Time and ETag headers returned by server so that the same data will not be fetched multiple times.")
public class GetHTTP
extends AbstractSessionFactoryProcessor {
    static final int PERSISTENCE_INTERVAL_MSEC = 10000;
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_ETAG = "ETag";
    public static final int NOT_MODIFIED = 304;
    public static final PropertyDescriptor URL = new PropertyDescriptor.Builder().name("URL").description("The URL to pull from").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.URL_VALIDATOR).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("https?\\://.*"))).build();
    public static final PropertyDescriptor FOLLOW_REDIRECTS = new PropertyDescriptor.Builder().name("Follow Redirects").description("If we receive a 3xx HTTP Status Code from the server, indicates whether or not we should follow the redirect that the server specifies").defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("How long to wait when attempting to connect to the remote server before giving up").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor ACCEPT_CONTENT_TYPE = new PropertyDescriptor.Builder().name("Accept Content-Type").description("If specified, requests will only accept the provided Content-Type").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DATA_TIMEOUT = new PropertyDescriptor.Builder().name("Data Timeout").description("How long to wait between receiving segments of data from the remote server before giving up and discarding the partial file").required(true).defaultValue("30 sec").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor FILENAME = new PropertyDescriptor.Builder().name("Filename").description("The filename to assign to the file when pulled").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).required(true).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username required to access the URL").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password required to access the URL").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USER_AGENT = new PropertyDescriptor.Builder().name("User Agent").description("What to report as the User Agent when we connect to the remote server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The Controller Service to use in order to obtain an SSL Context").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final String DEFAULT_COOKIE_POLICY_STR = "default";
    public static final String STANDARD_COOKIE_POLICY_STR = "standard";
    public static final String STRICT_COOKIE_POLICY_STR = "strict";
    public static final String NETSCAPE_COOKIE_POLICY_STR = "netscape";
    public static final String IGNORE_COOKIE_POLICY_STR = "ignore";
    public static final AllowableValue DEFAULT_COOKIE_POLICY = new AllowableValue("default", "default", "Default cookie policy that provides a higher degree of compatibility with common cookie management of popular HTTP agents for non-standard (Netscape style) cookies.");
    public static final AllowableValue STANDARD_COOKIE_POLICY = new AllowableValue("standard", "standard", "RFC 6265 compliant cookie policy (interoperability profile).");
    public static final AllowableValue STRICT_COOKIE_POLICY = new AllowableValue("strict", "strict", "RFC 6265 compliant cookie policy (strict profile).");
    public static final AllowableValue NETSCAPE_COOKIE_POLICY = new AllowableValue("netscape", "netscape", "Netscape draft compliant cookie policy.");
    public static final AllowableValue IGNORE_COOKIE_POLICY = new AllowableValue("ignore", "ignore", "A cookie policy that ignores cookies.");
    public static final PropertyDescriptor REDIRECT_COOKIE_POLICY = new PropertyDescriptor.Builder().name("redirect-cookie-policy").displayName("Redirect Cookie Policy").description("When a HTTP server responds to a request with a redirect, this is the cookie policy used to copy cookies to the following request.").allowableValues(new AllowableValue[]{DEFAULT_COOKIE_POLICY, STANDARD_COOKIE_POLICY, STRICT_COOKIE_POLICY, NETSCAPE_COOKIE_POLICY, IGNORE_COOKIE_POLICY}).defaultValue("default").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All files are transferred to the success relationship").build();
    public static final String LAST_MODIFIED_DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final String ETAG = "ETag";
    static final String LAST_MODIFIED = "LastModified";
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final List<PropertyDescriptor> customHeaders = new ArrayList<PropertyDescriptor>();
    private final AtomicBoolean clearState = new AtomicBoolean(false);

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(URL);
        properties.add(FILENAME);
        properties.add(SSL_CONTEXT_SERVICE);
        properties.add(USERNAME);
        properties.add(PASSWORD);
        properties.add(CONNECTION_TIMEOUT);
        properties.add(DATA_TIMEOUT);
        properties.add(USER_AGENT);
        properties.add(ACCEPT_CONTENT_TYPE);
        properties.add(FOLLOW_REDIRECTS);
        properties.add(REDIRECT_COOKIE_POLICY);
        properties.add(HTTPUtils.PROXY_CONFIGURATION_SERVICE);
        properties.add(HTTPUtils.PROXY_HOST);
        properties.add(HTTPUtils.PROXY_PORT);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.clearState.set(true);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        if (this.clearState.getAndSet(false)) {
            context.getStateManager().clear(Scope.LOCAL);
        }
        if (this.customHeaders.size() == 0) {
            for (Map.Entry property : context.getProperties().entrySet()) {
                if (this.getSupportedPropertyDescriptors().contains(property.getKey())) continue;
                this.customHeaders.add((PropertyDescriptor)property.getKey());
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (context.getProperty(URL).evaluateAttributeExpressions().getValue().startsWith("https") && context.getProperty(SSL_CONTEXT_SERVICE).getValue() == null) {
            results.add(new ValidationResult.Builder().explanation("URL is set to HTTPS protocol but no SSLContext has been specified").valid(false).subject("SSL Context").build());
        }
        HTTPUtils.validateProxyProperties(context, results);
        return results;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(Validator.VALID).required(false).dynamic(true).build();
    }

    /*
     * Exception decompiling
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateStateMap(ProcessContext context, ProcessSession session, HttpResponse response, StateMap beforeStateMap, String url) {
        try {
            Header receivedEtag;
            HashMap<CallSite, CallSite> workingMap = new HashMap<CallSite, CallSite>();
            workingMap.putAll(beforeStateMap.toMap());
            StateMap oldValue = beforeStateMap;
            long currentTime = System.currentTimeMillis();
            Header receivedLastModified = response.getFirstHeader(HEADER_LAST_MODIFIED);
            if (receivedLastModified != null) {
                workingMap.put((CallSite)((Object)("LastModified:" + url)), (CallSite)((Object)(currentTime + ":" + receivedLastModified.getValue())));
            }
            if ((receivedEtag = response.getFirstHeader("ETag")) != null) {
                workingMap.put((CallSite)((Object)("ETag:" + url)), (CallSite)((Object)(currentTime + ":" + receivedEtag.getValue())));
            }
            boolean replaceSucceeded = session.replaceState(oldValue, workingMap, Scope.LOCAL);
            while (!replaceSucceeded) {
                Tuple<String, String> storedLastModifiedTuple;
                oldValue = session.getState(Scope.LOCAL);
                workingMap.clear();
                workingMap.putAll(oldValue.toMap());
                boolean changed = false;
                if (receivedLastModified != null && Long.parseLong((String)(storedLastModifiedTuple = GetHTTP.parseStateValue((String)workingMap.get("LastModified:" + url))).getKey()) < currentTime) {
                    workingMap.put((CallSite)((Object)("LastModified:" + url)), (CallSite)((Object)(currentTime + ":" + receivedLastModified.getValue())));
                    changed = true;
                }
                if (receivedEtag != null && Long.parseLong((String)(storedLastModifiedTuple = GetHTTP.parseStateValue((String)workingMap.get("ETag:" + url))).getKey()) < currentTime) {
                    workingMap.put((CallSite)((Object)("ETag:" + url)), (CallSite)((Object)(currentTime + ":" + receivedEtag.getValue())));
                    changed = true;
                }
                if (changed) {
                    replaceSucceeded = session.replaceState(oldValue, workingMap, Scope.LOCAL);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new ProcessException((Throwable)ioe);
        }
    }

    protected static Tuple<String, String> parseStateValue(String mapValue) {
        int indexOfColon = mapValue.indexOf(":");
        String timestamp = mapValue.substring(0, indexOfColon);
        String value = mapValue.substring(indexOfColon + 1);
        return new Tuple((Object)timestamp, (Object)value);
    }
}

