/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.processors.standard.relp.frame.RELPEncoder;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;

public class RELPFrameProducer {
    public static final String OPEN_FRAME_DATA = "relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog";
    static final RELPFrame OPEN_FRAME = new RELPFrame.Builder().txnr(1L).command("open").dataLength("relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog".length()).data("relp_version=0\nrelp_software=librelp,1.2.7,http://librelp.adiscon.com\ncommands=syslog".getBytes(StandardCharsets.UTF_8)).build();
    static final RELPFrame CLOSE_FRAME = new RELPFrame.Builder().txnr(3L).command("close").dataLength(0).data(new byte[0]).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length != 5) {
            System.err.println("USAGE: RELPFrameProducer <HOST> <PORT> <NUM_MSGS> <DELAY_INTERVAL> <DELAY_MILLIS>");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int numMessages = Integer.parseInt(args[2]);
        int delayInterval = Integer.parseInt(args[3]);
        long delay = Long.parseLong(args[4]);
        RELPEncoder encoder = new RELPEncoder(StandardCharsets.UTF_8);
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            try (BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());){
                ((OutputStream)out).write(encoder.encode(OPEN_FRAME));
                for (int i = 2; i < numMessages + 2; ++i) {
                    byte[] data = ("this is message # " + i).getBytes(StandardCharsets.UTF_8);
                    RELPFrame syslogFrame = new RELPFrame.Builder().txnr((long)i).command("syslog").dataLength(data.length).data(data).build();
                    ((OutputStream)out).write(encoder.encode(syslogFrame));
                    if (i % delayInterval != 0) continue;
                    System.out.println("Sent " + i + " messages");
                    ((OutputStream)out).flush();
                    Thread.sleep(delay);
                }
                ((OutputStream)out).write(encoder.encode(CLOSE_FRAME));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
            IOUtils.closeQuietly((Socket)socket);
        }
        IOUtils.closeQuietly((Socket)socket);
    }
}

