/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ListenHTTP;
import org.apache.nifi.processors.standard.http.ContentEncodingStrategy;
import org.apache.nifi.processors.standard.http.HttpProtocolStrategy;
import org.apache.nifi.remote.io.socket.NetworkUtils;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TemporaryKeyStoreBuilder;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.web.util.ssl.SslContextUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import org.mockito.Mockito;

public class TestListenHTTP {
    private static final String SSL_CONTEXT_SERVICE_IDENTIFIER = "ssl-context";
    private static final MediaType APPLICATION_OCTET_STREAM = MediaType.get((String)"application/octet-stream");
    private static final String HTTP_BASE_PATH = "basePath";
    private static final String PORT_VARIABLE = "HTTP_PORT";
    private static final String HTTP_SERVER_PORT_EL = "${HTTP_PORT}";
    private static final String BASEPATH_VARIABLE = "HTTP_BASEPATH";
    private static final String HTTP_SERVER_BASEPATH_EL = "${HTTP_BASEPATH}";
    private static final String MULTIPART_ATTRIBUTE = "http.multipart.name";
    private static final String TLS_1_3 = "TLSv1.3";
    private static final String TLS_1_2 = "TLSv1.2";
    private static final String LOCALHOST = "localhost";
    private static final int SOCKET_CONNECT_TIMEOUT = 100;
    private static final long SERVER_START_TIMEOUT = 1200000L;
    private static final Duration CLIENT_CALL_TIMEOUT = Duration.ofSeconds(10L);
    public static final String LOCALHOST_DN = "CN=localhost";
    private static TlsConfiguration serverConfiguration;
    private static TlsConfiguration serverTls_1_3_Configuration;
    private static TlsConfiguration serverNoTruststoreConfiguration;
    private static SSLContext serverKeyStoreSslContext;
    private static SSLContext serverKeyStoreNoTrustStoreSslContext;
    private static SSLContext keyStoreSslContext;
    private static SSLContext trustStoreSslContext;
    private static X509TrustManager trustManager;
    private ListenHTTP proc;
    private TestRunner runner;
    private int availablePort;

    static boolean isTls13Supported() {
        return TLS_1_3.equals(TlsPlatform.getLatestProtocol());
    }

    @BeforeAll
    public static void setUpSuite() throws GeneralSecurityException {
        TlsConfiguration tlsConfiguration = new TemporaryKeyStoreBuilder().build();
        serverConfiguration = new StandardTlsConfiguration(tlsConfiguration.getKeystorePath(), tlsConfiguration.getKeystorePassword(), tlsConfiguration.getKeyPassword(), tlsConfiguration.getKeystoreType(), tlsConfiguration.getTruststorePath(), tlsConfiguration.getTruststorePassword(), tlsConfiguration.getTruststoreType(), TLS_1_2);
        serverTls_1_3_Configuration = new StandardTlsConfiguration(tlsConfiguration.getKeystorePath(), tlsConfiguration.getKeystorePassword(), tlsConfiguration.getKeyPassword(), tlsConfiguration.getKeystoreType(), tlsConfiguration.getTruststorePath(), tlsConfiguration.getTruststorePassword(), tlsConfiguration.getTruststoreType(), TLS_1_3);
        serverNoTruststoreConfiguration = new StandardTlsConfiguration(tlsConfiguration.getKeystorePath(), tlsConfiguration.getKeystorePassword(), tlsConfiguration.getKeyPassword(), tlsConfiguration.getKeystoreType(), null, null, null, TLS_1_2);
        serverKeyStoreSslContext = SslContextUtils.createSslContext(serverConfiguration);
        trustManager = SslContextFactory.getX509TrustManager((TlsConfiguration)serverConfiguration);
        serverKeyStoreNoTrustStoreSslContext = SslContextFactory.createSslContext((TlsConfiguration)serverNoTruststoreConfiguration, (TrustManager[])new TrustManager[]{trustManager});
        keyStoreSslContext = SslContextUtils.createSslContext((TlsConfiguration)new StandardTlsConfiguration(tlsConfiguration.getKeystorePath(), tlsConfiguration.getKeystorePassword(), tlsConfiguration.getKeystoreType(), tlsConfiguration.getTruststorePath(), tlsConfiguration.getTruststorePassword(), tlsConfiguration.getTruststoreType()));
        trustStoreSslContext = SslContextUtils.createSslContext((TlsConfiguration)new StandardTlsConfiguration(null, null, null, tlsConfiguration.getTruststorePath(), tlsConfiguration.getTruststorePassword(), tlsConfiguration.getTruststoreType()));
    }

    @BeforeEach
    public void setup() throws IOException {
        this.proc = new ListenHTTP();
        this.runner = TestRunners.newTestRunner((Processor)this.proc);
        this.availablePort = NetworkUtils.availablePort();
        this.runner.setVariable(PORT_VARIABLE, Integer.toString(this.availablePort));
        this.runner.setVariable(BASEPATH_VARIABLE, HTTP_BASE_PATH);
    }

    @AfterEach
    public void shutdownServer() {
        this.proc.shutdownHttpServer();
    }

    @Test
    public void testPOSTRequestsReceivedWithoutEL() throws Exception {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.testPOSTRequestsReceived(200, false, false);
    }

    @Test
    public void testPOSTRequestsReceivedReturnCodeWithoutEL() throws Exception {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.testPOSTRequestsReceived(204, false, false);
    }

    @Test
    public void testPOSTRequestsReceivedWithEL() throws Exception {
        this.runner.setProperty(ListenHTTP.PORT, HTTP_SERVER_PORT_EL);
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_SERVER_BASEPATH_EL);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(200, false, false);
    }

    @Test
    public void testPOSTRequestsReturnCodeReceivedWithEL() throws Exception {
        this.runner.setProperty(ListenHTTP.PORT, HTTP_SERVER_PORT_EL);
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_SERVER_BASEPATH_EL);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.assertValid();
        this.testPOSTRequestsReceived(204, false, false);
    }

    @Test
    public void testSecurePOSTRequestsReceivedWithoutELHttp2AndHttp1() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverNoTruststoreConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.HTTP_PROTOCOL_STRATEGY, HttpProtocolStrategy.H2_HTTP_1_1.getValue());
        this.runner.assertValid();
        this.testPOSTRequestsReceived(200, true, false);
    }

    @Test
    public void testSecurePOSTRequestsReturnCodeReceivedWithoutELHttp2() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverNoTruststoreConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.setProperty(ListenHTTP.HTTP_PROTOCOL_STRATEGY, HttpProtocolStrategy.H2.getValue());
        this.runner.assertValid();
        this.testPOSTRequestsReceived(204, true, false);
    }

    @Test
    public void testSecurePOSTRequestsReceivedWithEL() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverNoTruststoreConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, HTTP_SERVER_PORT_EL);
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_SERVER_BASEPATH_EL);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(200, true, false);
    }

    @Test
    public void testSecurePOSTRequestsReturnCodeReceivedWithEL() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverNoTruststoreConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.assertValid();
        this.testPOSTRequestsReceived(204, true, false);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReceivedWithoutEL() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(200, true, true);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReceivedWithUnauthorizedSubjectDn() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.AUTHORIZED_DN_PATTERN, "CN=other");
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(403, true, true);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReceivedWithAuthorizedIssuerDn() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.AUTHORIZED_DN_PATTERN, LOCALHOST_DN);
        this.runner.setProperty(ListenHTTP.AUTHORIZED_ISSUER_DN_PATTERN, LOCALHOST_DN);
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(200, true, true);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReceivedWithUnauthorizedIssuerDn() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.AUTHORIZED_DN_PATTERN, LOCALHOST_DN);
        this.runner.setProperty(ListenHTTP.AUTHORIZED_ISSUER_DN_PATTERN, "CN=other");
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(403, true, true);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReturnCodeReceivedWithoutEL() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.assertValid();
        this.testPOSTRequestsReceived(204, true, true);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReceivedWithEL() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, HTTP_SERVER_PORT_EL);
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_SERVER_BASEPATH_EL);
        this.runner.assertValid();
        this.testPOSTRequestsReceived(200, true, true);
    }

    @Test
    public void testSecureTwoWaySslPOSTRequestsReturnCodeReceivedWithEL() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.assertValid();
        this.testPOSTRequestsReceived(204, true, true);
    }

    @Test
    public void testSecureServerSupportsCurrentTlsProtocolVersion() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverNoTruststoreConfiguration);
        this.startSecureServer();
        SSLSocketFactory sslSocketFactory = trustStoreSslContext.getSocketFactory();
        try (SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(LOCALHOST, this.availablePort);){
            String currentProtocol = serverNoTruststoreConfiguration.getProtocol();
            sslSocket.setEnabledProtocols(new String[]{currentProtocol});
            sslSocket.startHandshake();
            SSLSession sslSession = sslSocket.getSession();
            Assertions.assertEquals((Object)currentProtocol, (Object)sslSession.getProtocol());
        }
    }

    @Test
    public void testSecureServerTrustStoreConfiguredClientAuthenticationRequired() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.REQUIRED, serverConfiguration);
        this.startSecureServer();
        Assertions.assertThrows(IOException.class, () -> this.postMessage(null, true, false));
    }

    @Test
    public void testSecureServerTrustStoreNotConfiguredClientAuthenticationNotRequired() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverNoTruststoreConfiguration);
        this.startSecureServer();
        int responseCode = this.postMessage(null, true, true);
        Assertions.assertEquals((int)204, (int)responseCode);
    }

    @EnabledIf(value="isTls13Supported", disabledReason="TLSv1.3 is not supported")
    @Test
    public void testSecureServerRejectsUnsupportedTlsProtocolVersion() throws Exception {
        this.configureProcessorSslContextService(ListenHTTP.ClientAuthentication.AUTO, serverTls_1_3_Configuration);
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.assertValid();
        this.startWebServer();
        SSLSocketFactory sslSocketFactory = trustStoreSslContext.getSocketFactory();
        try (SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(LOCALHOST, this.availablePort);){
            sslSocket.setEnabledProtocols(new String[]{TLS_1_2});
            Assertions.assertThrows(SSLHandshakeException.class, sslSocket::startHandshake);
        }
    }

    @Test
    public void testMaxThreadPoolSizeTooLow() {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.MAX_THREAD_POOL_SIZE, "7");
        this.runner.assertNotValid();
    }

    @Test
    public void testMaxThreadPoolSizeTooHigh() {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.MAX_THREAD_POOL_SIZE, "1001");
        this.runner.assertNotValid();
    }

    @Test
    public void testMaxThreadPoolSizeOkLowerBound() {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.MAX_THREAD_POOL_SIZE, "8");
        this.runner.assertValid();
    }

    @Test
    public void testMaxThreadPoolSizeOkUpperBound() {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.MAX_THREAD_POOL_SIZE, "1000");
        this.runner.assertValid();
    }

    @Test
    public void testMaxThreadPoolSizeSpecifiedInThePropertyIsSetInTheServerInstance() {
        int maxThreadPoolSize = 201;
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.MAX_THREAD_POOL_SIZE, Integer.toString(maxThreadPoolSize));
        this.startWebServer();
        Server server = this.proc.getServer();
        ThreadPool threadPool = server.getThreadPool();
        ThreadPool.SizedThreadPool sizedThreadPool = (ThreadPool.SizedThreadPool)threadPool;
        Assertions.assertEquals((int)maxThreadPoolSize, (int)sizedThreadPool.getMaxThreads());
    }

    @Test
    public void testPOSTRequestsReceivedWithRecordReader() throws Exception {
        MockRecordParser parser = this.setupRecordReaderTest();
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.LONG);
        List<Integer> keys = Arrays.asList(1, 2, 3, 4);
        List<String> names = Arrays.asList("rec1", "rec2", "rec3", "rec4");
        List<Long> codes = Arrays.asList(101L, 102L, 103L, 104L);
        for (int i = 0; i < keys.size(); ++i) {
            parser.addRecord(new Object[]{keys.get(i), names.get(i), codes.get(i)});
        }
        String expectedMessage = "\"1\",\"rec1\",\"101\"\n\"2\",\"rec2\",\"102\"\n\"3\",\"rec3\",\"103\"\n\"4\",\"rec4\",\"104\"\n";
        this.startWebServerAndSendMessages(Collections.singletonList(""), 200, false, false);
        List mockFlowFiles = this.runner.getFlowFilesForRelationship(ListenHTTP.RELATIONSHIP_SUCCESS);
        this.runner.assertTransferCount(ListenHTTP.RELATIONSHIP_SUCCESS, 1);
        ((MockFlowFile)mockFlowFiles.get(0)).assertContentEquals("\"1\",\"rec1\",\"101\"\n\"2\",\"rec2\",\"102\"\n\"3\",\"rec3\",\"103\"\n\"4\",\"rec4\",\"104\"\n");
    }

    @Test
    public void testReturn400WhenInvalidPOSTRequestSentWithRecordReader() throws Exception {
        MockRecordParser parser = this.setupRecordReaderTest();
        parser.failAfter(2);
        parser.addSchemaField("id", RecordFieldType.INT);
        parser.addSchemaField("name", RecordFieldType.STRING);
        parser.addSchemaField("code", RecordFieldType.LONG);
        List<Integer> keys = Arrays.asList(1, 2, 3, 4);
        List<String> names = Arrays.asList("rec1", "rec2", "rec3", "rec4");
        List<Long> codes = Arrays.asList(101L, 102L, 103L, 104L);
        for (int i = 0; i < keys.size(); ++i) {
            parser.addRecord(new Object[]{keys.get(i), names.get(i), codes.get(i)});
        }
        this.startWebServerAndSendMessages(Collections.singletonList(""), 400, false, false);
        this.runner.assertTransferCount(ListenHTTP.RELATIONSHIP_SUCCESS, 0);
    }

    @Test
    public void testPostContentEncodingGzipAccepted() throws IOException {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.startWebServer();
        OkHttpClient okHttpClient = this.getOkHttpClient(false, false);
        Request.Builder requestBuilder = new Request.Builder();
        String url = this.buildUrl(false);
        requestBuilder.url(url);
        String message = String.class.getSimpleName();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink(Okio.sink((OutputStream)outputStream)));
        gzipSink.write(message.getBytes(StandardCharsets.UTF_8));
        gzipSink.close();
        byte[] compressed = outputStream.toByteArray();
        RequestBody requestBody = RequestBody.create((byte[])compressed, (MediaType)APPLICATION_OCTET_STREAM);
        Request request = requestBuilder.post(requestBody).addHeader("Content-Encoding", ContentEncodingStrategy.GZIP.getValue().toLowerCase()).build();
        try (Response response = okHttpClient.newCall(request).execute();){
            Assertions.assertTrue((boolean)response.isSuccessful());
            this.runner.assertTransferCount(ListenHTTP.RELATIONSHIP_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ListenHTTP.RELATIONSHIP_SUCCESS).iterator().next();
            flowFile.assertContentEquals(message);
        }
    }

    private MockRecordParser setupRecordReaderTest() throws InitializationException {
        MockRecordParser parser = new MockRecordParser();
        MockRecordWriter writer = new MockRecordWriter();
        this.runner.addControllerService("mockRecordParser", (ControllerService)parser);
        this.runner.setProperty(ListenHTTP.RECORD_READER, "mockRecordParser");
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.addControllerService("mockRecordWriter", (ControllerService)writer);
        this.runner.setProperty(ListenHTTP.RECORD_WRITER, "mockRecordWriter");
        return parser;
    }

    private void startSecureServer() {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(204));
        this.runner.assertValid();
        this.startWebServer();
    }

    private int postMessage(String message, boolean secure, boolean clientAuthRequired) throws IOException {
        OkHttpClient okHttpClient = this.getOkHttpClient(secure, clientAuthRequired);
        Request.Builder requestBuilder = new Request.Builder();
        String url = this.buildUrl(secure);
        requestBuilder.url(url);
        byte[] bytes = message == null ? new byte[]{} : message.getBytes(StandardCharsets.UTF_8);
        RequestBody requestBody = RequestBody.create((byte[])bytes, (MediaType)APPLICATION_OCTET_STREAM);
        Request request = requestBuilder.post(requestBody).build();
        try (Response response = okHttpClient.newCall(request).execute();){
            int n = response.code();
            return n;
        }
    }

    private OkHttpClient getOkHttpClient(boolean secure, boolean clientAuthRequired) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (secure) {
            if (clientAuthRequired) {
                builder.sslSocketFactory(keyStoreSslContext.getSocketFactory(), trustManager);
            } else {
                builder.sslSocketFactory(trustStoreSslContext.getSocketFactory(), trustManager);
            }
        }
        builder.callTimeout(CLIENT_CALL_TIMEOUT);
        return builder.build();
    }

    private String buildUrl(boolean secure) {
        return String.format("%s://localhost:%s/%s", secure ? "https" : "http", this.availablePort, HTTP_BASE_PATH);
    }

    private void testPOSTRequestsReceived(int returnCode, boolean secure, boolean twoWaySsl) throws Exception {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("payload 1");
        messages.add("");
        messages.add(null);
        messages.add("payload 2");
        this.startWebServerAndSendMessages(messages, returnCode, secure, twoWaySsl);
        List mockFlowFiles = this.runner.getFlowFilesForRelationship(ListenHTTP.RELATIONSHIP_SUCCESS);
        if (returnCode < 400) {
            this.runner.assertTransferCount(ListenHTTP.RELATIONSHIP_SUCCESS, 4);
            ((MockFlowFile)mockFlowFiles.get(0)).assertContentEquals("payload 1");
            ((MockFlowFile)mockFlowFiles.get(1)).assertContentEquals("");
            ((MockFlowFile)mockFlowFiles.get(2)).assertContentEquals("");
            ((MockFlowFile)mockFlowFiles.get(3)).assertContentEquals("payload 2");
            if (twoWaySsl) {
                ((MockFlowFile)mockFlowFiles.get(0)).assertAttributeEquals("restlistener.remote.user.dn", LOCALHOST_DN);
                ((MockFlowFile)mockFlowFiles.get(0)).assertAttributeEquals("restlistener.remote.issuer.dn", LOCALHOST_DN);
            }
        }
    }

    private void startWebServer() {
        long connectElapsed;
        ProcessSessionFactory processSessionFactory = this.runner.getProcessSessionFactory();
        ProcessContext context = this.runner.getProcessContext();
        this.proc.onTrigger(context, processSessionFactory);
        int port = context.getProperty(ListenHTTP.PORT).evaluateAttributeExpressions().asInteger();
        InetSocketAddress socketAddress = new InetSocketAddress(LOCALHOST, port);
        Socket socket = new Socket();
        boolean connected = false;
        for (long elapsed = 0L; !connected && elapsed < 1200000L; elapsed += connectElapsed) {
            long started = System.currentTimeMillis();
            try {
                socket.connect(socketAddress, 100);
                connected = true;
                this.runner.getLogger().debug("Server Socket Connected after {} ms", new Object[]{elapsed});
                socket.close();
            }
            catch (Exception e) {
                this.runner.getLogger().debug("Server Socket Connect Failed: [{}] {}", new Object[]{e.getClass(), e.getMessage()});
            }
            connectElapsed = System.currentTimeMillis() - started;
        }
        if (!connected) {
            String message = String.format("HTTP Server Port [%d] not listening after %d ms", port, 1200000L);
            throw new IllegalStateException(message);
        }
    }

    private void startWebServerAndSendMessages(List<String> messages, int expectedStatusCode, boolean secure, boolean clientAuthRequired) throws Exception {
        this.startWebServer();
        for (String message : messages) {
            int statusCode = this.postMessage(message, secure, clientAuthRequired);
            Assertions.assertEquals((int)expectedStatusCode, (int)statusCode, (String)"HTTP Status Code not matched");
        }
    }

    private void configureProcessorSslContextService(ListenHTTP.ClientAuthentication clientAuthentication, TlsConfiguration tlsConfiguration) throws InitializationException {
        RestrictedSSLContextService sslContextService = (RestrictedSSLContextService)Mockito.mock(RestrictedSSLContextService.class);
        Mockito.when((Object)sslContextService.getIdentifier()).thenReturn((Object)SSL_CONTEXT_SERVICE_IDENTIFIER);
        Mockito.when((Object)sslContextService.createTlsConfiguration()).thenReturn((Object)tlsConfiguration);
        if (ListenHTTP.ClientAuthentication.REQUIRED.equals((Object)clientAuthentication)) {
            Mockito.when((Object)sslContextService.createContext()).thenReturn((Object)serverKeyStoreSslContext);
        } else {
            Mockito.when((Object)sslContextService.createContext()).thenReturn((Object)serverKeyStoreNoTrustStoreSslContext);
        }
        this.runner.addControllerService(SSL_CONTEXT_SERVICE_IDENTIFIER, (ControllerService)sslContextService);
        this.runner.setProperty(ListenHTTP.CLIENT_AUTHENTICATION, clientAuthentication.name());
        this.runner.setProperty(ListenHTTP.SSL_CONTEXT_SERVICE, SSL_CONTEXT_SERVICE_IDENTIFIER);
        this.runner.enableControllerService((ControllerService)sslContextService);
    }

    @Test
    public void testMultipartFormDataRequest() throws IOException {
        this.runner.setProperty(ListenHTTP.PORT, Integer.toString(this.availablePort));
        this.runner.setProperty(ListenHTTP.BASE_PATH, HTTP_BASE_PATH);
        this.runner.setProperty(ListenHTTP.RETURN_CODE, Integer.toString(200));
        SSLContextService sslContextService = (SSLContextService)this.runner.getControllerService(SSL_CONTEXT_SERVICE_IDENTIFIER, SSLContextService.class);
        boolean isSecure = sslContextService != null;
        this.startWebServer();
        File file1 = this.createTextFile("Hello", "World");
        File file2 = this.createTextFile("{ \"name\":\"John\", \"age\":30 }");
        MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("p1", "v1").addFormDataPart("p2", "v2").addFormDataPart("file1", "my-file-text.txt", RequestBody.create((File)file1, (MediaType)MediaType.parse((String)"text/plain"))).addFormDataPart("file2", "my-file-data.json", RequestBody.create((File)file2, (MediaType)MediaType.parse((String)"application/json"))).addFormDataPart("file3", "my-file-binary.bin", RequestBody.create((byte[])this.generateRandomBinaryData(), (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
        Request request = new Request.Builder().url(this.buildUrl(isSecure)).post((RequestBody)multipartBody).build();
        OkHttpClient client = this.getOkHttpClient(false, false);
        try (Response response = client.newCall(request).execute();){
            Files.deleteIfExists(Paths.get(String.valueOf(file1), new String[0]));
            Files.deleteIfExists(Paths.get(String.valueOf(file2), new String[0]));
            Assertions.assertTrue((boolean)response.isSuccessful(), (String)String.format("Unexpected code: %s, body: %s", response.code(), response.body()));
        }
        this.runner.assertAllFlowFilesTransferred(ListenHTTP.RELATIONSHIP_SUCCESS, 5);
        List flowFilesForRelationship = this.runner.getFlowFilesForRelationship(ListenHTTP.RELATIONSHIP_SUCCESS);
        MockFlowFile mff = this.findFlowFile(flowFilesForRelationship, "p1");
        mff.assertAttributeEquals(MULTIPART_ATTRIBUTE, "p1");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeEquals("http.multipart.fragments.sequence.number", "1");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "p2");
        mff.assertAttributeEquals(MULTIPART_ATTRIBUTE, "p2");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "file1");
        mff.assertAttributeEquals(MULTIPART_ATTRIBUTE, "file1");
        mff.assertAttributeEquals("http.multipart.filename", "my-file-text.txt");
        mff.assertAttributeEquals("http.headers.multipart.content-type", "text/plain");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "file2");
        mff.assertAttributeEquals(MULTIPART_ATTRIBUTE, "file2");
        mff.assertAttributeEquals("http.multipart.filename", "my-file-data.json");
        mff.assertAttributeEquals("http.headers.multipart.content-type", "application/json");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
        mff = this.findFlowFile(flowFilesForRelationship, "file3");
        mff.assertAttributeEquals(MULTIPART_ATTRIBUTE, "file3");
        mff.assertAttributeEquals("http.multipart.filename", "my-file-binary.bin");
        mff.assertAttributeEquals("http.headers.multipart.content-type", "application/octet-stream");
        mff.assertAttributeExists("http.multipart.size");
        mff.assertAttributeExists("http.multipart.fragments.sequence.number");
        mff.assertAttributeEquals("http.multipart.fragments.total.number", "5");
        mff.assertAttributeExists("http.headers.multipart.content-disposition");
    }

    private byte[] generateRandomBinaryData() {
        byte[] bytes = new byte[100];
        new Random().nextBytes(bytes);
        return bytes;
    }

    private File createTextFile(String ... lines) throws IOException {
        File textFile = Files.createTempFile(TestListenHTTP.class.getSimpleName(), ".txt", new FileAttribute[0]).toFile();
        textFile.deleteOnExit();
        Files.write(textFile.toPath(), Arrays.asList(lines), new OpenOption[0]);
        return textFile;
    }

    protected MockFlowFile findFlowFile(List<MockFlowFile> flowFiles, String attributeValue) {
        Optional<MockFlowFile> foundFlowFile = flowFiles.stream().filter(flowFile -> flowFile.getAttribute(MULTIPART_ATTRIBUTE).equals(attributeValue)).findFirst();
        return foundFlowFile.orElseThrow(() -> new NullPointerException(MULTIPART_ATTRIBUTE));
    }
}

