/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.bazaarvoice.jolt.Diffy;
import com.bazaarvoice.jolt.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.JoltTransformJSON;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJoltTransformJSON {
    static final Path JSON_INPUT = Paths.get("src/test/resources/TestJoltTransformJson/input.json", new String[0]);
    static final Diffy DIFFY = new Diffy();

    @Test
    public void testRelationshipsCreated() throws IOException {
        JoltTransformJSON processor = new JoltTransformJSON();
        TestRunner runner = TestRunners.newTestRunner((Processor)processor);
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.enqueue(JSON_INPUT);
        Set relationships = processor.getRelationships();
        Assertions.assertTrue((boolean)relationships.contains(JoltTransformJSON.REL_FAILURE));
        Assertions.assertTrue((boolean)relationships.contains(JoltTransformJSON.REL_SUCCESS));
        Assertions.assertEquals((int)2, (int)relationships.size());
    }

    @Test
    public void testInvalidJOLTSpec() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = "[{}]";
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, "[{}]");
        runner.assertNotValid();
    }

    @Test
    public void testIncorrectJOLTSpec() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String chainrSpec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, chainrSpec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SHIFTR);
        runner.assertNotValid();
    }

    @Test
    public void testSpecIsNotSet() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SHIFTR);
        runner.assertNotValid();
    }

    @Test
    public void testSpecIsEmpty() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, "");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SHIFTR);
        runner.assertNotValid();
    }

    @Test
    public void testSpecNotRequired() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SORTR);
        runner.assertValid();
    }

    @Test
    public void testNoFlowFileContent() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.run();
        runner.assertQueueEmpty();
        runner.assertTransferCount(JoltTransformJSON.REL_FAILURE, 0);
        runner.assertTransferCount(JoltTransformJSON.REL_SUCCESS, 0);
    }

    @Test
    public void testInvalidFlowFileContentJson() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.enqueue("invalid json");
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_FAILURE);
    }

    @Test
    public void testCustomTransformationWithNoModule() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/customChainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "TestCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
    }

    @Test
    public void testCustomTransformationWithMissingClassName() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.enqueue(JSON_INPUT);
        runner.assertNotValid();
    }

    @Test
    public void testCustomTransformationWithInvalidClassPath() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson/FakeCustomJar.jar";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "TestCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson/FakeCustomJar.jar");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.enqueue(JSON_INPUT);
        runner.assertNotValid();
    }

    @Test
    public void testCustomTransformationWithInvalidClassName() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "FakeCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.enqueue(JSON_INPUT);
        runner.assertNotValid();
    }

    @Test
    public void testTransformInputWithChainr() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/chainrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithShiftr() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/shiftrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SHIFTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/shiftrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithDefaultr() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/defaultrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.DEFAULTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/defaultrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithRemovr() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/removrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.REMOVR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/removrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithCardinality() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/cardrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CARDINALITY);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/cardrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithSortr() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SORTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/sortrOutput.json", new String[0]), new OpenOption[0]));
        String transformedJsonString = JsonUtils.toJsonString((Object)transformedJson);
        String compareJsonString = JsonUtils.toJsonString((Object)compareJson);
        Assertions.assertTrue((boolean)compareJsonString.equals(transformedJsonString));
    }

    @Test
    public void testTransformInputWithDefaultrExpressionLanguage() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/defaultrELSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.DEFAULTR);
        runner.setVariable("quota", "5");
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/defaultrELOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithModifierDefault() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/modifierDefaultSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.MODIFIER_DEFAULTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/modifierDefaultOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithModifierDefine() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/modifierDefineSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.MODIFIER_DEFAULTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/modifierDefineOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithModifierOverwrite() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/modifierOverwriteSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.MODIFIER_DEFAULTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/modifierOverwriteOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithSortrPopulatedSpec() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.SORTR);
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, "abcd");
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/sortrOutput.json", new String[0]), new OpenOption[0]));
        String transformedJsonString = JsonUtils.toJsonString((Object)transformedJson);
        String compareJsonString = JsonUtils.toJsonString((Object)compareJson);
        Assertions.assertTrue((boolean)compareJsonString.equals(transformedJsonString));
    }

    @Test
    public void testTransformInputWithCustomTransformationWithJar() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "TestCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/chainrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testExpressionLanguageJarFile() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        String customJoltTransform = "TestCustomJoltTransform";
        HashMap<String, String> customSpecs = new HashMap<String, String>();
        customSpecs.put("JOLT_SPEC", spec);
        customSpecs.put("CUSTOM_JOLT_CLASS", "TestCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, "${JOLT_SPEC}");
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "${CUSTOM_JOLT_CLASS}");
        runner.setProperty(JoltTransformJSON.MODULES, "${CUSTOM_JAR}");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.setVariable("CUSTOM_JAR", "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar");
        runner.enqueue(JSON_INPUT, customSpecs);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/chainrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithCustomTransformationWithDir() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/chainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "TestCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.CUSTOMR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/chainrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputWithChainrEmbeddedCustomTransformation() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/customChainrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson");
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/chainrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testTransformInputCustomTransformationIgnored() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String customJarPath = "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar";
        String spec = new String(Files.readAllBytes(Paths.get("src/test/resources/TestJoltTransformJson/defaultrSpec.json", new String[0])));
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, spec);
        runner.setProperty(JoltTransformJSON.CUSTOM_CLASS, "TestCustomJoltTransform");
        runner.setProperty(JoltTransformJSON.MODULES, "src/test/resources/TestJoltTransformJson/TestCustomJoltTransform.jar");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.DEFAULTR);
        runner.enqueue(JSON_INPUT);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/defaultrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testJoltSpecEL() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = "${joltSpec}";
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, "${joltSpec}");
        runner.setProperty(JoltTransformJSON.JOLT_TRANSFORM, JoltTransformJSON.DEFAULTR);
        Map<String, String> attributes = Collections.singletonMap("joltSpec", "{\"RatingRange\":5,\"rating\":{\"*\":{\"MaxLabel\":\"High\",\"MinLabel\":\"Low\",\"DisplayType\":\"NORMAL\"}}}");
        runner.enqueue(JSON_INPUT, attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(JoltTransformJSON.REL_SUCCESS);
        MockFlowFile transformed = (MockFlowFile)runner.getFlowFilesForRelationship(JoltTransformJSON.REL_SUCCESS).get(0);
        transformed.assertAttributeExists(CoreAttributes.MIME_TYPE.key());
        transformed.assertAttributeEquals(CoreAttributes.MIME_TYPE.key(), "application/json");
        Object transformedJson = JsonUtils.jsonToObject((InputStream)new ByteArrayInputStream(transformed.toByteArray()));
        Object compareJson = JsonUtils.jsonToObject((InputStream)Files.newInputStream(Paths.get("src/test/resources/TestJoltTransformJson/defaultrOutput.json", new String[0]), new OpenOption[0]));
        Assertions.assertTrue((boolean)DIFFY.diff(compareJson, transformedJson).isEmpty());
    }

    @Test
    public void testJoltSpecInvalidEL() throws IOException {
        TestRunner runner = TestRunners.newTestRunner((Processor)new JoltTransformJSON());
        String spec = "${joltSpec:nonExistingFunction()}";
        runner.setProperty(JoltTransformJSON.JOLT_SPEC, "${joltSpec:nonExistingFunction()}");
        runner.enqueue(JSON_INPUT);
        runner.assertNotValid();
    }
}

