/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util.ssl;

import java.io.File;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TemporaryKeyStoreBuilder;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;

public class SslContextUtils {
    private static final TlsConfiguration TLS_CONFIGURATION;
    private static final TlsConfiguration KEYSTORE_TLS_CONFIGURATION;
    private static final TlsConfiguration TRUSTSTORE_TLS_CONFIGURATION;

    public static SSLContext createKeyStoreSslContext() throws TlsException {
        return SslContextFactory.createSslContext((TlsConfiguration)KEYSTORE_TLS_CONFIGURATION);
    }

    public static SSLContext createTrustStoreSslContext() throws TlsException {
        return SslContextFactory.createSslContext((TlsConfiguration)TRUSTSTORE_TLS_CONFIGURATION);
    }

    public static SSLContext createSslContext(TlsConfiguration tlsConfiguration) throws TlsException {
        SSLContext sslContext;
        String truststorePath;
        String keystorePath = tlsConfiguration.getKeystorePath();
        if (StringUtils.isNotBlank((CharSequence)keystorePath)) {
            File keystoreFile = new File(keystorePath);
            keystoreFile.deleteOnExit();
        }
        if (StringUtils.isNotBlank((CharSequence)(truststorePath = tlsConfiguration.getTruststorePath()))) {
            File truststoreFile = new File(truststorePath);
            truststoreFile.deleteOnExit();
        }
        if ((sslContext = SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration)) == null) {
            throw new TlsException(String.format("Failed to create SSLContext from Configuration %s", tlsConfiguration));
        }
        return sslContext;
    }

    static {
        try {
            TLS_CONFIGURATION = new TemporaryKeyStoreBuilder().build();
            KEYSTORE_TLS_CONFIGURATION = new StandardTlsConfiguration(TLS_CONFIGURATION.getKeystorePath(), TLS_CONFIGURATION.getKeystorePassword(), TLS_CONFIGURATION.getKeyPassword(), TLS_CONFIGURATION.getKeystoreType().getType(), TLS_CONFIGURATION.getTruststorePath(), TLS_CONFIGURATION.getTruststorePassword(), TLS_CONFIGURATION.getTruststoreType().getType(), "TLSv1.2");
            TRUSTSTORE_TLS_CONFIGURATION = new StandardTlsConfiguration(null, null, null, null, TLS_CONFIGURATION.getTruststorePath(), TLS_CONFIGURATION.getTruststorePassword(), TLS_CONFIGURATION.getTruststoreType().getType(), "TLSv1.2");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create TLS configuration for testing", e);
        }
    }
}

