/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.response;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;
import org.apache.nifi.processors.standard.relp.response.RELPResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRELPResponse {
    @Test
    public void testResponseToFrame() {
        long txnr = 123456789L;
        int code = 200;
        String message = "this is a message";
        String data = "this is some data";
        RELPResponse response = new RELPResponse(123456789L, 200, "this is a message", "this is some data");
        RELPFrame frame = response.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "200 this is a message\nthis is some data";
        Assertions.assertEquals((Object)"200 this is a message\nthis is some data", (Object)result);
        Assertions.assertEquals((int)"200 this is a message\nthis is some data".length(), (int)frame.getDataLength());
    }

    @Test
    public void testResponseToFrameNoMessage() {
        long txnr = 123456789L;
        int code = 200;
        String data = "this is some data";
        RELPResponse response = new RELPResponse(123456789L, 200, null, "this is some data");
        RELPFrame frame = response.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "200\nthis is some data";
        Assertions.assertEquals((Object)"200\nthis is some data", (Object)result);
        Assertions.assertEquals((int)"200\nthis is some data".length(), (int)frame.getDataLength());
    }

    @Test
    public void testResponseToFrameNoData() throws IOException {
        long txnr = 123456789L;
        int code = 200;
        String message = "this is a message";
        RELPResponse response = new RELPResponse(123456789L, 200, "this is a message", null);
        RELPFrame frame = response.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "200 this is a message";
        Assertions.assertEquals((Object)"200 this is a message", (Object)result);
        Assertions.assertEquals((int)"200 this is a message".length(), (int)frame.getDataLength());
    }

    @Test
    public void testResponseToFrameNoDataNoMessage() throws IOException {
        long txnr = 123456789L;
        int code = 200;
        RELPResponse response = new RELPResponse(123456789L, 200);
        RELPFrame frame = response.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "200";
        Assertions.assertEquals((Object)"200", (Object)result);
        Assertions.assertEquals((int)"200".length(), (int)frame.getDataLength());
    }

    @Test
    public void testCreateOpenResponse() {
        long txnr = 123456789L;
        HashMap<String, String> offers = new HashMap<String, String>();
        offers.put("key1", "val1");
        offers.put("key2", "val2");
        RELPResponse openResponse = RELPResponse.open((long)123456789L, offers);
        RELPFrame frame = openResponse.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected1 = "200 OK\nkey1=val1\nkey2=val2";
        String expected2 = "200 OK\nkey2=val2\nkey1=val1";
        Assertions.assertTrue((result.equals("200 OK\nkey1=val1\nkey2=val2") || result.equals("200 OK\nkey2=val2\nkey1=val1") ? 1 : 0) != 0);
        Assertions.assertEquals((int)"200 OK\nkey1=val1\nkey2=val2".length(), (int)frame.getDataLength());
    }

    @Test
    public void testCreateOpenResponseNoOffers() {
        long txnr = 123456789L;
        HashMap offers = new HashMap();
        RELPResponse openResponse = RELPResponse.open((long)123456789L, offers);
        RELPFrame frame = openResponse.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "200 OK\n";
        Assertions.assertEquals((Object)"200 OK\n", (Object)result);
        Assertions.assertEquals((int)"200 OK\n".length(), (int)frame.getDataLength());
    }

    @Test
    public void testCreateOkResponse() {
        long txnr = 123456789L;
        RELPResponse openResponse = RELPResponse.ok((long)123456789L);
        RELPFrame frame = openResponse.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "200 OK";
        Assertions.assertEquals((Object)"200 OK", (Object)result);
        Assertions.assertEquals((int)"200 OK".length(), (int)frame.getDataLength());
    }

    @Test
    public void testCreateErrorResponse() {
        long txnr = 123456789L;
        RELPResponse openResponse = RELPResponse.error((long)123456789L);
        RELPFrame frame = openResponse.toFrame(StandardCharsets.UTF_8);
        Assertions.assertEquals((long)123456789L, (long)frame.getTxnr());
        Assertions.assertEquals((Object)"rsp", (Object)frame.getCommand());
        String result = new String(frame.getData(), StandardCharsets.UTF_8);
        String expected = "500 ERROR";
        Assertions.assertEquals((Object)"500 ERROR", (Object)result);
        Assertions.assertEquals((int)"500 ERROR".length(), (int)frame.getDataLength());
    }
}

