/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.enrichment;

import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.mock.MockComponentLogger;
import org.apache.nifi.processors.standard.enrichment.TestIndexCorrelatedJoinStrategy;
import org.apache.nifi.processors.standard.enrichment.WrapperJoinStrategy;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWrapperJoinStrategy
extends TestIndexCorrelatedJoinStrategy {
    @Test
    public void testSimpleJoin() {
        RecordSchema originalSchema = this.getOriginalSchema();
        RecordSchema enrichmentSchema = this.getEnrichmentSchema();
        Record originalRecord = this.createOriginalRecord(555);
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        WrapperJoinStrategy strategy = new WrapperJoinStrategy((ComponentLog)new MockComponentLogger());
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)2, (int)resultFields.size());
        RecordDataType originalDataType = (RecordDataType)resultSchema.getDataType("original").get();
        Assertions.assertEquals((Object)originalSchema, (Object)originalDataType.getChildSchema());
        RecordDataType enrichmentDataType = (RecordDataType)resultSchema.getDataType("enrichment").get();
        Assertions.assertEquals((Object)enrichmentSchema, (Object)enrichmentDataType.getChildSchema());
        Record combined = strategy.combineRecords(originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertEquals((Object)originalRecord, (Object)combined.getValue("original"));
        Assertions.assertEquals((Object)enrichmentRecord, (Object)combined.getValue("enrichment"));
    }

    @Test
    public void testNullEnrichment() {
        RecordSchema originalSchema = this.getOriginalSchema();
        Record originalRecord = this.createOriginalRecord(555);
        Record enrichmentRecord = null;
        WrapperJoinStrategy strategy = new WrapperJoinStrategy((ComponentLog)new MockComponentLogger());
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)1, (int)resultFields.size());
        RecordDataType originalDataType = (RecordDataType)resultSchema.getDataType("original").get();
        Assertions.assertEquals((Object)originalSchema, (Object)originalDataType.getChildSchema());
        Record combined = strategy.combineRecords(originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertEquals((Object)originalRecord, (Object)combined.getValue("original"));
        Assertions.assertEquals(enrichmentRecord, (Object)combined.getValue("enrichment"));
    }

    @Test
    public void testNullOriginal() {
        RecordSchema enrichmentSchema = this.getEnrichmentSchema();
        Record originalRecord = null;
        Record enrichmentRecord = this.createEnrichmentRecord(555, "John Doe", 100);
        WrapperJoinStrategy strategy = new WrapperJoinStrategy((ComponentLog)new MockComponentLogger());
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)1, (int)resultFields.size());
        RecordDataType enrichmentDataType = (RecordDataType)resultSchema.getDataType("enrichment").get();
        Assertions.assertEquals((Object)enrichmentSchema, (Object)enrichmentDataType.getChildSchema());
        Record combined = strategy.combineRecords(originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertEquals(originalRecord, (Object)combined.getValue("original"));
        Assertions.assertEquals((Object)enrichmentRecord, (Object)combined.getValue("enrichment"));
    }

    @Test
    public void testCombineNullOriginalNullEnrichment() {
        Record originalRecord = null;
        Record enrichmentRecord = null;
        WrapperJoinStrategy strategy = new WrapperJoinStrategy((ComponentLog)new MockComponentLogger());
        RecordSchema resultSchema = strategy.createResultSchema(originalRecord, enrichmentRecord);
        List resultFields = resultSchema.getFields();
        Assertions.assertEquals((int)0, (int)resultFields.size());
        Record combined = strategy.combineRecords(originalRecord, enrichmentRecord, resultSchema);
        Assertions.assertNull((Object)combined);
    }
}

