/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.processors.standard.db.impl.MySQLDatabaseAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMySQLDatabaseAdapter {
    private MySQLDatabaseAdapter testSubject;

    @BeforeEach
    public void setUp() throws Exception {
        this.testSubject = new MySQLDatabaseAdapter();
    }

    @Test
    public void testSupportsUpsert() {
        Assertions.assertTrue((boolean)this.testSubject.supportsUpsert(), (String)(this.testSubject.getClass().getSimpleName() + " should support upsert"));
    }

    @Test
    public void testGetUpsertStatementWithNullTableName() {
        this.testGetUpsertStatement(null, Collections.singletonList("notEmpty"), Collections.singletonList("notEmpty"), new IllegalArgumentException("Table name cannot be null or blank"));
    }

    @Test
    public void testGetUpsertStatementWithBlankTableName() {
        this.testGetUpsertStatement("", Collections.singletonList("notEmpty"), Collections.singletonList("notEmpty"), new IllegalArgumentException("Table name cannot be null or blank"));
    }

    @Test
    public void testGetUpsertStatementWithNullColumnNames() {
        this.testGetUpsertStatement("notEmpty", null, Collections.singletonList("notEmpty"), new IllegalArgumentException("Column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatementWithEmptyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Collections.emptyList(), Collections.singletonList("notEmpty"), new IllegalArgumentException("Column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatementWithNullKeyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Collections.singletonList("notEmpty"), null, new IllegalArgumentException("Key column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatementWithEmptyKeyColumnNames() {
        this.testGetUpsertStatement("notEmpty", Collections.singletonList("notEmpty"), Collections.emptyList(), new IllegalArgumentException("Key column names cannot be null or empty"));
    }

    @Test
    public void testGetUpsertStatement() {
        String tableName = "table";
        List<String> columnNames = Arrays.asList("column1", "column2", "column3", "column4");
        List<String> uniqueKeyColumnNames = Arrays.asList("column2", "column4");
        String expected = "INSERT INTO table(column1, column2, column3, column4) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE column1 = ?, column2 = ?, column3 = ?, column4 = ?";
        this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, expected);
    }

    @Test
    public void testGetInsertIgnoreStatement() {
        String tableName = "table";
        List<String> columnNames = Arrays.asList("column1", "column2", "column3", "column4");
        List<String> uniqueKeyColumnNames = Arrays.asList("column2", "column4");
        String ignoreExpected = "INSERT IGNORE INTO table(column1, column2, column3, column4) VALUES (?, ?, ?, ?)";
        this.testGetInsertIgnoreStatement(tableName, columnNames, uniqueKeyColumnNames, ignoreExpected);
    }

    private void testGetUpsertStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, IllegalArgumentException expected) {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.testGetUpsertStatement(tableName, columnNames, uniqueKeyColumnNames, (String)null));
        Assertions.assertEquals((Object)expected.getMessage(), (Object)e.getMessage());
    }

    private void testGetUpsertStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, String expected) {
        String actual = this.testSubject.getUpsertStatement(tableName, columnNames, uniqueKeyColumnNames);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private void testGetInsertIgnoreStatement(String tableName, List<String> columnNames, Collection<String> uniqueKeyColumnNames, String expected) {
        String actual = this.testSubject.getInsertIgnoreStatement(tableName, columnNames, uniqueKeyColumnNames);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

