/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Collections;
import java.util.HashMap;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.RetryFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRetryFlowFile {
    TestRunner runner;

    @BeforeEach
    public void before() {
        this.runner = TestRunners.newTestRunner((Processor)new RetryFlowFile());
    }

    @AfterEach
    public void after() {
        this.runner.shutdown();
    }

    @Test
    public void testNoRetryAttribute() {
        this.runner.enqueue("");
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeExists("flowfile.retries.uuid");
            mff.assertAttributeEquals("flowfile.retries", "1");
            return true;
        });
    }

    @Test
    public void testRetryPenalize() {
        this.runner.enqueue("", Collections.singletonMap("flowfile.retries", "2"));
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeExists("flowfile.retries.uuid");
            mff.assertAttributeEquals("flowfile.retries", "3");
            Assertions.assertTrue((boolean)mff.isPenalized(), (String)"FlowFile was not penalized!");
            return true;
        });
    }

    @Test
    public void testRetryClustered() {
        this.runner.setClustered(true);
        this.runner.setThreadCount(5);
        for (int i = 0; i < 5; ++i) {
            this.runner.enqueue("", Collections.singletonMap("flowfile.retries", "2"));
        }
        this.runner.run(5);
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 5);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeExists("flowfile.retries.uuid");
            mff.assertAttributeEquals("flowfile.retries", "3");
            Assertions.assertTrue((boolean)mff.isPenalized(), (String)"FlowFile was not penalized!");
            return true;
        });
    }

    @Test
    public void testRetryNoPenalize() {
        this.runner.setProperty(RetryFlowFile.PENALIZE_RETRIED, "false");
        this.runner.enqueue("", Collections.singletonMap("flowfile.retries", "2"));
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries.uuid");
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeEquals("flowfile.retries", "3");
            Assertions.assertFalse((boolean)mff.isPenalized(), (String)"FlowFile was not penalized!");
            return true;
        });
    }

    @Test
    public void testNoFailOnOverwrite() {
        this.runner.enqueue("", Collections.singletonMap("flowfile.retries", "ZZAaa"));
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries.uuid");
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeEquals("flowfile.retries", "1");
            Assertions.assertTrue((boolean)mff.isPenalized(), (String)"FlowFile was not penalized!");
            return true;
        });
    }

    @Test
    public void testFailOnOverwrite() {
        this.runner.setProperty(RetryFlowFile.FAIL_ON_OVERWRITE, "true");
        this.runner.enqueue("", Collections.singletonMap("flowfile.retries", "ZZAaa"));
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 0);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 1);
    }

    @Test
    public void testRetriesExceeded() {
        this.runner.setProperty("exceeded.time", "${now():toString()}");
        this.runner.setProperty("reason", "${uuid} exceeded retries");
        this.runner.enqueue("", Collections.singletonMap("flowfile.retries", "3"));
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 0);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 1);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRIES_EXCEEDED, mff -> {
            mff.assertAttributeExists("exceeded.time");
            mff.assertAttributeExists("reason");
            Assertions.assertFalse((boolean)mff.getAttribute("reason").contains("${uuid}"), (String)"Expression language not evaluated!");
            return true;
        });
    }

    @Test
    public void testReuseFail() {
        this.runner.setProperty(RetryFlowFile.REUSE_MODE, RetryFlowFile.FAIL_ON_REUSE.getValue());
        HashMap<String, String> inputAttributes = new HashMap<String, String>();
        inputAttributes.put("flowfile.retries", "2");
        inputAttributes.put("flowfile.retries.uuid", "1122334455");
        this.runner.enqueue("", inputAttributes);
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 0);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 1);
    }

    @Test
    public void testReuseWarn() {
        this.runner.setProperty(RetryFlowFile.REUSE_MODE, RetryFlowFile.WARN_ON_REUSE.getValue());
        HashMap<String, String> inputAttributes = new HashMap<String, String>();
        inputAttributes.put("flowfile.retries", "2");
        inputAttributes.put("flowfile.retries.uuid", "1122334455");
        this.runner.enqueue("", inputAttributes);
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeEquals("flowfile.retries", "1");
            return true;
        });
    }

    @Test
    public void testReuseReset() {
        this.runner.setProperty(RetryFlowFile.REUSE_MODE, RetryFlowFile.RESET_ON_REUSE.getValue());
        HashMap<String, String> inputAttributes = new HashMap<String, String>();
        inputAttributes.put("flowfile.retries", "2");
        inputAttributes.put("flowfile.retries.uuid", "1122334455");
        this.runner.enqueue("", inputAttributes);
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeEquals("flowfile.retries", "1");
            return true;
        });
    }

    @Test
    public void testAlternativeAttributeMaxRetries() {
        this.runner.setProperty(RetryFlowFile.MAXIMUM_RETRIES, "${retry.max}");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("retry.max", "3");
        attributeMap.put("flowfile.retries", "2");
        this.runner.enqueue("", attributeMap);
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 1);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 0);
        this.runner.assertAllConditionsMet(RetryFlowFile.RETRY, mff -> {
            mff.assertAttributeExists("flowfile.retries");
            mff.assertAttributeExists("flowfile.retries.uuid");
            mff.assertAttributeEquals("flowfile.retries", "3");
            Assertions.assertTrue((boolean)mff.isPenalized(), (String)"FlowFile was not penalized!");
            return true;
        });
    }

    @Test
    public void testInvalidAlternativeAttributeMaxRetries() {
        this.runner.setProperty(RetryFlowFile.MAXIMUM_RETRIES, "${retry.max}");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put("retry.max", "NiFi");
        attributeMap.put("flowfile.retries", "2");
        this.runner.enqueue("", attributeMap);
        this.runner.run();
        this.runner.assertTransferCount(RetryFlowFile.RETRY, 0);
        this.runner.assertTransferCount(RetryFlowFile.RETRIES_EXCEEDED, 0);
        this.runner.assertTransferCount(RetryFlowFile.FAILURE, 1);
    }
}

