/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.nifi.processors.standard.ReplaceTextWithMapping;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReplaceTextWithMapping {
    public TestRunner getRunner() {
        TestRunner runner = TestRunners.newTestRunner(ReplaceTextWithMapping.class);
        runner.setValidateExpressionUsage(false);
        return runner;
    }

    @Test
    public void testSimple() throws IOException {
        TestRunner runner = this.getRunner();
        String mappingFile = Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-mapping.txt", new String[0]).toFile().getAbsolutePath();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, mappingFile);
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are apple\nviolets are blueberry\nsomething else is grape\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testExpressionLanguageInText() throws IOException {
        TestRunner runner = this.getRunner();
        String mappingFile = Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-mapping.txt", new String[0]).toFile().getAbsolutePath();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, mappingFile);
        String text = "${foo} red ${baz}";
        runner.enqueue(text.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "${foo} apple ${baz}";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testExpressionLanguageInText2() throws IOException {
        TestRunner runner = this.getRunner();
        String mappingFile = Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-mapping.txt", new String[0]).toFile().getAbsolutePath();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, mappingFile);
        runner.setProperty(ReplaceTextWithMapping.REGEX, "\\|(.*?)\\|");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        String text = "${foo}|red|${baz}";
        runner.enqueue(text.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "${foo}|apple|${baz}";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testExpressionLanguageInText3() throws IOException {
        TestRunner runner = this.getRunner();
        String mappingFile = Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-mapping.txt", new String[0]).toFile().getAbsolutePath();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, mappingFile);
        runner.setProperty(ReplaceTextWithMapping.REGEX, ".*\\|(.*?)\\|.*");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        String text = "${foo}|red|${baz}";
        runner.enqueue(text.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "${foo}|apple|${baz}";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testWithMatchingGroupAndContext() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "-(.*?)-");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "-roses- are -apple-\nviolets are -blueberry-\nsomething else is -grape-\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testBackReference() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "(\\S+)");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-backreference-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are red apple\nviolets are blue blueberry\nsomething else is green grape\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testRoutesToFailureIfTooLarge() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "[123]");
        runner.setProperty(ReplaceTextWithMapping.MAX_BUFFER_SIZE, "1 b");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-mapping.txt", new String[0]).toFile().getAbsolutePath());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("abc", "Good");
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_FAILURE, 1);
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscaped() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "-(.*?)-");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-excessive-backreference-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "-roses- are -red$2 apple-\nviolets are -blue$2 blueberry-\nsomething else is -green$2 grape-\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testBackReferenceWithTooLargeOfIndexIsEscapedSimple() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-excessive-backreference-mapping-simple.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are red$1 apple\nviolets are blue$1 blueberry\nsomething else is green$1 grape\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testBackReferenceWithInvalidReferenceIsEscaped() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "(\\S+)");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-invalid-backreference-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are red$d apple\nviolets are blue$d blueberry\nsomething else is green$d grape\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testEscapingDollarSign() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "-(.*?)-");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-escaped-dollar-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "-roses- are -$1 apple-\nviolets are -$1 blueberry-\nsomething else is -$1 grape-\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testEscapingDollarSignSimple() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-escaped-dollar-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are $1 apple\nviolets are $1 blueberry\nsomething else is $1 grape\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testReplaceWithEmptyString() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-blank-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are \nviolets are \nsomething else is \nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testReplaceWithSpaceInString() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-space-mapping.txt", new String[0]).toFile().getAbsolutePath());
        runner.enqueue(Paths.get("src/test/resources/TestReplaceTextWithMapping/colors-without-dashes.txt", new String[0]));
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = "roses are really red\nviolets are super blue\nsomething else is ultra green\nI'm not good at writing poems";
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testWithNoMatch() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "-(.*?)-");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "1");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-fruit-no-match-mapping.txt", new String[0]).toFile().getAbsolutePath());
        Path path = Paths.get("src/test/resources/TestReplaceTextWithMapping/colors.txt", new String[0]);
        runner.enqueue(path);
        runner.run();
        runner.assertAllFlowFilesTransferred(ReplaceTextWithMapping.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)runner.getFlowFilesForRelationship(ReplaceTextWithMapping.REL_SUCCESS).get(0);
        String outputString = new String(out.toByteArray());
        String expected = new String(Files.readAllBytes(path));
        Assertions.assertEquals((Object)expected, (Object)outputString);
    }

    @Test
    public void testMatchingGroupForLookupKeyTooLarge() throws IOException {
        TestRunner runner = this.getRunner();
        runner.setProperty(ReplaceTextWithMapping.REGEX, "-(.*?)-");
        runner.setProperty(ReplaceTextWithMapping.MATCHING_GROUP_FOR_LOOKUP_KEY, "2");
        runner.setProperty(ReplaceTextWithMapping.MAPPING_FILE, Paths.get("src/test/resources/TestReplaceTextWithMapping/color-mapping.txt", new String[0]).toFile().getAbsolutePath());
        Path path = Paths.get("src/test/resources/TestReplaceTextWithMapping/colors.txt", new String[0]);
        runner.enqueue(path);
        Assertions.assertThrows(AssertionError.class, () -> runner.run());
    }
}

