/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.github.palindromicity.syslog.NilPolicy;
import java.util.List;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ParseSyslog5424;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParseSyslog5424 {
    private static final String SYSLOG_LINE_ALL = "<14>1 2014-06-20T09:14:07+00:00 loggregator d0602076-b14a-4c55-852a-981e7afeed38 DEA MSG-01 [exampleSDID@32473 iut=\"3\" eventSource=\"Application\" eventID=\"1011\"] [exampleSDID@32480 iut=\"4\" eventSource=\"Other Application\" eventID=\"2022\"] Removing instance";
    private static final String SYSLOG_LINE_NILS = "<14>1 2014-06-20T09:14:07+00:00 - d0602076-b14a-4c55-852a-981e7afeed38 - - [exampleSDID@32473 iut=\"3\" eventSource=\"Application\" eventID=\"1011\"] [exampleSDID@32480 iut=\"4\" eventSource=\"Other Application\" eventID=\"2022\"] Removing instance";

    @Test
    public void testValidMessage() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog5424());
        runner.setProperty(ParseSyslog5424.NIL_POLICY, NilPolicy.DASH.name());
        runner.enqueue(SYSLOG_LINE_ALL.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog5424.REL_SUCCESS, 1);
    }

    @Test
    public void testValidMessageWithNils() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog5424());
        runner.setProperty(ParseSyslog5424.NIL_POLICY, NilPolicy.DASH.name());
        runner.enqueue(SYSLOG_LINE_NILS.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog5424.REL_SUCCESS, 1);
    }

    @Test
    public void testInvalidMessage() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog5424());
        runner.setProperty(ParseSyslog5424.NIL_POLICY, NilPolicy.OMIT.name());
        runner.enqueue("<hello> yesterday localhost\n".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog5424.REL_FAILURE, 1);
    }

    @Test
    public void testDefaultHasBodyAttribute() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog5424());
        runner.setProperty(ParseSyslog5424.NIL_POLICY, NilPolicy.DASH.name());
        runner.enqueue(SYSLOG_LINE_NILS.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog5424.REL_SUCCESS, 1);
        List results = runner.getFlowFilesForRelationship(ParseSyslog5424.REL_SUCCESS);
        Assertions.assertNotNull((Object)((MockFlowFile)results.get(0)).getAttribute(SyslogAttributes.SYSLOG_BODY.key()));
    }

    @Test
    public void testIncludeBodyAttributeTrue() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog5424());
        runner.setProperty(ParseSyslog5424.NIL_POLICY, NilPolicy.DASH.name());
        runner.setProperty(ParseSyslog5424.INCLUDE_BODY_IN_ATTRIBUTES, "true");
        runner.enqueue(SYSLOG_LINE_NILS.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog5424.REL_SUCCESS, 1);
        List results = runner.getFlowFilesForRelationship(ParseSyslog5424.REL_SUCCESS);
        Assertions.assertNotNull((Object)((MockFlowFile)results.get(0)).getAttribute(SyslogAttributes.SYSLOG_BODY.key()));
    }

    @Test
    public void testIncludeBodyAttributeFalse() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new ParseSyslog5424());
        runner.setProperty(ParseSyslog5424.NIL_POLICY, NilPolicy.DASH.name());
        runner.setProperty(ParseSyslog5424.INCLUDE_BODY_IN_ATTRIBUTES, "false");
        runner.enqueue(SYSLOG_LINE_NILS.getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(ParseSyslog5424.REL_SUCCESS, 1);
        List results = runner.getFlowFilesForRelationship(ParseSyslog5424.REL_SUCCESS);
        Assertions.assertNull((Object)((MockFlowFile)results.get(0)).getAttribute(SyslogAttributes.SYSLOG_BODY.key()));
    }
}

