/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.nifi.processors.standard.GetSFTP;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.processors.standard.util.SSHTestServer;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGetSFTP {
    private TestRunner getSFTPRunner;
    private static SSHTestServer sshTestServer;

    @BeforeAll
    public static void setupSSHD() throws IOException {
        sshTestServer = new SSHTestServer();
        sshTestServer.startServer();
    }

    @AfterAll
    public static void cleanupSSHD() throws IOException {
        sshTestServer.stopServer();
    }

    @BeforeEach
    public void setup() {
        this.getSFTPRunner = TestRunners.newTestRunner(GetSFTP.class);
        this.getSFTPRunner.setProperty(SFTPTransfer.HOSTNAME, "localhost");
        this.getSFTPRunner.setProperty(SFTPTransfer.PORT, Integer.toString(sshTestServer.getSSHPort()));
        this.getSFTPRunner.setProperty(SFTPTransfer.USERNAME, sshTestServer.getUsername());
        this.getSFTPRunner.setProperty(SFTPTransfer.PASSWORD, sshTestServer.getPassword());
        this.getSFTPRunner.setProperty(SFTPTransfer.STRICT_HOST_KEY_CHECKING, "false");
        this.getSFTPRunner.setProperty(SFTPTransfer.DATA_TIMEOUT, "30 sec");
        this.getSFTPRunner.setProperty(SFTPTransfer.REMOTE_PATH, "/");
        this.getSFTPRunner.removeProperty(SFTPTransfer.FILE_FILTER_REGEX);
        this.getSFTPRunner.setProperty(SFTPTransfer.PATH_FILTER_REGEX, "");
        this.getSFTPRunner.setProperty(SFTPTransfer.POLLING_INTERVAL, "60 sec");
        this.getSFTPRunner.setProperty(SFTPTransfer.RECURSIVE_SEARCH, "false");
        this.getSFTPRunner.setProperty(SFTPTransfer.IGNORE_DOTTED_FILES, "true");
        this.getSFTPRunner.setProperty(SFTPTransfer.DELETE_ORIGINAL, "true");
        this.getSFTPRunner.setProperty(SFTPTransfer.MAX_SELECTS, "100");
        this.getSFTPRunner.setProperty(SFTPTransfer.REMOTE_POLL_BATCH_SIZE, "5000");
        this.getSFTPRunner.setValidateExpressionUsage(false);
    }

    @Test
    public void testGetSFTPFileBasicRead() throws IOException {
        this.emptyTestDirectory();
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile1.txt");
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile2.txt");
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile3.txt");
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile4.txt");
        this.getSFTPRunner.run();
        this.getSFTPRunner.assertTransferCount(GetSFTP.REL_SUCCESS, 4);
        for (int i = 1; i < 5; ++i) {
            Path file1 = Paths.get(sshTestServer.getVirtualFileSystemPath() + "/testFile" + i + ".txt", new String[0]);
            Assertions.assertFalse((boolean)file1.toAbsolutePath().toFile().exists(), (String)"File not deleted.");
        }
        this.getSFTPRunner.clearTransferState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSFTPShouldNotThrowIOExceptionIfUserHomeDirNotExixts() throws IOException {
        this.emptyTestDirectory();
        String userHome = System.getProperty("user.home");
        try {
            System.setProperty("user.home", "/not_existdir");
            this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile1.txt");
            this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile2.txt");
            this.getSFTPRunner.run();
            this.getSFTPRunner.assertTransferCount(GetSFTP.REL_SUCCESS, 2);
            for (int i = 1; i < 3; ++i) {
                Path file1 = Paths.get(sshTestServer.getVirtualFileSystemPath() + "/testFile" + i + ".txt", new String[0]);
                Assertions.assertFalse((boolean)file1.toAbsolutePath().toFile().exists(), (String)"File not deleted.");
            }
            this.getSFTPRunner.clearTransferState();
        }
        finally {
            System.setProperty("user.home", userHome);
        }
    }

    @Test
    public void testGetSFTPIgnoreDottedFiles() throws IOException {
        this.emptyTestDirectory();
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile1.txt");
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + ".testFile2.txt");
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + "testFile3.txt");
        this.touchFile(sshTestServer.getVirtualFileSystemPath() + ".testFile4.txt");
        this.getSFTPRunner.run();
        this.getSFTPRunner.assertTransferCount(GetSFTP.REL_SUCCESS, 2);
        Path file1 = Paths.get(sshTestServer.getVirtualFileSystemPath() + "/testFile1.txt", new String[0]);
        Assertions.assertFalse((boolean)file1.toAbsolutePath().toFile().exists(), (String)"File not deleted.");
        file1 = Paths.get(sshTestServer.getVirtualFileSystemPath() + "/testFile3.txt", new String[0]);
        Assertions.assertFalse((boolean)file1.toAbsolutePath().toFile().exists(), (String)"File not deleted.");
        file1 = Paths.get(sshTestServer.getVirtualFileSystemPath() + "/.testFile2.txt", new String[0]);
        Assertions.assertTrue((boolean)file1.toAbsolutePath().toFile().exists(), (String)"File deleted.");
        file1 = Paths.get(sshTestServer.getVirtualFileSystemPath() + "/.testFile4.txt", new String[0]);
        Assertions.assertTrue((boolean)file1.toAbsolutePath().toFile().exists(), (String)"File deleted.");
        this.getSFTPRunner.clearTransferState();
    }

    private void touchFile(String file) throws IOException {
        FileUtils.writeStringToFile((File)new File(file), (String)"", (String)"UTF-8");
    }

    private void emptyTestDirectory() throws IOException {
        Path dir = Paths.get(sshTestServer.getVirtualFileSystemPath(), new String[0]);
        FileUtils.cleanDirectory((File)dir.toFile());
    }
}

