/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.ExtractText;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExtractText {
    final String SAMPLE_STRING = "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n";

    @Test
    public void testProcessor() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty("regex.result1", "(?s)(.*)");
        testRunner.setProperty("regex.result2", "(?s).*(bar1).*");
        testRunner.setProperty("regex.result3", "(?s).*?(bar\\d).*");
        testRunner.setProperty("regex.result4", "(?s).*?(?:bar\\d).*?(bar\\d).*?(bar3).*");
        testRunner.setProperty("regex.result5", "(?s).*(bar\\d).*");
        testRunner.setProperty("regex.result6", "(?s)^(.*)$");
        testRunner.setProperty("regex.result7", "(?s)(XXX)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result2", "bar1");
        out.assertAttributeEquals("regex.result3", "bar1");
        out.assertAttributeEquals("regex.result4", "bar2");
        out.assertAttributeEquals("regex.result4.0", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result4.1", "bar2");
        out.assertAttributeEquals("regex.result4.2", "bar3");
        out.assertAttributeNotExists("regex.result4.3");
        out.assertAttributeEquals("regex.result5", "bar3");
        out.assertAttributeEquals("regex.result6", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result7", null);
    }

    @Test
    public void testWithUnmatchedOptionalCapturingGroup() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty("regex", "abc(def)?(g)");
        testRunner.enqueue("abcg");
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeNotExists("regex.1");
        out.assertAttributeEquals("regex.2", "g");
        testRunner.clearTransferState();
        testRunner.enqueue("abcdefg");
        testRunner.run();
        MockFlowFile out2 = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out2.assertAttributeEquals("regex.1", "def");
        out2.assertAttributeEquals("regex.2", "g");
    }

    @Test
    public void testProcessorWithDotall() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty("regex.result1", "(.*)");
        testRunner.setProperty("regex.result2", ".*(bar1).*");
        testRunner.setProperty("regex.result3", ".*?(bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(bar\\d).*");
        testRunner.setProperty("regex.result5", ".*(bar\\d).*");
        testRunner.setProperty("regex.result6", "^(.*)$");
        testRunner.setProperty("regex.result7", "^(XXX)$");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result2", "bar1");
        out.assertAttributeEquals("regex.result3", "bar1");
        out.assertAttributeEquals("regex.result4", "bar2");
        out.assertAttributeEquals("regex.result5", "bar3");
        out.assertAttributeEquals("regex.result6", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result7", null);
    }

    @Test
    public void testProcessorWithMultiline() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        testRunner.setProperty("regex.result1", "(.*)");
        testRunner.setProperty("regex.result2", "(bar1)");
        testRunner.setProperty("regex.result3", ".*?(bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(bar\\d).*");
        testRunner.setProperty("regex.result4b", "bar\\d\\r\\n(bar\\d)");
        testRunner.setProperty("regex.result5", ".*(bar\\d).*");
        testRunner.setProperty("regex.result5b", "(?:bar\\d\\r?\\n)*(bar\\d)");
        testRunner.setProperty("regex.result6", "^(.*)$");
        testRunner.setProperty("regex.result7", "^(XXX)$");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1", "foo");
        out.assertAttributeEquals("regex.result2", "bar1");
        out.assertAttributeEquals("regex.result3", "bar1");
        out.assertAttributeEquals("regex.result4", null);
        out.assertAttributeEquals("regex.result4b", "bar2");
        out.assertAttributeEquals("regex.result5", "bar1");
        out.assertAttributeEquals("regex.result5b", "bar3");
        out.assertAttributeEquals("regex.result6", "foo");
        out.assertAttributeEquals("regex.result7", null);
    }

    @Test
    public void testProcessorWithMultilineAndDotall() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty("regex.result1", "(.*)");
        testRunner.setProperty("regex.result2", "(bar1)");
        testRunner.setProperty("regex.result3", ".*?(bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(bar\\d).*");
        testRunner.setProperty("regex.result4b", "bar\\d\\r\\n(bar\\d)");
        testRunner.setProperty("regex.result5", ".*(bar\\d).*");
        testRunner.setProperty("regex.result5b", "(?:bar\\d\\r?\\n)*(bar\\d)");
        testRunner.setProperty("regex.result6", "^(.*)$");
        testRunner.setProperty("regex.result7", "^(XXX)$");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result2", "bar1");
        out.assertAttributeEquals("regex.result3", "bar1");
        out.assertAttributeEquals("regex.result4", "bar2");
        out.assertAttributeEquals("regex.result4b", "bar2");
        out.assertAttributeEquals("regex.result5", "bar3");
        out.assertAttributeEquals("regex.result5b", "bar3");
        out.assertAttributeEquals("regex.result6", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
        out.assertAttributeEquals("regex.result7", null);
    }

    @Test
    public void testProcessorWithNoMatches() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty("regex.result2", "(bar1)");
        testRunner.setProperty("regex.result3", ".*?(bar\\d).*");
        testRunner.setProperty("regex.result4", ".*?(?:bar\\d).*?(bar\\d).*");
        testRunner.setProperty("regex.result4b", "bar\\d\\r\\n(bar\\d)");
        testRunner.setProperty("regex.result5", ".*(bar\\d).*");
        testRunner.setProperty("regex.result5b", "(?:bar\\d\\r?\\n)*(bar\\d)");
        testRunner.setProperty("regex.result7", "^(XXX)$");
        testRunner.enqueue("YYY".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_NO_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_NO_MATCH).get(0);
        out.assertAttributeEquals("regex.result1", null);
        out.assertAttributeEquals("regex.result2", null);
        out.assertAttributeEquals("regex.result3", null);
        out.assertAttributeEquals("regex.result4", null);
        out.assertAttributeEquals("regex.result4b", null);
        out.assertAttributeEquals("regex.result5", null);
        out.assertAttributeEquals("regex.result5b", null);
        out.assertAttributeEquals("regex.result6", null);
        out.assertAttributeEquals("regex.result7", null);
    }

    @Test
    public void testNoFlowFile() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 0);
    }

    @Test
    public void testMatchOutsideBuffer() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.MAX_BUFFER_SIZE, "3 B");
        testRunner.setProperty("regex.result1", "(foo)");
        testRunner.setProperty("regex.result2", "(world)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeEquals("regex.result1", "foo");
        out.assertAttributeEquals("regex.result2", null);
    }

    @Test
    public void testGetCompileFlags() {
        ExtractText processor = new ExtractText();
        TestRunner testRunner = TestRunners.newTestRunner((Processor)processor);
        int flags = processor.getCompileFlags(testRunner.getProcessContext());
        Assertions.assertEquals((int)0, (int)flags);
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.UNIX_LINES, "true");
        Assertions.assertEquals((int)1, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.CASE_INSENSITIVE, "true");
        Assertions.assertEquals((int)2, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.COMMENTS, "true");
        Assertions.assertEquals((int)4, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        Assertions.assertEquals((int)8, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.LITERAL, "true");
        Assertions.assertEquals((int)16, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.DOTALL, "true");
        Assertions.assertEquals((int)32, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.UNICODE_CASE, "true");
        Assertions.assertEquals((int)64, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.CANON_EQ, "true");
        Assertions.assertEquals((int)128, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.UNICODE_CHARACTER_CLASS, "true");
        Assertions.assertEquals((int)256, (int)processor.getCompileFlags(testRunner.getProcessContext()));
        testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.setProperty(ExtractText.DOTALL, "true");
        testRunner.setProperty(ExtractText.MULTILINE, "true");
        Assertions.assertEquals((int)40, (int)processor.getCompileFlags(testRunner.getProcessContext()));
    }

    @Test
    public void testGetRelationShips() {
        ExtractText processor = new ExtractText();
        TestRunner testRunner = TestRunners.newTestRunner((Processor)processor);
        testRunner.enqueue("foo".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        Set relationships = processor.getRelationships();
        Assertions.assertTrue((boolean)relationships.contains(ExtractText.REL_MATCH));
        Assertions.assertTrue((boolean)relationships.contains(ExtractText.REL_NO_MATCH));
        Assertions.assertEquals((int)2, (int)relationships.size());
    }

    @Test
    public void testIncludeZeroCaptureGroupProperty() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s)(.*)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeExists("regex.result.0");
        out.assertAttributeEquals("regex.result", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
    }

    @Test
    public void testFindAll() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_REPEATING_CAPTURE_GROUP, "true");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s)(\\w+)");
        testRunner.enqueue("This is my text".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeExists("regex.result.0");
        out.assertAttributeExists("regex.result.1");
        out.assertAttributeExists("regex.result.2");
        out.assertAttributeExists("regex.result.3");
        out.assertAttributeExists("regex.result.4");
        out.assertAttributeEquals("regex.result", "This");
        out.assertAttributeEquals("regex.result.0", "This");
        out.assertAttributeEquals("regex.result.1", "This");
        out.assertAttributeEquals("regex.result.2", "is");
        out.assertAttributeEquals("regex.result.3", "my");
        out.assertAttributeEquals("regex.result.4", "text");
    }

    @Test
    public void testFindAllPair() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.ENABLE_REPEATING_CAPTURE_GROUP, "true");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(\\w+)=(\\d+)");
        testRunner.enqueue("a=1,b=10,c=100".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeExists("regex.result.0");
        out.assertAttributeExists("regex.result.1");
        out.assertAttributeExists("regex.result.2");
        out.assertAttributeExists("regex.result.3");
        out.assertAttributeExists("regex.result.4");
        out.assertAttributeExists("regex.result.5");
        out.assertAttributeExists("regex.result.6");
        out.assertAttributeNotExists("regex.result.7");
        out.assertAttributeEquals("regex.result", "a");
        out.assertAttributeEquals("regex.result.0", "a=1");
        out.assertAttributeEquals("regex.result.1", "a");
        out.assertAttributeEquals("regex.result.2", "1");
        out.assertAttributeEquals("regex.result.3", "b");
        out.assertAttributeEquals("regex.result.4", "10");
        out.assertAttributeEquals("regex.result.5", "c");
        out.assertAttributeEquals("regex.result.6", "100");
    }

    @Test
    public void testIgnoreZeroCaptureGroupProperty() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.INCLUDE_CAPTURE_GROUP_ZERO, "false");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s)(.*)");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeNotExists("regex.result.0");
        out.assertAttributeEquals("regex.result", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
    }

    @Test
    public void testShouldAllowNoCaptureGroups() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s).*");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        testRunner.run();
        testRunner.assertAllFlowFilesTransferred(ExtractText.REL_MATCH, 1);
        MockFlowFile out = (MockFlowFile)testRunner.getFlowFilesForRelationship(ExtractText.REL_MATCH).get(0);
        out.assertAttributeNotExists("regex.result");
        out.assertAttributeEquals("regex.result.0", "foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n");
    }

    @Test
    public void testShouldNotAllowNoCaptureGroupsIfZeroDisabled() {
        TestRunner testRunner = TestRunners.newTestRunner((Processor)new ExtractText());
        testRunner.setProperty(ExtractText.INCLUDE_CAPTURE_GROUP_ZERO, "false");
        String attributeKey = "regex.result";
        testRunner.setProperty("regex.result", "(?s).*");
        testRunner.enqueue("foo\r\nbar1\r\nbar2\r\nbar3\r\nhello\r\nworld\r\n".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(AssertionError.class, () -> testRunner.run());
    }
}

