/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.json.JsonRecordSetWriter;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.processors.standard.UpdateRecord;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS}, disabledReason="Test only runs on *nix")
public class TestUpdateRecord {
    private TestRunner runner;
    private MockRecordParser readerService;
    private MockRecordWriter writerService;

    @BeforeEach
    public void setup() throws InitializationException {
        this.readerService = new MockRecordParser();
        this.writerService = new MockRecordWriter("header", false);
        this.runner = TestRunners.newTestRunner(UpdateRecord.class);
        this.runner.addControllerService("reader", (ControllerService)this.readerService);
        this.runner.enableControllerService((ControllerService)this.readerService);
        this.runner.addControllerService("writer", (ControllerService)this.writerService);
        this.runner.enableControllerService((ControllerService)this.writerService);
        this.runner.setProperty(UpdateRecord.RECORD_READER, "reader");
        this.runner.setProperty(UpdateRecord.RECORD_WRITER, "writer");
        this.readerService.addSchemaField("name", RecordFieldType.STRING);
        this.readerService.addSchemaField("age", RecordFieldType.INT);
    }

    @Test
    public void testLiteralReplacementValue() {
        this.runner.setProperty("/name", "Jane Doe");
        this.runner.enqueue("");
        this.readerService.addRecord(new Object[]{"John Doe", 35});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        out.assertContentEquals("header\nJane Doe,35\n");
    }

    @Test
    public void testLiteralReplacementValueExpressionLanguage() {
        this.runner.setProperty("/name", "${newName}");
        this.runner.enqueue("", Collections.singletonMap("newName", "Jane Doe"));
        this.readerService.addRecord(new Object[]{"John Doe", 35});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        out.assertContentEquals("header\nJane Doe,35\n");
    }

    @Test
    public void testRecordPathReplacementValue() {
        this.runner.setProperty("/name", "/age");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES.getValue());
        this.runner.enqueue("");
        this.readerService.addRecord(new Object[]{"John Doe", 35});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        out.assertContentEquals("header\n35,35\n");
    }

    @Test
    public void testRecordPathReplacementWithFilterFunctionCall() {
        this.runner.setProperty("/hasAge", "not(isEmpty(/age))");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES.getValue());
        this.runner.enqueue("");
        this.readerService.addRecord(new Object[]{"John Doe", 35});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        out.assertContentEquals("header\nJohn Doe,35,true\n");
    }

    @Test
    public void testInvalidRecordPathUsingExpressionLanguage() {
        this.runner.setProperty("/name", "${recordPath}");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES.getValue());
        this.runner.enqueue("", Collections.singletonMap("recordPath", "hello"));
        this.readerService.addRecord(new Object[]{"John Doe", 35});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_FAILURE, 1);
    }

    @Test
    public void testLiteralReplacementRowIndexValueExpressionLanguage() throws InitializationException {
        this.readerService = new MockRecordParser();
        this.readerService.addSchemaField("id", RecordFieldType.LONG);
        this.readerService.addSchemaField("name", RecordFieldType.STRING);
        this.readerService.addSchemaField("age", RecordFieldType.INT);
        this.runner.addControllerService("reader", (ControllerService)this.readerService);
        this.runner.enableControllerService((ControllerService)this.readerService);
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.LITERAL_VALUES);
        this.runner.setProperty("/id", "${record.index}");
        this.runner.enqueue("");
        this.readerService.addRecord(new Object[]{null, "John Doe", 35});
        this.readerService.addRecord(new Object[]{null, "Jane Doe", 36});
        this.readerService.addRecord(new Object[]{null, "John Smith", 37});
        this.readerService.addRecord(new Object[]{null, "Jane Smith", 38});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile out = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        out.assertContentEquals("header\n1,John Doe,35\n2,Jane Doe,36\n3,John Smith,37\n4,Jane Smith,38\n");
    }

    @Test
    public void testReplaceWithMissingRecordPath() throws InitializationException {
        this.readerService = new MockRecordParser();
        this.readerService.addSchemaField("name", RecordFieldType.STRING);
        this.readerService.addSchemaField("siblings", RecordFieldType.ARRAY);
        this.runner.addControllerService("reader", (ControllerService)this.readerService);
        this.runner.enableControllerService((ControllerService)this.readerService);
        this.runner.setProperty("/name", "/siblings[0]/name");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES.getValue());
        this.runner.enqueue("", Collections.singletonMap("recordPath", "hello"));
        this.readerService.addRecord(new Object[]{"John Doe", null});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        mff.assertContentEquals("header\n,\n");
    }

    @Test
    public void testRelativePath() throws InitializationException {
        this.readerService = new MockRecordParser();
        this.readerService.addSchemaField("name", RecordFieldType.STRING);
        this.readerService.addSchemaField("nickname", RecordFieldType.STRING);
        this.runner.addControllerService("reader", (ControllerService)this.readerService);
        this.runner.enableControllerService((ControllerService)this.readerService);
        this.runner.setProperty("/name", "../nickname");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES.getValue());
        this.runner.enqueue("", Collections.singletonMap("recordPath", "hello"));
        this.readerService.addRecord(new Object[]{"John Doe", "Johnny"});
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        MockFlowFile mff = (MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0);
        mff.assertContentEquals("header\nJohnny,Johnny\n");
    }

    @Test
    public void testConcatWithArrayInferredSchema() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaInferenceUtil.INFER_SCHEMA);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.INHERIT_RECORD_SCHEMA);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/addresses.json", new String[0]));
        this.runner.setProperty("/addresses[*]/full", "concat(../street, ' ', ../city, ' ', ../state)");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/full-addresses.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testChangingSchema() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/name", "/name/first");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/person-with-firstname.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testUpdateInArray() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-address.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-address.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person-address.json", new String[0]));
        this.runner.setProperty("/address[*]/city", "newCity");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.LITERAL_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/person-with-new-city.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testUpdateInNullArray() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-address.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-address.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person-with-null-array.json", new String[0]));
        this.runner.setProperty("/address[*]/city", "newCity");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.LITERAL_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/person-with-null-array.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testAddFieldNotInInputRecord() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-string-fields.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/firstName", "/name/first");
        this.runner.setProperty("/lastName", "/name/last");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/person-with-firstname-lastname.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testFieldValuesInEL() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/name/last", "${field.value:toUpper()}");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.LITERAL_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/person-with-capital-lastname.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testSetRootPathAbsoluteWithMultipleValues() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/name-fields-only.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/", "/name/*");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/name-fields-only.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testSetRootPathAbsoluteWithSingleValue() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/name-fields-only.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/", "/name");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/name-fields-only.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testSetRootPathRelativeWithMultipleValues() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/name-fields-only.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/name/..", "/name/*");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/name-fields-only.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testSetRootPathRelativeWithSingleValue() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-record.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/name-fields-only.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/name/..", "/name");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/name-fields-only.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testSetAbsolutePathWithAnotherRecord() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-and-mother.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/person-with-name-and-mother.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/person.json", new String[0]));
        this.runner.setProperty("/name", "/mother");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/name-and-mother-same.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
    }

    @Test
    public void testUpdateSimpleArray() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/multi-arrays.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/multi-arrays.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.LITERAL_VALUES);
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/numbers[*]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0])));
        expectedOutput = expectedOutput.replaceFirst("1, null, 4", "8, 8, 8");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/numbers[*]");
        this.runner.clearTransferState();
        this.runner.enqueue("{\"numbers\":null}");
        this.runner.setProperty("/numbers[*]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        Assertions.assertTrue((boolean)content.contains("\"numbers\" : null"));
        this.runner.removeProperty("/numbers[*]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/numbers[1]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0])));
        expectedOutput = expectedOutput.replaceFirst("1, null, 4", "1, 8, 4");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/numbers[1]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/numbers[0..1]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0])));
        expectedOutput = expectedOutput.replaceFirst("1, null, 4", "8, 8, 4");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/numbers[0..1]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/numbers[0,2]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0])));
        expectedOutput = expectedOutput.replaceFirst("1, null, 4", "8, null, 8");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/numbers[0,2]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/numbers[0,1..2]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0])));
        expectedOutput = expectedOutput.replaceFirst("1, null, 4", "8, 8, 8");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/numbers[0,1..2]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/numbers[0..-1][. = 4]", "8");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0])));
        expectedOutput = expectedOutput.replaceFirst("1, null, 4", "1, null, 8");
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/numbers[0..-1][. = 4]");
    }

    @Test
    public void testUpdateComplexArrays() throws InitializationException, IOException {
        JsonTreeReader jsonReader = new JsonTreeReader();
        this.runner.addControllerService("reader", (ControllerService)jsonReader);
        String inputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/multi-arrays.avsc", new String[0])));
        String outputSchemaText = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/schema/multi-arrays.avsc", new String[0])));
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonReader, SchemaAccessUtils.SCHEMA_TEXT, inputSchemaText);
        this.runner.enableControllerService((ControllerService)jsonReader);
        JsonRecordSetWriter jsonWriter = new JsonRecordSetWriter();
        this.runner.addControllerService("writer", (ControllerService)jsonWriter);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        this.runner.setProperty((ControllerService)jsonWriter, SchemaAccessUtils.SCHEMA_TEXT, outputSchemaText);
        this.runner.setProperty((ControllerService)jsonWriter, "Pretty Print JSON", "true");
        this.runner.setProperty((ControllerService)jsonWriter, "Schema Write Strategy", "full-schema-attribute");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.RECORD_PATH_VALUES);
        this.runner.enableControllerService((ControllerService)jsonWriter);
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[*]", "/peoples[3]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        int count = StringUtils.countMatches((CharSequence)content, (CharSequence)"Mary Doe");
        Assertions.assertEquals((int)4, (int)count);
        this.runner.removeProperty("/peoples[*]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[1]", "/peoples[3]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        count = StringUtils.countMatches((CharSequence)content, (CharSequence)"Mary Doe");
        Assertions.assertEquals((int)2, (int)count);
        this.runner.removeProperty("/peoples[1]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0..1]", "/peoples[3]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        String expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/updateArrays/multi-arrays-0and1.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/peoples[0..1]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0,2]", "/peoples[3]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/updateArrays/multi-arrays-0and2.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/peoples[0,2]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0,1..2]", "/peoples[3]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        count = StringUtils.countMatches((CharSequence)content, (CharSequence)"Mary Doe");
        Assertions.assertEquals((int)4, (int)count);
        this.runner.removeProperty("/peoples[0,1..2]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0..-1][./name != 'Mary Doe']", "/peoples[3]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        count = StringUtils.countMatches((CharSequence)content, (CharSequence)"Mary Doe");
        Assertions.assertEquals((int)4, (int)count);
        this.runner.removeProperty("/peoples[0..-1][./name != 'Mary Doe']");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0..-1][./name != 'Mary Doe']/addresses[*]", "/peoples[3]/addresses[0]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        count = StringUtils.countMatches((CharSequence)content, (CharSequence)"1 nifi road");
        Assertions.assertEquals((int)13, (int)count);
        this.runner.removeProperty("/peoples[0..-1][./name != 'Mary Doe']/addresses[*]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0..-1][./name != 'Mary Doe']/addresses[0,1..2]", "/peoples[3]/addresses[0]");
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        expectedOutput = new String(Files.readAllBytes(Paths.get("src/test/resources/TestUpdateRecord/output/updateArrays/multi-arrays-streets.json", new String[0])));
        ((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).assertContentEquals(expectedOutput);
        this.runner.removeProperty("/peoples[0..-1][./name != 'Mary Doe']/addresses[0,1..2]");
        this.runner.clearTransferState();
        this.runner.enqueue(Paths.get("src/test/resources/TestUpdateRecord/input/multi-arrays.json", new String[0]));
        this.runner.setProperty("/peoples[0..-1][./name != 'Mary Doe']/addresses[0,1..2]/city", "newCity");
        this.runner.setProperty(UpdateRecord.REPLACEMENT_VALUE_STRATEGY, UpdateRecord.LITERAL_VALUES);
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(UpdateRecord.REL_SUCCESS, 1);
        content = new String(((MockFlowFile)this.runner.getFlowFilesForRelationship(UpdateRecord.REL_SUCCESS).get(0)).toByteArray());
        count = StringUtils.countMatches((CharSequence)content, (CharSequence)"newCity");
        Assertions.assertEquals((int)9, (int)count);
        this.runner.removeProperty("/peoples[0..-1][./name != 'Mary Doe']/addresses[0,1..2]/city");
    }
}

