/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.MockRecordSinkService;
import org.apache.nifi.processors.standard.PutRecord;
import org.apache.nifi.serialization.record.MockRecordParser;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPutRecord {
    private TestRunner testRunner;
    private MockRecordParser recordReader;
    private MockRecordSinkService mockRecordSinkService;

    @BeforeEach
    public void setup() {
        PutRecord processor = new PutRecord();
        this.testRunner = TestRunners.newTestRunner((Processor)processor);
        this.recordReader = new MockRecordParser();
        this.testRunner.setProperty(PutRecord.RECORD_READER, "reader");
        this.mockRecordSinkService = new MockRecordSinkService();
        this.testRunner.setProperty(PutRecord.RECORD_SINK, "MockRecordSinkService");
    }

    @Test
    public void testSimplePut() throws Exception {
        this.testRunner.addControllerService("reader", (ControllerService)this.recordReader);
        this.testRunner.enableControllerService((ControllerService)this.recordReader);
        this.testRunner.addControllerService("MockRecordSinkService", (ControllerService)this.mockRecordSinkService);
        this.testRunner.enableControllerService((ControllerService)this.mockRecordSinkService);
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.STRING);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, "Soccer"});
        this.recordReader.addRecord(new Object[]{"Jane Doe", 47, "Tennis"});
        this.recordReader.addRecord(new Object[]{"Sally Doe", 47, "Curling"});
        this.recordReader.addRecord(new Object[]{"Jimmy Doe", 14, null});
        this.recordReader.addRecord(new Object[]{"Pizza Doe", 14, null});
        this.testRunner.enqueue("");
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(PutRecord.REL_SUCCESS, 1);
    }

    @Test
    public void testNoRows() throws Exception {
        this.testRunner.addControllerService("reader", (ControllerService)this.recordReader);
        this.testRunner.enableControllerService((ControllerService)this.recordReader);
        this.testRunner.addControllerService("MockRecordSinkService", (ControllerService)this.mockRecordSinkService);
        this.testRunner.enableControllerService((ControllerService)this.mockRecordSinkService);
        this.testRunner.setProperty(PutRecord.INCLUDE_ZERO_RECORD_RESULTS, "false");
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.STRING);
        this.testRunner.enqueue("");
        this.testRunner.run();
        Assertions.assertTrue((boolean)this.mockRecordSinkService.getRows().isEmpty());
        Assertions.assertFalse((boolean)this.mockRecordSinkService.isTransmitted());
        this.testRunner.assertAllFlowFilesTransferred(PutRecord.REL_SUCCESS, 1);
        this.testRunner.clearTransferState();
        this.testRunner.setProperty(PutRecord.INCLUDE_ZERO_RECORD_RESULTS, "true");
        this.testRunner.enqueue("");
        this.testRunner.run();
        Assertions.assertTrue((boolean)this.mockRecordSinkService.getRows().isEmpty());
        Assertions.assertTrue((boolean)this.mockRecordSinkService.isTransmitted());
        this.testRunner.assertAllFlowFilesTransferred(PutRecord.REL_SUCCESS, 1);
    }

    @Test
    public void testBadRecords() throws Exception {
        this.recordReader = new MockRecordParser(1);
        this.testRunner.addControllerService("reader", (ControllerService)this.recordReader);
        this.testRunner.enableControllerService((ControllerService)this.recordReader);
        this.testRunner.addControllerService("MockRecordSinkService", (ControllerService)this.mockRecordSinkService);
        this.testRunner.enableControllerService((ControllerService)this.mockRecordSinkService);
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.STRING);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, "Soccer"});
        this.recordReader.addRecord(new Object[]{"Jane Doe", 47, "Tennis"});
        this.recordReader.addRecord(new Object[]{"Sally Doe", 47, "Curling"});
        this.recordReader.addRecord(new Object[]{"Jimmy Doe", 14, null});
        this.recordReader.addRecord(new Object[]{"Pizza Doe", 14, null});
        this.testRunner.enqueue("");
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(PutRecord.REL_FAILURE, 1);
    }

    @Test
    public void testRetryableError() throws Exception {
        this.recordReader = new MockRecordParser();
        this.testRunner.addControllerService("reader", (ControllerService)this.recordReader);
        this.testRunner.enableControllerService((ControllerService)this.recordReader);
        this.mockRecordSinkService.setFailWithRetryableError(true);
        this.testRunner.addControllerService("MockRecordSinkService", (ControllerService)this.mockRecordSinkService);
        this.testRunner.enableControllerService((ControllerService)this.mockRecordSinkService);
        this.recordReader.addSchemaField("name", RecordFieldType.STRING);
        this.recordReader.addSchemaField("age", RecordFieldType.INT);
        this.recordReader.addSchemaField("sport", RecordFieldType.STRING);
        this.recordReader.addRecord(new Object[]{"John Doe", 48, "Soccer"});
        this.testRunner.enqueue("");
        this.testRunner.run();
        this.testRunner.assertAllFlowFilesTransferred(PutRecord.REL_RETRY, 1);
    }
}

