/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.RouteOnAttribute;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.MockProcessContext;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouteOnAttribute {
    @Test
    public void testInvalidOnMisconfiguredProperty() {
        RouteOnAttribute proc = new RouteOnAttribute();
        MockProcessContext ctx = new MockProcessContext((ConfigurableComponent)proc);
        ValidationResult validationResult = ctx.setProperty("RouteA", "${a:equals('b')");
        Assertions.assertFalse((boolean)validationResult.isValid());
    }

    @Test
    public void testInvalidOnNonBooleanProperty() {
        RouteOnAttribute proc = new RouteOnAttribute();
        MockProcessContext ctx = new MockProcessContext((ConfigurableComponent)proc);
        ValidationResult validationResult = ctx.setProperty("RouteA", "${a:length()");
        Assertions.assertFalse((boolean)validationResult.isValid());
    }

    @Test
    public void testSimpleEquals() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteOnAttribute());
        runner.setProperty("RouteA", "${a:equals('b')}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "b");
        runner.enqueue(new byte[0], attributes);
        runner.run();
        runner.assertAllFlowFilesTransferred(new Relationship.Builder().name("RouteA").build(), 1);
        List flowFiles = runner.getFlowFilesForRelationship("RouteA");
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("a", "b");
        ((MockFlowFile)flowFiles.get(0)).assertAttributeEquals("RouteOnAttribute.Route", "RouteA");
    }

    @Test
    public void testMatchAll() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteOnAttribute());
        runner.setProperty(RouteOnAttribute.ROUTE_STRATEGY, RouteOnAttribute.ROUTE_ALL_MATCH.getValue());
        runner.setProperty("RouteA", "${a:equals('b')}");
        runner.setProperty("RouteB", "${b:equals('a')}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "b");
        attributes.put("b", "a");
        runner.enqueue(new byte[0], attributes);
        attributes.put("b", "b");
        runner.enqueue(new byte[0], attributes);
        attributes.put("a", "a");
        attributes.put("b", "b");
        runner.enqueue(new byte[0], attributes);
        runner.enqueue(new byte[0]);
        runner.run(4);
        List match = runner.getFlowFilesForRelationship(RouteOnAttribute.REL_MATCH);
        List noMatch = runner.getFlowFilesForRelationship(RouteOnAttribute.REL_NO_MATCH);
        Assertions.assertEquals((int)1, (int)match.size());
        Assertions.assertEquals((int)3, (int)noMatch.size());
        for (MockFlowFile ff : noMatch) {
            ff.assertAttributeEquals("RouteOnAttribute.Route", "unmatched");
        }
        Map matchedAttrs = ((MockFlowFile)match.iterator().next()).getAttributes();
        Assertions.assertEquals((Object)"b", matchedAttrs.get("a"));
        Assertions.assertEquals((Object)"a", matchedAttrs.get("b"));
        Assertions.assertEquals((Object)"matched", matchedAttrs.get("RouteOnAttribute.Route"));
    }

    @Test
    public void testMatchAny() {
        TestRunner runner = TestRunners.newTestRunner((Processor)new RouteOnAttribute());
        runner.setThreadCount(4);
        runner.setProperty(RouteOnAttribute.ROUTE_STRATEGY, RouteOnAttribute.ROUTE_ANY_MATCHES.getValue());
        runner.setProperty("RouteA", "${a:equals('b')}");
        runner.setProperty("RouteB", "${b:equals('a')}");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "b");
        attributes.put("b", "a");
        runner.enqueue(new byte[0], attributes);
        attributes.put("b", "b");
        runner.enqueue(new byte[0], attributes);
        attributes.put("a", "a");
        attributes.put("b", "b");
        runner.enqueue(new byte[0], attributes);
        runner.enqueue(new byte[0]);
        runner.run(4);
        List match = runner.getFlowFilesForRelationship(RouteOnAttribute.REL_MATCH);
        List noMatch = runner.getFlowFilesForRelationship(RouteOnAttribute.REL_NO_MATCH);
        Assertions.assertEquals((int)2, (int)match.size());
        Assertions.assertEquals((int)2, (int)noMatch.size());
        Iterator itr = match.iterator();
        Map attrs1 = ((MockFlowFile)itr.next()).getAttributes();
        Map attrs2 = ((MockFlowFile)itr.next()).getAttributes();
        Assertions.assertEquals((Object)"b", attrs1.get("a"));
        Assertions.assertEquals((Object)"b", attrs1.get("a"));
        if ("a".equals(attrs1.get("b"))) {
            Assertions.assertEquals((Object)"b", attrs2.get("b"));
        } else {
            Assertions.assertEquals((Object)"b", attrs1.get("b"));
            Assertions.assertEquals((Object)"a", attrs2.get("b"));
        }
        runner.clearTransferState();
    }
}

