/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.GetJMSQueue;
import org.apache.nifi.processors.standard.PutJMS;
import org.apache.nifi.processors.standard.util.JmsFactory;
import org.apache.nifi.processors.standard.util.JmsProperties;
import org.apache.nifi.processors.standard.util.WrappedMessageProducer;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Disabled(value="Processor requires updates to work with Mockito 2.x, but is deprecated.")
public class TestPutJMS {
    private final String TEST_PROVIDER = "ActiveMQ";
    private final String TEST_URL = "vm://localhost?broker.persistent=false";
    private final String TEST_DEST_TYPE = "Queue";
    private final String TEST_DEST_NAME = "queue.testing";
    private final String TEST_ACK_MODE = "Auto Acknowledge";

    private String testQueueSuffix() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return "." + trace[2].getMethodName();
    }

    private void injectFieldValue(Class klass, Object instance, String fieldName, Object fieldValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = klass.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(instance, fieldValue);
    }

    @Test
    public void testGetRelationships() {
        PutJMS putJMS = new PutJMS();
        Set relationships = putJMS.getRelationships();
        Assertions.assertEquals((int)2, (int)relationships.size());
        Assertions.assertTrue((boolean)relationships.contains(PutJMS.REL_FAILURE));
        Assertions.assertTrue((boolean)relationships.contains(PutJMS.REL_SUCCESS));
    }

    @Test
    public void testCleanupResources() throws JMSException, NoSuchFieldException, IllegalAccessException {
        PutJMS putJMS = new PutJMS();
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        Queue wrappedMessageProducerQueue = (Queue)Mockito.spy(new LinkedBlockingQueue());
        this.injectFieldValue(PutJMS.class, putJMS, "producerQueue", wrappedMessageProducerQueue);
        WrappedMessageProducer wrappedProducer = JmsFactory.createMessageProducer((ProcessContext)runnerPut.getProcessContext(), (boolean)true);
        wrappedMessageProducerQueue.offer(wrappedProducer);
        Assertions.assertNotNull(wrappedMessageProducerQueue.peek());
        putJMS.cleanupResources();
        Assertions.assertNull(wrappedMessageProducerQueue.peek());
    }

    @Test
    public void testCreateMessageDirectly() throws JMSException {
        PutJMS putJMS = new PutJMS();
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        WrappedMessageProducer wrappedProducer = JmsFactory.createMessageProducer((ProcessContext)runnerPut.getProcessContext(), (boolean)true);
        Session jmsSession = wrappedProducer.getSession();
        MessageProducer producer = wrappedProducer.getProducer();
        TextMessage message = jmsSession.createTextMessage("createMessageDirectly");
        producer.send((Message)message);
        jmsSession.commit();
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runnerGet = TestRunners.newTestRunner((Processor)getJmsQueue);
        runnerGet.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerGet.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerGet.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerGet.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runnerGet.run();
        List flowFiles = runnerGet.getFlowFilesForRelationship(new Relationship.Builder().name("success").build());
        Assertions.assertEquals((int)1, (int)flowFiles.size());
        MockFlowFile successFlowFile = (MockFlowFile)flowFiles.get(0);
        successFlowFile.assertContentEquals("createMessageDirectly");
        successFlowFile.assertAttributeEquals("jms.JMSDestination", "queue.testing" + this.testQueueSuffix());
        producer.close();
        jmsSession.close();
    }

    @Test
    public void testPutGetAttributesAndProps() {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.REPLY_TO_QUEUE, "queue.testing" + this.testQueueSuffix() + ".reply");
        runnerPut.setProperty(JmsProperties.ATTRIBUTES_TO_JMS_PROPS, "true");
        runnerPut.run();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        attributes.put("jms.string", "banana");
        attributes.put("jms.integer", "50");
        attributes.put("jms.integer.type", "integer");
        attributes.put("jms.float", "3.14159");
        attributes.put("jms.float.type", "float");
        attributes.put("jms.boolean", "true");
        attributes.put("jms.boolean.type", "boolean");
        attributes.put("jms.long", "123456789");
        attributes.put("jms.long.type", "long");
        attributes.put("jms.short", "16384");
        attributes.put("jms.short.type", "short");
        attributes.put("jms.byte", "127");
        attributes.put("jms.byte.type", "byte");
        attributes.put("jms.double", "3.1415626547");
        attributes.put("jms.double.type", "double");
        attributes.put("jms.object", "{\"id\":215, \"name\": \"john doe\"}");
        attributes.put("jms.object.type", "object");
        attributes.put("jms.eyes", "blue");
        attributes.put("jms.eyes.type", "color");
        attributes.put("jms.badinteger", "3.14");
        attributes.put("jms.badinteger.type", "integer");
        runnerPut.enqueue("putGetMessage".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runnerGet = TestRunners.newTestRunner((Processor)getJmsQueue);
        runnerGet.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerGet.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerGet.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerGet.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runnerGet.setProperty(JmsProperties.JMS_PROPS_TO_ATTRIBUTES, "true");
        runnerGet.run();
        Assertions.assertEquals((int)1, (int)runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS).size());
        List flowFilesGet = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)flowFilesGet.size());
        MockFlowFile successFlowFile = (MockFlowFile)flowFilesGet.get(0);
        successFlowFile.assertContentEquals("putGetMessage");
        successFlowFile.assertAttributeEquals("jms.JMSDestination", "queue.testing" + this.testQueueSuffix());
        successFlowFile.assertAttributeEquals("jms.JMSReplyTo", "queue://queue.testing" + this.testQueueSuffix() + ".reply");
        successFlowFile.assertAttributeEquals("jms.string", "banana");
        successFlowFile.assertAttributeEquals("jms.integer", "50");
        successFlowFile.assertAttributeEquals("jms.float", "3.14159");
        successFlowFile.assertAttributeEquals("jms.boolean", "true");
        successFlowFile.assertAttributeEquals("jms.long", "123456789");
        successFlowFile.assertAttributeEquals("jms.short", "16384");
        successFlowFile.assertAttributeEquals("jms.byte", "127");
        successFlowFile.assertAttributeEquals("jms.double", "3.1415626547");
        successFlowFile.assertAttributeEquals("jms.object", "{\"id\":215, \"name\": \"john doe\"}");
        successFlowFile.assertAttributeEquals("jms.eyes", null);
        successFlowFile.assertAttributeEquals("jms.badinteger", null);
    }

    @Test
    public void testPutGetMessageTypes() {
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runnerGet = TestRunners.newTestRunner((Processor)getJmsQueue);
        runnerGet.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerGet.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerGet.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerGet.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runnerGet.setProperty(JmsProperties.JMS_PROPS_TO_ATTRIBUTES, "true");
        PutJMS putJMStext = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPutText = TestRunners.newTestRunner((Processor)putJMStext);
        runnerPutText.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPutText.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPutText.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPutText.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPutText.setProperty(JmsProperties.MESSAGE_TYPE, "text");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        runnerPutText.enqueue("putGetTextMessage", attributes);
        runnerPutText.run();
        Assertions.assertEquals((int)0, (int)runnerPutText.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPutText.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        runnerGet.run();
        List ffText = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)ffText.size());
        MockFlowFile successText = (MockFlowFile)ffText.get(0);
        successText.assertContentEquals("putGetTextMessage");
        PutJMS putJMSempty = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPutEmpty = TestRunners.newTestRunner((Processor)putJMSempty);
        runnerPutEmpty.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPutEmpty.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPutEmpty.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPutEmpty.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPutEmpty.setProperty(JmsProperties.MESSAGE_TYPE, "empty");
        HashMap<String, String> attributesEmpty = new HashMap<String, String>();
        attributesEmpty.put("filename", "file1.txt");
        runnerPutEmpty.enqueue("putGetEmptyMessage", attributesEmpty);
        runnerPutEmpty.run();
        Assertions.assertEquals((int)0, (int)runnerPutEmpty.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPutEmpty.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        runnerGet.clearTransferState();
        runnerGet.run();
        List ffEmpty = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)ffEmpty.size());
        MockFlowFile successEmpty = (MockFlowFile)ffEmpty.get(0);
        successEmpty.assertContentEquals("");
        PutJMS putJMSstream = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPutStream = TestRunners.newTestRunner((Processor)putJMSstream);
        runnerPutStream.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPutStream.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPutStream.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPutStream.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPutStream.setProperty(JmsProperties.MESSAGE_TYPE, "stream");
        HashMap<String, String> attributesStream = new HashMap<String, String>();
        attributesStream.put("filename", "file1.txt");
        runnerPutStream.enqueue("putGetStreamMessage", attributesStream);
        runnerGet.clearTransferState();
        runnerPutStream.run();
        Assertions.assertEquals((int)0, (int)runnerPutStream.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPutStream.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        runnerGet.run();
        List ffStream = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)ffStream.size());
        MockFlowFile successStream = (MockFlowFile)ffStream.get(0);
        successStream.assertContentEquals("putGetStreamMessage");
        PutJMS putJMSmap = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPutMap = TestRunners.newTestRunner((Processor)putJMSmap);
        runnerPutMap.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPutMap.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPutMap.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPutMap.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPutMap.setProperty(JmsProperties.MESSAGE_TYPE, "map");
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        attributesMap.put("filename", "file1.txt");
        runnerPutMap.enqueue("putGetMapMessage", attributesMap);
        runnerGet.clearTransferState();
        runnerPutMap.run();
        Assertions.assertEquals((int)0, (int)runnerPutMap.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPutMap.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        runnerGet.run();
        List ffMap = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)ffMap.size());
        MockFlowFile successMap = (MockFlowFile)ffMap.get(0);
        successMap.assertContentEquals("");
        PutJMS putJMSByte = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPutByte = TestRunners.newTestRunner((Processor)putJMSByte);
        runnerPutByte.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPutByte.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPutByte.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPutByte.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPutByte.setProperty(JmsProperties.MESSAGE_TYPE, "byte");
        HashMap<String, String> attributesByte = new HashMap<String, String>();
        attributesByte.put("filename", "file1.txt");
        runnerPutByte.enqueue("putGetTextMessage", attributesByte);
        runnerPutByte.run();
        Assertions.assertEquals((int)0, (int)runnerPutByte.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPutByte.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        runnerGet.clearTransferState();
        runnerGet.run();
        List ffByte = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)ffByte.size());
        MockFlowFile successByte = (MockFlowFile)ffByte.get(0);
        successByte.assertContentEquals("putGetTextMessage");
    }

    @Test
    public void testTTL() throws InterruptedException {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.MESSAGE_TTL, "3 s");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        runnerPut.enqueue("ttl10secNotExpired".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runnerGet = TestRunners.newTestRunner((Processor)getJmsQueue);
        runnerGet.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerGet.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerGet.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerGet.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runnerGet.setProperty(JmsProperties.TIMEOUT, "1 s");
        runnerGet.run();
        List flowFiles1 = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)flowFiles1.size());
        MockFlowFile successFlowFile1 = (MockFlowFile)flowFiles1.get(0);
        successFlowFile1.assertContentEquals("ttl10secNotExpired");
        runnerPut.clearTransferState();
        runnerGet.clearTransferState();
        runnerPut.setProperty(JmsProperties.MESSAGE_TTL, "1 s");
        runnerPut.enqueue("ttl1secExpired".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        Thread.sleep(2000L);
        runnerGet.run();
        List flowFiles2 = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)0, (int)flowFiles2.size());
    }

    @Test
    public void testFailureOnFileExceedsBufferSize() {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.MAX_BUFFER_SIZE, "10 B");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        runnerPut.enqueue("failureOnFileExceedsBufferSize".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
    }

    @Test
    public void testBadMessagePriorityValueFails() {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.MESSAGE_PRIORITY, "negative one");
        Assertions.assertThrows(NumberFormatException.class, () -> Assertions.assertEquals((int)4, (int)runnerPut.getProcessContext().getProperty(JmsProperties.MESSAGE_PRIORITY).asInteger()));
    }

    @Test
    public void testBadMessagePriorityRunSucceeds() {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.MESSAGE_PRIORITY, "negative one");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        runnerPut.enqueue("badMessagePriorityRunSucceeds".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
    }

    @Test
    public void testPutSendRoutesToFailure() throws JMSException, NoSuchFieldException, IllegalAccessException {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        ProcessContext context = runnerPut.getProcessContext();
        Queue wrappedMessageProducerQueue = (Queue)Mockito.spy(new LinkedBlockingQueue());
        this.injectFieldValue(PutJMS.class, putJMS, "producerQueue", wrappedMessageProducerQueue);
        final WrappedMessageProducer wrappedMessageProducer = (WrappedMessageProducer)Mockito.spy((Object)JmsFactory.createMessageProducer((ProcessContext)context, (boolean)true));
        final MessageProducer messageProducer = (MessageProducer)Mockito.spy((Object)wrappedMessageProducer.getProducer());
        ((Queue)Mockito.doAnswer((Answer)new Answer<WrappedMessageProducer>(){

            public WrappedMessageProducer answer(InvocationOnMock invocationOnMock) {
                return wrappedMessageProducer;
            }
        }).when((Object)wrappedMessageProducerQueue)).poll();
        Assertions.assertEquals((Object)wrappedMessageProducer, wrappedMessageProducerQueue.poll());
        ((WrappedMessageProducer)Mockito.doAnswer((Answer)new Answer<MessageProducer>(){

            public MessageProducer answer(InvocationOnMock invocationOnMock) {
                return messageProducer;
            }
        }).when((Object)wrappedMessageProducer)).getProducer();
        ((MessageProducer)Mockito.doThrow((Throwable[])new Throwable[]{new JMSException("force send to fail")}).when((Object)messageProducer)).send((Message)ArgumentMatchers.any(Message.class));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        runnerPut.enqueue("putSendRoutesToFailure".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        List flowFilesFail = runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE);
        Assertions.assertEquals((int)1, (int)flowFilesFail.size());
    }

    @Test
    public void testPutCommitRoutesToFailure() throws JMSException, NoSuchFieldException, IllegalAccessException {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        ProcessContext context = runnerPut.getProcessContext();
        Queue wrappedMessageProducerQueue = (Queue)Mockito.spy(new LinkedBlockingQueue());
        this.injectFieldValue(PutJMS.class, putJMS, "producerQueue", wrappedMessageProducerQueue);
        final WrappedMessageProducer wrappedMessageProducer = (WrappedMessageProducer)Mockito.spy((Object)JmsFactory.createMessageProducer((ProcessContext)context, (boolean)true));
        final MessageProducer messageProducer = (MessageProducer)Mockito.spy((Object)wrappedMessageProducer.getProducer());
        Connection connection = JmsFactory.createConnection((ProcessContext)context);
        final Session jmsSession = (Session)Mockito.spy((Object)JmsFactory.createSession((ProcessContext)context, (Connection)connection, (boolean)true));
        ((Queue)Mockito.doAnswer((Answer)new Answer<WrappedMessageProducer>(){

            public WrappedMessageProducer answer(InvocationOnMock invocationOnMock) {
                return wrappedMessageProducer;
            }
        }).when((Object)wrappedMessageProducerQueue)).poll();
        ((WrappedMessageProducer)Mockito.doAnswer((Answer)new Answer<MessageProducer>(){

            public MessageProducer answer(InvocationOnMock invocationOnMock) {
                return messageProducer;
            }
        }).when((Object)wrappedMessageProducer)).getProducer();
        ((WrappedMessageProducer)Mockito.doAnswer((Answer)new Answer<Session>(){

            public Session answer(InvocationOnMock invocationOnMock) {
                return jmsSession;
            }
        }).when((Object)wrappedMessageProducer)).getSession();
        ((Session)Mockito.doThrow((Throwable[])new Throwable[]{new JMSException("force commit to fail")}).when((Object)jmsSession)).commit();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("filename", "file1.txt");
        runnerPut.enqueue("putCommitRoutesToFailure".getBytes(), attributes);
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        List flowFilesFail = runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE);
        Assertions.assertEquals((int)1, (int)flowFilesFail.size());
    }

    @Test
    public void testPutProvenanceSendEventTransitUri() {
        PutJMS putJMS = (PutJMS)Mockito.spy((Object)new PutJMS());
        TestRunner runnerPut = TestRunners.newTestRunner((Processor)putJMS);
        runnerPut.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerPut.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerPut.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        runnerPut.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerPut.setProperty(JmsProperties.ATTRIBUTES_TO_JMS_PROPS, "true");
        runnerPut.enqueue("putGetMessage".getBytes());
        runnerPut.run();
        Assertions.assertEquals((int)0, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_FAILURE).size());
        Assertions.assertEquals((int)1, (int)runnerPut.getFlowFilesForRelationship(PutJMS.REL_SUCCESS).size());
        List putProvenanceEvents = runnerPut.getProvenanceEvents();
        Assertions.assertEquals((int)1, (int)putProvenanceEvents.size());
        Assertions.assertEquals((Object)"vm://localhost?broker.persistent=false", (Object)((ProvenanceEventRecord)putProvenanceEvents.get(0)).getTransitUri());
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runnerGet = TestRunners.newTestRunner((Processor)getJmsQueue);
        runnerGet.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runnerGet.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runnerGet.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing" + this.testQueueSuffix());
        runnerGet.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runnerGet.run();
        Assertions.assertEquals((int)1, (int)runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS).size());
        List flowFilesGet = runnerGet.getFlowFilesForRelationship(GetJMSQueue.REL_SUCCESS);
        Assertions.assertEquals((int)1, (int)flowFilesGet.size());
        MockFlowFile successFlowFile = (MockFlowFile)flowFilesGet.get(0);
        successFlowFile.assertContentEquals("putGetMessage");
    }
}

