/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ssh;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.connection.ConnectionImpl;
import net.schmizz.sshj.transport.Transport;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processors.standard.ssh.StandardSSHConfigProvider;
import org.apache.nifi.processors.standard.util.SFTPTransfer;
import org.apache.nifi.util.MockPropertyValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StandardSSHConfigProviderTest {
    private static final Config DEFAULT_CONFIG;
    private static final String FIRST_ALLOWED_CIPHER = "aes128-ctr";
    private static final String SECOND_ALLOWED_CIPHER = "aes256-cbc";
    private static final String ALLOWED_CIPHERS;
    private static final PropertyValue NULL_PROPERTY_VALUE;
    private static final int KEEP_ALIVE_ENABLED_INTERVAL = 5;
    private static final int KEEP_ALIVE_DISABLED_INTERVAL = 0;
    private static final String IDENTIFIER;
    @Mock
    private PropertyContext context;
    @Mock
    private ConnectionImpl connection;
    @Mock
    private Transport transport;
    private StandardSSHConfigProvider provider;

    @BeforeEach
    public void setProvider() {
        Mockito.when((Object)this.transport.getConfig()).thenReturn((Object)DEFAULT_CONFIG);
        Mockito.when((Object)this.connection.getTransport()).thenReturn((Object)this.transport);
        this.provider = new StandardSSHConfigProvider();
    }

    @Test
    public void testGetConfigDefaultValues() {
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT)).thenReturn((Object)new MockPropertyValue(Boolean.TRUE.toString()));
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.CIPHERS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.KEY_ALGORITHMS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Config config = this.provider.getConfig(IDENTIFIER, this.context);
        Assertions.assertNotNull((Object)config);
        KeepAliveProvider keepAliveProvider = config.getKeepAliveProvider();
        KeepAlive keepAlive = keepAliveProvider.provide(this.connection);
        Assertions.assertEquals((int)5, (int)keepAlive.getKeepAliveInterval());
        this.assertNamedEquals(DEFAULT_CONFIG.getCipherFactories(), config.getCipherFactories());
        this.assertNamedEquals(DEFAULT_CONFIG.getKeyAlgorithms(), config.getKeyAlgorithms());
        this.assertNamedEquals(DEFAULT_CONFIG.getKeyExchangeFactories(), config.getKeyExchangeFactories());
        this.assertNamedEquals(DEFAULT_CONFIG.getMACFactories(), config.getMACFactories());
    }

    @Test
    public void testGetConfigCiphersAllowedKeepAliveDisabled() {
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT)).thenReturn((Object)new MockPropertyValue(Boolean.FALSE.toString()));
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.CIPHERS_ALLOWED)).thenReturn((Object)new MockPropertyValue(ALLOWED_CIPHERS));
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.KEY_ALGORITHMS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.KEY_EXCHANGE_ALGORITHMS_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Mockito.when((Object)this.context.getProperty(SFTPTransfer.MESSAGE_AUTHENTICATION_CODES_ALLOWED)).thenReturn((Object)NULL_PROPERTY_VALUE);
        Config config = this.provider.getConfig(IDENTIFIER, this.context);
        Assertions.assertNotNull((Object)config);
        KeepAliveProvider keepAliveProvider = config.getKeepAliveProvider();
        KeepAlive keepAlive = keepAliveProvider.provide(this.connection);
        Assertions.assertEquals((int)0, (int)keepAlive.getKeepAliveInterval());
        Iterator cipherFactories = config.getCipherFactories().iterator();
        Assertions.assertTrue((boolean)cipherFactories.hasNext());
        Factory.Named firstCipherFactory = (Factory.Named)cipherFactories.next();
        Assertions.assertEquals((Object)FIRST_ALLOWED_CIPHER, (Object)firstCipherFactory.getName());
        Factory.Named secondCipherFactory = (Factory.Named)cipherFactories.next();
        Assertions.assertEquals((Object)SECOND_ALLOWED_CIPHER, (Object)secondCipherFactory.getName());
        Assertions.assertFalse((boolean)cipherFactories.hasNext());
        this.assertNamedEquals(DEFAULT_CONFIG.getKeyAlgorithms(), config.getKeyAlgorithms());
        this.assertNamedEquals(DEFAULT_CONFIG.getKeyExchangeFactories(), config.getKeyExchangeFactories());
        this.assertNamedEquals(DEFAULT_CONFIG.getMACFactories(), config.getMACFactories());
    }

    private <T> void assertNamedEquals(List<Factory.Named<T>> expected, List<Factory.Named<T>> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Iterator<Factory.Named<T>> expectedValues = expected.iterator();
        Iterator<Factory.Named<T>> actualValues = actual.iterator();
        while (expectedValues.hasNext()) {
            Factory.Named<T> expectedValue = expectedValues.next();
            Factory.Named<T> actualValue = actualValues.next();
            Assertions.assertEquals((Object)expectedValue.getName(), (Object)actualValue.getName());
        }
    }

    static {
        ALLOWED_CIPHERS = String.format("%s,%s", FIRST_ALLOWED_CIPHER, SECOND_ALLOWED_CIPHER);
        NULL_PROPERTY_VALUE = new MockPropertyValue(null);
        IDENTIFIER = UUID.randomUUID().toString();
        DefaultConfig prioritizedConfig = new DefaultConfig();
        prioritizedConfig.prioritizeSshRsaKeyAlgorithm();
        DEFAULT_CONFIG = prioritizedConfig;
    }
}

