/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp;

import java.io.File;
import org.apache.nifi.processors.standard.ftp.filesystem.VirtualPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVirtualPath {
    @Test
    public void testCreatePathStartingWithSlash() {
        String expectedPath = "/Directory1/Directory2".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/Directory2");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathStartingWithDoubleSlash() {
        String expectedPath = "/Directory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("//Directory1");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathEndingWithSlash() {
        String expectedPath = "/Directory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathEndingWithDoubleSlash() {
        String expectedPath = "/Directory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1//");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathNotStartingWithSlash() {
        String expectedPath = "/Directory1/Directory2".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("Directory1/Directory2");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatPathToRoot() {
        String expectedPath = File.separator;
        VirtualPath objectUnderTest = new VirtualPath("/");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathToRootWithDoubleSlash() {
        String expectedPath = File.separator;
        VirtualPath objectUnderTest = new VirtualPath("//");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathThatNeedsToBeResolved() {
        String expectedPath = "/Directory1/SubDirectory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("//Directory1/SubDirectory1/../SubDirectory1");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathWithWhitespace() {
        String expectedPath = "/Directory 1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory 1");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathWithBackslashes() {
        String expectedPath = "/Directory1/SubDirectory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("\\Directory1\\SubDirectory1");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testCreatePathWithSpecialCharacters() {
        String expectedPath = "/\u0171\u00e1\u00fa\u25a3\u2603/SubDirectory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/\u0171\u00e1\u00fa\u25a3\u2603/SubDirectory1");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testEmptyPathPointsToRoot() {
        String expectedPath = File.separator;
        VirtualPath objectUnderTest = new VirtualPath("");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testPathIsNormalized() {
        String expectedPath = "/Directory1/Directory2".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1///Directory2\\\\Directory3/Directory4/../..");
        String result = objectUnderTest.toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testGetFileNameForRoot() {
        String expectedPath = File.separator;
        VirtualPath objectUnderTest = new VirtualPath("/");
        Assertions.assertEquals((Object)expectedPath, (Object)objectUnderTest.getFileName());
    }

    @Test
    public void testGetFileNameForNonRoot() {
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/Directory2/file.txt");
        String result = objectUnderTest.getFileName();
        Assertions.assertEquals((Object)"file.txt", (Object)result);
    }

    @Test
    public void testGetParentForRoot() {
        VirtualPath objectUnderTest = new VirtualPath("/");
        Assertions.assertNull((Object)objectUnderTest.getParent());
    }

    @Test
    public void testGetParentForNonRoot() {
        String expectedPath = "/Directory1/Directory2".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/Directory2/file.txt");
        VirtualPath parent = objectUnderTest.getParent();
        Assertions.assertEquals((Object)expectedPath, (Object)parent.toString());
    }

    @Test
    public void testResolveToARelativePath() {
        String expectedPath = "/Directory1/Directory2/Directory3/Directory4".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/Directory2");
        String result = objectUnderTest.resolve("Directory3/Directory4").toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testResolveToParent() {
        String expectedPath = "/Directory1".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/Directory2");
        String result = objectUnderTest.resolve("..").toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testResolveToAnAbsolutePath() {
        String expectedPath = "/Directory3/Directory4".replace('/', File.separatorChar);
        VirtualPath objectUnderTest = new VirtualPath("/Directory1/Directory2");
        String result = objectUnderTest.resolve("/Directory3/Directory4").toString();
        Assertions.assertEquals((Object)expectedPath, (Object)result);
    }

    @Test
    public void testEquals() {
        VirtualPath path1 = new VirtualPath("/Directory1/Directory2");
        VirtualPath path2 = new VirtualPath("/Directory1/Directory2");
        Assertions.assertEquals((Object)path1, (Object)path2);
    }

    @Test
    public void testDoesNotEqual() {
        VirtualPath path1 = new VirtualPath("/Directory1/Directory2");
        VirtualPath path2 = new VirtualPath("/Directory1/Directory3");
        Assertions.assertNotEquals((Object)path1, (Object)path2);
    }
}

