/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.ListDatabaseTables;
import org.apache.nifi.serialization.record.MockRecordWriter;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.apache.nifi.util.file.FileUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class TestListDatabaseTables {
    TestRunner runner;
    ListDatabaseTables processor;
    private static final String DB_LOCATION = "target/db_ldt";

    @BeforeAll
    public static void setupBeforeClass() {
        System.setProperty("derby.stream.error.file", "target/derby.log");
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterAll
    public static void cleanUpAfterClass() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:target/db_ldt;shutdown=true");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            // empty catch block
        }
        File dbLocation = new File(DB_LOCATION);
        try {
            FileUtils.deleteFile((File)dbLocation, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.clearProperty("derby.stream.error.file");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.processor = new ListDatabaseTables();
        DBCPServiceSimpleImpl dbcp = new DBCPServiceSimpleImpl();
        HashMap dbcpProperties = new HashMap();
        this.runner = TestRunners.newTestRunner(ListDatabaseTables.class);
        this.runner.addControllerService("dbcp", (ControllerService)dbcp, dbcpProperties);
        this.runner.enableControllerService((ControllerService)dbcp);
        this.runner.setProperty(ListDatabaseTables.DBCP_SERVICE, "dbcp");
    }

    @Test
    public void testListTablesNoCount() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_TABLE1");
            stmt.execute("drop table TEST_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_TABLE1 (id integer not null, val1 integer, val2 integer, constraint my_pk1 primary key (id))");
        stmt.execute("create table TEST_TABLE2 (id integer not null, val1 integer, val2 integer, constraint my_pk2 primary key (id))");
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 2);
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 0);
    }

    @Test
    public void testListTablesWithCount() throws Exception {
        this.runner.setProperty(ListDatabaseTables.INCLUDE_COUNT, "true");
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_TABLE1");
            stmt.execute("drop table TEST_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_TABLE1 (id integer not null, val1 integer, val2 integer, constraint my_pk1 primary key (id))");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (1, 1, 1)");
        stmt.execute("create table TEST_TABLE2 (id integer not null, val1 integer, val2 integer, constraint my_pk2 primary key (id))");
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 2);
        List results = this.runner.getFlowFilesForRelationship(ListDatabaseTables.REL_SUCCESS);
        Assertions.assertEquals((Object)"2", (Object)((MockFlowFile)results.get(0)).getAttribute("db.table.count"));
        Assertions.assertEquals((Object)"0", (Object)((MockFlowFile)results.get(1)).getAttribute("db.table.count"));
    }

    @Test
    public void testListTablesWithCountAsRecord() throws Exception {
        this.runner.setProperty(ListDatabaseTables.INCLUDE_COUNT, "true");
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_TABLE1");
            stmt.execute("drop table TEST_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_TABLE1 (id integer not null, val1 integer, val2 integer, constraint my_pk1 primary key (id))");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (1, 1, 1)");
        stmt.execute("create table TEST_TABLE2 (id integer not null, val1 integer, val2 integer, constraint my_pk2 primary key (id))");
        MockRecordWriter recordWriter = new MockRecordWriter(null, false);
        this.runner.addControllerService("record-writer", (ControllerService)recordWriter);
        this.runner.setProperty(ListDatabaseTables.RECORD_WRITER, "record-writer");
        this.runner.enableControllerService((ControllerService)recordWriter);
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(ListDatabaseTables.REL_SUCCESS).get(0);
        flowFile.assertContentEquals("TEST_TABLE1,,APP,APP.TEST_TABLE1,TABLE,,2\nTEST_TABLE2,,APP,APP.TEST_TABLE2,TABLE,,0\n");
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testListTablesAfterRefresh() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_TABLE1");
            stmt.execute("drop table TEST_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_TABLE1 (id integer not null, val1 integer, val2 integer, constraint my_pk1 primary key (id))");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (1, 1, 1)");
        stmt.execute("create table TEST_TABLE2 (id integer not null, val1 integer, val2 integer, constraint my_pk2 primary key (id))");
        stmt.close();
        this.runner.setProperty(ListDatabaseTables.INCLUDE_COUNT, "true");
        this.runner.setProperty(ListDatabaseTables.REFRESH_INTERVAL, "100 millis");
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 2);
        List results = this.runner.getFlowFilesForRelationship(ListDatabaseTables.REL_SUCCESS);
        Assertions.assertEquals((Object)"2", (Object)((MockFlowFile)results.get(0)).getAttribute("db.table.count"));
        Assertions.assertEquals((Object)"0", (Object)((MockFlowFile)results.get(1)).getAttribute("db.table.count"));
        this.runner.clearTransferState();
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 0);
        Thread.sleep(200L);
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 2);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testListTablesMultipleRefresh() throws Exception {
        Connection con = ((DBCPService)this.runner.getControllerService("dbcp")).getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("drop table TEST_TABLE1");
            stmt.execute("drop table TEST_TABLE2");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.execute("create table TEST_TABLE1 (id integer not null, val1 integer, val2 integer, constraint my_pk1 primary key (id))");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (0, NULL, 1)");
        stmt.execute("insert into TEST_TABLE1 (id, val1, val2) VALUES (1, 1, 1)");
        this.runner.setProperty(ListDatabaseTables.INCLUDE_COUNT, "true");
        this.runner.setProperty(ListDatabaseTables.REFRESH_INTERVAL, "200 millis");
        this.runner.run();
        long startTimer = System.currentTimeMillis();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 1);
        List results = this.runner.getFlowFilesForRelationship(ListDatabaseTables.REL_SUCCESS);
        Assertions.assertEquals((Object)"2", (Object)((MockFlowFile)results.get(0)).getAttribute("db.table.count"));
        this.runner.clearTransferState();
        stmt.execute("create table TEST_TABLE2 (id integer not null, val1 integer, val2 integer, constraint my_pk2 primary key (id))");
        stmt.close();
        this.runner.run();
        long endTimer = System.currentTimeMillis();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, endTimer - startTimer > 200L ? 2 : 1);
        results = this.runner.getFlowFilesForRelationship(ListDatabaseTables.REL_SUCCESS);
        Assertions.assertEquals((Object)(endTimer - startTimer > 200L ? "2" : "0"), (Object)((MockFlowFile)results.get(0)).getAttribute("db.table.count"));
        this.runner.clearTransferState();
        Thread.sleep(500L);
        this.runner.run();
        this.runner.assertTransferCount(ListDatabaseTables.REL_SUCCESS, 2);
    }

    private class DBCPServiceSimpleImpl
    extends AbstractControllerService
    implements DBCPService {
        private DBCPServiceSimpleImpl() {
        }

        public String getIdentifier() {
            return "dbcp";
        }

        public Connection getConnection() throws ProcessException {
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                return DriverManager.getConnection("jdbc:derby:target/db_ldt;create=true");
            }
            catch (Exception e) {
                throw new ProcessException("getConnection failed: " + e);
            }
        }
    }
}

