/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.standard.GetJMSQueue;
import org.apache.nifi.processors.standard.PutJMS;
import org.apache.nifi.processors.standard.util.JmsFactory;
import org.apache.nifi.processors.standard.util.JmsProperties;
import org.apache.nifi.processors.standard.util.WrappedMessageProducer;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGetJMSQueue {
    @Test
    public void testSendTextToQueue() throws Exception {
        PutJMS putJms = new PutJMS();
        TestRunner putRunner = TestRunners.newTestRunner((Processor)putJms);
        putRunner.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        putRunner.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        putRunner.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        putRunner.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing");
        putRunner.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        WrappedMessageProducer wrappedProducer = JmsFactory.createMessageProducer((ProcessContext)putRunner.getProcessContext(), (boolean)true);
        Session jmsSession = wrappedProducer.getSession();
        MessageProducer producer = wrappedProducer.getProducer();
        TextMessage message = jmsSession.createTextMessage("Hello World");
        producer.send((Message)message);
        jmsSession.commit();
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runner = TestRunners.newTestRunner((Processor)getJmsQueue);
        runner.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runner.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runner.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing");
        runner.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runner.run();
        List flowFiles = runner.getFlowFilesForRelationship(new Relationship.Builder().name("success").build());
        Assertions.assertEquals((int)1, (int)flowFiles.size());
        MockFlowFile successFlowFile = (MockFlowFile)flowFiles.get(0);
        successFlowFile.assertContentEquals("Hello World");
        successFlowFile.assertAttributeEquals("jms.JMSDestination", "queue.testing");
        producer.close();
        jmsSession.close();
    }

    @Test
    public void testSendBytesToQueue() throws Exception {
        PutJMS putJms = new PutJMS();
        TestRunner putRunner = TestRunners.newTestRunner((Processor)putJms);
        putRunner.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        putRunner.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        putRunner.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        putRunner.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing");
        putRunner.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        WrappedMessageProducer wrappedProducer = JmsFactory.createMessageProducer((ProcessContext)putRunner.getProcessContext(), (boolean)true);
        Session jmsSession = wrappedProducer.getSession();
        MessageProducer producer = wrappedProducer.getProducer();
        BytesMessage message = jmsSession.createBytesMessage();
        message.writeBytes("Hello Bytes".getBytes());
        producer.send((Message)message);
        jmsSession.commit();
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runner = TestRunners.newTestRunner((Processor)getJmsQueue);
        runner.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runner.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runner.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing");
        runner.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runner.run();
        List flowFiles = runner.getFlowFilesForRelationship(new Relationship.Builder().name("success").build());
        Assertions.assertEquals((int)1, (int)flowFiles.size());
        MockFlowFile successFlowFile = (MockFlowFile)flowFiles.get(0);
        successFlowFile.assertContentEquals("Hello Bytes");
        successFlowFile.assertAttributeEquals("jms.JMSDestination", "queue.testing");
        producer.close();
        jmsSession.close();
    }

    @Test
    public void testSendStreamToQueue() throws Exception {
        PutJMS putJms = new PutJMS();
        TestRunner putRunner = TestRunners.newTestRunner((Processor)putJms);
        putRunner.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        putRunner.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        putRunner.setProperty(JmsProperties.DESTINATION_TYPE, "Queue");
        putRunner.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing");
        putRunner.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        WrappedMessageProducer wrappedProducer = JmsFactory.createMessageProducer((ProcessContext)putRunner.getProcessContext(), (boolean)true);
        Session jmsSession = wrappedProducer.getSession();
        MessageProducer producer = wrappedProducer.getProducer();
        StreamMessage message = jmsSession.createStreamMessage();
        message.writeBytes("Hello Stream".getBytes());
        producer.send((Message)message);
        jmsSession.commit();
        GetJMSQueue getJmsQueue = new GetJMSQueue();
        TestRunner runner = TestRunners.newTestRunner((Processor)getJmsQueue);
        runner.setProperty(JmsProperties.JMS_PROVIDER, "ActiveMQ");
        runner.setProperty(JmsProperties.URL, "vm://localhost?broker.persistent=false");
        runner.setProperty(JmsProperties.DESTINATION_NAME, "queue.testing");
        runner.setProperty(JmsProperties.ACKNOWLEDGEMENT_MODE, "Auto Acknowledge");
        runner.run();
        List flowFiles = runner.getFlowFilesForRelationship(new Relationship.Builder().name("success").build());
        Assertions.assertEquals((int)1, (int)flowFiles.size());
        MockFlowFile successFlowFile = (MockFlowFile)flowFiles.get(0);
        successFlowFile.assertContentEquals("Hello Stream");
        successFlowFile.assertAttributeEquals("jms.JMSDestination", "queue.testing");
        producer.close();
        jmsSession.close();
    }
}

