/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.prioritizer.FirstInFirstOutPrioritizer;
import org.apache.nifi.processors.standard.EnforceOrder;
import org.apache.nifi.state.MockStateManager;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEnforceOrder {
    @Test
    public void testDefaultPropertyValidation() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.assertNotValid();
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.assertValid();
    }

    @Test
    public void testCustomPropertyValidation() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.assertValid();
        runner.setProperty(EnforceOrder.WAIT_TIMEOUT, "30 sec");
        runner.setProperty(EnforceOrder.INACTIVE_TIMEOUT, "29 sec");
        runner.assertNotValid();
        runner.setProperty(EnforceOrder.INACTIVE_TIMEOUT, "30 sec");
        runner.assertNotValid();
        runner.setProperty(EnforceOrder.INACTIVE_TIMEOUT, "31 sec");
        runner.assertValid();
    }

    @Test
    public void testSort() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.assertValid();
        Ordered.enqueue(runner, "b", 0);
        Ordered.enqueue(runner, "a", 1);
        Ordered.enqueue(runner, "a", 0);
        runner.run();
        runner.assertAllFlowFilesTransferred(EnforceOrder.REL_SUCCESS, 3);
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        succeeded.sort(new FirstInFirstOutPrioritizer());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.0");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.1");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.0");
    }

    @Test
    public void testDuplicatedOrder() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.assertValid();
        Ordered.enqueue(runner, "b", 1);
        Ordered.enqueue(runner, "a", 2);
        Ordered.enqueue(runner, "a", 1);
        Ordered.enqueue(runner, "a", 2);
        Ordered.enqueue(runner, "a", 3);
        runner.run();
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        Assertions.assertEquals((int)4, (int)succeeded.size());
        succeeded.sort(new FirstInFirstOutPrioritizer());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.1");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.2");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("a.3");
        ((MockFlowFile)succeeded.get(3)).assertContentEquals("b.1");
        List skipped = runner.getFlowFilesForRelationship(EnforceOrder.REL_SKIPPED);
        Assertions.assertEquals((int)1, (int)skipped.size());
        ((MockFlowFile)skipped.get(0)).assertContentEquals("a.2");
        ((MockFlowFile)skipped.get(0)).assertAttributeEquals("EnforceOrder.expectedOrder", "3");
    }

    @Test
    public void testNoGroupIdentifier() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.assertValid();
        Ordered.enqueue(runner, "b", 1);
        Ordered.enqueue(runner, "a", 2);
        runner.enqueue("no group id", Ordered.i(1).map());
        Ordered.enqueue(runner, "a", 1);
        runner.run();
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)succeeded.size());
        succeeded.sort(new FirstInFirstOutPrioritizer());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.1");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.2");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.1");
        List failed = runner.getFlowFilesForRelationship(EnforceOrder.REL_FAILURE);
        Assertions.assertEquals((int)1, (int)failed.size());
        ((MockFlowFile)failed.get(0)).assertAttributeExists("EnforceOrder.detail");
    }

    @Test
    public void testIllegalOrderValue() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.assertValid();
        Ordered.enqueue(runner, "b", 1);
        Ordered.enqueue(runner, "a", 2);
        runner.enqueue("illegal order", Ordered.i("a", 1).put("index", "non-integer").map());
        Ordered.enqueue(runner, "a", 1);
        runner.run();
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)succeeded.size());
        succeeded.sort(new FirstInFirstOutPrioritizer());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.1");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.2");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.1");
        List failed = runner.getFlowFilesForRelationship(EnforceOrder.REL_FAILURE);
        Assertions.assertEquals((int)1, (int)failed.size());
        ((MockFlowFile)failed.get(0)).assertAttributeExists("EnforceOrder.detail");
        ((MockFlowFile)failed.get(0)).assertContentEquals("illegal order");
    }

    @Test
    public void testInitialOrderValue() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "${index.start}");
        runner.setProperty(EnforceOrder.MAX_ORDER, "${index.max}");
        runner.assertValid();
        runner.enqueue("b.0", Ordered.i("b", 0).put("index.start", "0").put("index.max", "99").map());
        runner.enqueue("a.100", Ordered.i("a", 100).put("index.start", "100").put("index.max", "103").map());
        runner.enqueue("a.101", Ordered.i("a", 101).put("index.start", "100").put("index.max", "103").map());
        runner.enqueue("illegal initial order", Ordered.i("c", 1).put("index.start", "non-integer").map());
        runner.enqueue("without initial order", Ordered.i("d", 1).map());
        Ordered.enqueue(runner, "b", 1);
        runner.run();
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        Assertions.assertEquals((int)4, (int)succeeded.size());
        succeeded.sort(new FirstInFirstOutPrioritizer());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.100");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.101");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.0");
        ((MockFlowFile)succeeded.get(3)).assertContentEquals("b.1");
        List failed = runner.getFlowFilesForRelationship(EnforceOrder.REL_FAILURE);
        Assertions.assertEquals((int)2, (int)failed.size());
        ((MockFlowFile)failed.get(0)).assertAttributeExists("EnforceOrder.detail");
        ((MockFlowFile)failed.get(0)).assertContentEquals("illegal initial order");
        ((MockFlowFile)failed.get(1)).assertAttributeExists("EnforceOrder.detail");
        ((MockFlowFile)failed.get(1)).assertContentEquals("without initial order");
        MockStateManager stateManager = runner.getStateManager();
        stateManager.assertStateEquals("a.target", "102", Scope.LOCAL);
        stateManager.assertStateEquals("a.max", "103", Scope.LOCAL);
        stateManager.assertStateEquals("b.target", "2", Scope.LOCAL);
        stateManager.assertStateEquals("b.max", "99", Scope.LOCAL);
        runner.clearTransferState();
    }

    @Test
    public void testMaxOrder() {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${fragment.identifier}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.setProperty(EnforceOrder.MAX_ORDER, "${fragment.count}");
        runner.assertValid();
        runner.enqueue("b.1", Ordered.i(1).put("fragment.identifier", "b").put("fragment.count", "3").map());
        runner.enqueue("a.2", Ordered.i(2).put("fragment.identifier", "a").put("fragment.count", "2").map());
        runner.enqueue("without max order", Ordered.i(1).put("fragment.identifier", "c").map());
        runner.enqueue("illegal max order", Ordered.i(1).put("fragment.identifier", "d").put("fragment.count", "X").map());
        runner.enqueue("a.1", Ordered.i(1).put("fragment.identifier", "a").put("fragment.count", "2").map());
        runner.enqueue("a.3", Ordered.i(3).put("fragment.identifier", "a").put("fragment.count", "2").map());
        runner.run();
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        succeeded.sort(new FirstInFirstOutPrioritizer());
        Assertions.assertEquals((int)3, (int)succeeded.size());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.1");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.2");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.1");
        List failed = runner.getFlowFilesForRelationship(EnforceOrder.REL_FAILURE);
        Assertions.assertEquals((int)3, (int)failed.size());
        ((MockFlowFile)failed.get(0)).assertContentEquals("without max order");
        ((MockFlowFile)failed.get(1)).assertContentEquals("illegal max order");
        ((MockFlowFile)failed.get(2)).assertContentEquals("a.3");
        MockStateManager stateManager = runner.getStateManager();
        stateManager.assertStateEquals("a.target", "2", Scope.LOCAL);
        stateManager.assertStateEquals("a.max", "2", Scope.LOCAL);
    }

    @Test
    public void testWaitOvertakeSkip() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.setProperty(EnforceOrder.MAX_ORDER, "10");
        runner.assertValid();
        Ordered.enqueue(runner, "b", 1);
        Ordered.enqueue(runner, "a", 2);
        Ordered.enqueue(runner, "a", 1);
        Ordered.enqueue(runner, "a", 5);
        Ordered.enqueue(runner, "b", 3);
        Ordered.enqueue(runner, "c", 9);
        Ordered.enqueue(runner, "d", 10);
        runner.run();
        List succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        Assertions.assertEquals((int)3, (int)succeeded.size());
        FirstInFirstOutPrioritizer fifo = new FirstInFirstOutPrioritizer();
        succeeded.sort(fifo);
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.1");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("a.2");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.1");
        List waiting = runner.getFlowFilesForRelationship(EnforceOrder.REL_WAIT);
        Assertions.assertEquals((int)4, (int)waiting.size());
        ((MockFlowFile)waiting.get(0)).assertContentEquals("a.5");
        ((MockFlowFile)waiting.get(1)).assertContentEquals("b.3");
        ((MockFlowFile)waiting.get(2)).assertContentEquals("c.9");
        ((MockFlowFile)waiting.get(3)).assertContentEquals("d.10");
        ((MockFlowFile)waiting.get(0)).assertAttributeExists("EnforceOrder.startedAt");
        ((MockFlowFile)waiting.get(1)).assertAttributeExists("EnforceOrder.startedAt");
        ((MockFlowFile)waiting.get(2)).assertAttributeExists("EnforceOrder.startedAt");
        ((MockFlowFile)waiting.get(3)).assertAttributeExists("EnforceOrder.startedAt");
        MockStateManager stateManager = runner.getStateManager();
        stateManager.assertStateEquals("a.target", "3", Scope.LOCAL);
        stateManager.assertStateEquals("b.target", "2", Scope.LOCAL);
        stateManager.assertStateEquals("c.target", "1", Scope.LOCAL);
        stateManager.assertStateEquals("d.target", "1", Scope.LOCAL);
        stateManager.assertStateSet("a.updatedAt", Scope.LOCAL);
        stateManager.assertStateSet("b.updatedAt", Scope.LOCAL);
        stateManager.assertStateSet("c.updatedAt", Scope.LOCAL);
        stateManager.assertStateSet("d.updatedAt", Scope.LOCAL);
        runner.clearTransferState();
        waiting.forEach(xva$0 -> runner.enqueue(new FlowFile[]{xva$0}));
        runner.run();
        runner.assertAllFlowFilesTransferred(EnforceOrder.REL_WAIT, 4);
        waiting = runner.getFlowFilesForRelationship(EnforceOrder.REL_WAIT);
        runner.clearTransferState();
        runner.setProperty(EnforceOrder.WAIT_TIMEOUT, "10 ms");
        Thread.sleep(20L);
        waiting.forEach(xva$0 -> runner.enqueue(new FlowFile[]{xva$0}));
        Ordered.enqueue(runner, "b", 2);
        Ordered.enqueue(runner, "a", 6);
        runner.run();
        succeeded = runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS);
        succeeded.sort(fifo);
        Assertions.assertEquals((int)3, (int)succeeded.size());
        ((MockFlowFile)succeeded.get(0)).assertContentEquals("a.6");
        ((MockFlowFile)succeeded.get(1)).assertContentEquals("b.2");
        ((MockFlowFile)succeeded.get(2)).assertContentEquals("b.3");
        List overtook = runner.getFlowFilesForRelationship(EnforceOrder.REL_OVERTOOK);
        Assertions.assertEquals((int)3, (int)overtook.size());
        ((MockFlowFile)overtook.get(0)).assertContentEquals("a.5");
        ((MockFlowFile)overtook.get(0)).assertAttributeEquals("EnforceOrder.expectedOrder", "3");
        ((MockFlowFile)overtook.get(1)).assertContentEquals("c.9");
        ((MockFlowFile)overtook.get(1)).assertAttributeEquals("EnforceOrder.expectedOrder", "1");
        ((MockFlowFile)overtook.get(2)).assertContentEquals("d.10");
        ((MockFlowFile)overtook.get(2)).assertAttributeEquals("EnforceOrder.expectedOrder", "1");
        stateManager.assertStateEquals("a.target", "7", Scope.LOCAL);
        stateManager.assertStateEquals("b.target", "4", Scope.LOCAL);
        stateManager.assertStateEquals("c.target", "10", Scope.LOCAL);
        stateManager.assertStateEquals("d.target", "10", Scope.LOCAL);
        runner.clearTransferState();
        Ordered.enqueue(runner, "a", 3);
        Ordered.enqueue(runner, "a", 4);
        runner.run();
        runner.assertAllFlowFilesTransferred(EnforceOrder.REL_SKIPPED, 2);
        List skipped = runner.getFlowFilesForRelationship(EnforceOrder.REL_SKIPPED);
        ((MockFlowFile)skipped.get(0)).assertContentEquals("a.3");
        ((MockFlowFile)skipped.get(0)).assertAttributeExists("EnforceOrder.detail");
        ((MockFlowFile)skipped.get(1)).assertContentEquals("a.4");
        ((MockFlowFile)skipped.get(1)).assertAttributeExists("EnforceOrder.detail");
    }

    @Test
    public void testCleanInactiveGroups() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.assertValid();
        Ordered.enqueue(runner, "b", 1);
        Ordered.enqueue(runner, "a", 2);
        Ordered.enqueue(runner, "c", 1);
        Ordered.enqueue(runner, "a", 1);
        runner.run();
        runner.assertAllFlowFilesTransferred(EnforceOrder.REL_SUCCESS, 4);
        runner.clearTransferState();
        runner.setProperty(EnforceOrder.WAIT_TIMEOUT, "5 ms");
        runner.setProperty(EnforceOrder.INACTIVE_TIMEOUT, "10 ms");
        Thread.sleep(15L);
        Ordered.enqueue(runner, "a", 3);
        Ordered.enqueue(runner, "c", 2);
        runner.run();
        MockStateManager stateManager = runner.getStateManager();
        stateManager.assertStateEquals("a.target", "4", Scope.LOCAL);
        stateManager.assertStateNotSet("b.target", Scope.LOCAL);
        stateManager.assertStateEquals("c.target", "3", Scope.LOCAL);
        stateManager.assertStateSet("a.updatedAt", Scope.LOCAL);
        stateManager.assertStateNotSet("b.updatedAt", Scope.LOCAL);
        stateManager.assertStateSet("c.updatedAt", Scope.LOCAL);
        runner.clearTransferState();
        Ordered.enqueue(runner, "b", 2);
        runner.run();
        stateManager.assertStateEquals("b.target", "1", Scope.LOCAL);
        stateManager.assertStateSet("b.updatedAt", Scope.LOCAL);
        runner.assertAllFlowFilesTransferred(EnforceOrder.REL_WAIT, 1);
        List waiting = runner.getFlowFilesForRelationship(EnforceOrder.REL_WAIT);
        ((MockFlowFile)waiting.get(0)).assertContentEquals("b.2");
    }

    @Test
    public void testClearOldProperties() throws Exception {
        TestRunner runner = TestRunners.newTestRunner(EnforceOrder.class);
        runner.setProperty(EnforceOrder.GROUP_IDENTIFIER, "${group}");
        runner.setProperty(EnforceOrder.ORDER_ATTRIBUTE, "index");
        runner.setProperty(EnforceOrder.INITIAL_ORDER, "1");
        runner.assertValid();
        Ordered.enqueue(runner, "a", 2);
        Ordered.enqueue(runner, "b", 1);
        runner.run();
        runner.assertTransferCount(EnforceOrder.REL_WAIT, 1);
        MockFlowFile a2 = (MockFlowFile)runner.getFlowFilesForRelationship(EnforceOrder.REL_WAIT).get(0);
        a2.assertAttributeEquals("EnforceOrder.result", "wait");
        a2.assertAttributeExists("EnforceOrder.startedAt");
        a2.assertAttributeNotExists("EnforceOrder.detail");
        a2.assertAttributeEquals("EnforceOrder.expectedOrder", "1");
        a2.assertContentEquals("a.2");
        runner.assertTransferCount(EnforceOrder.REL_SUCCESS, 1);
        MockFlowFile b1 = (MockFlowFile)runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS).get(0);
        b1.assertAttributeEquals("EnforceOrder.result", "success");
        b1.assertAttributeExists("EnforceOrder.startedAt");
        b1.assertAttributeNotExists("EnforceOrder.detail");
        b1.assertAttributeNotExists("EnforceOrder.expectedOrder");
        b1.assertContentEquals("b.1");
        runner.clearTransferState();
        Ordered.enqueue(runner, "a", 1);
        runner.enqueue(new FlowFile[]{a2});
        runner.run();
        runner.assertAllFlowFilesTransferred(EnforceOrder.REL_SUCCESS, 2);
        MockFlowFile a1 = (MockFlowFile)runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS).get(0);
        a1.assertAttributeEquals("EnforceOrder.result", "success");
        a1.assertAttributeExists("EnforceOrder.startedAt");
        a1.assertAttributeNotExists("EnforceOrder.detail");
        a1.assertAttributeNotExists("EnforceOrder.expectedOrder");
        a1.assertContentEquals("a.1");
        a2 = (MockFlowFile)runner.getFlowFilesForRelationship(EnforceOrder.REL_SUCCESS).get(1);
        a2.assertAttributeEquals("EnforceOrder.result", "success");
        a2.assertAttributeExists("EnforceOrder.startedAt");
        a2.assertAttributeNotExists("EnforceOrder.detail");
        a2.assertAttributeNotExists("EnforceOrder.expectedOrder");
        a2.assertContentEquals("a.2");
    }

    private static class Ordered {
        private final Map<String, String> map = new HashMap<String, String>();

        private Ordered(int index) {
            this.map.put("index", String.valueOf(index));
        }

        private static Ordered i(int index) {
            return new Ordered(index);
        }

        private static Ordered i(String group, int index) {
            return new Ordered(index).put("group", group);
        }

        private Ordered put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        private Map<String, String> map() {
            return this.map;
        }

        private static MockFlowFile enqueue(TestRunner runner, String group, int index) {
            return runner.enqueue(group + "." + index, Ordered.i(group, index).map());
        }
    }
}

