/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processors.standard.CountText;
import org.apache.nifi.util.MockComponentLog;
import org.apache.nifi.util.MockFlowFile;
import org.apache.nifi.util.TestRunner;
import org.apache.nifi.util.TestRunners;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CountTextTest {
    private static final String TLC = "text.line.count";
    private static final String TLNEC = "text.line.nonempty.count";
    private static final String TWC = "text.word.count";
    private static final String TCC = "text.character.count";
    private TestRunner runner;

    @BeforeEach
    void setupRunner() {
        this.runner = TestRunners.newTestRunner(CountText.class);
    }

    @Test
    void testShouldCountAllMetrics() throws IOException {
        this.runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "true");
        Path inputPath = Paths.get("src/test/resources/TestCountText/jabberwocky.txt", new String[0]);
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put(TLC, "34");
        expectedValues.put(TLNEC, "28");
        expectedValues.put(TWC, "166");
        expectedValues.put(TCC, "900");
        this.runner.enqueue(Files.readAllBytes(inputPath));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
        for (Map.Entry entry : expectedValues.entrySet()) {
            String attribute = (String)entry.getKey();
            String expectedValue = (String)entry.getValue();
            flowFile.assertAttributeEquals(attribute, expectedValue);
        }
    }

    @Test
    void testShouldCountEachMetric() throws IOException {
        Path inputPath = Paths.get("src/test/resources/TestCountText/jabberwocky.txt", new String[0]);
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put(TLC, "34");
        expectedValues.put(TLNEC, "28");
        expectedValues.put(TWC, "166");
        expectedValues.put(TCC, "900");
        Map<PropertyDescriptor, String> linesOnly = Collections.singletonMap(CountText.TEXT_LINE_COUNT_PD, "true");
        Map<PropertyDescriptor, String> linesNonEmptyOnly = Collections.singletonMap(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "true");
        Map<PropertyDescriptor, String> wordsOnly = Collections.singletonMap(CountText.TEXT_WORD_COUNT_PD, "true");
        Map<PropertyDescriptor, String> charactersOnly = Collections.singletonMap(CountText.TEXT_CHARACTER_COUNT_PD, "true");
        List<Map> scenarios = Arrays.asList(linesOnly, linesNonEmptyOnly, wordsOnly, charactersOnly);
        for (Map map : scenarios) {
            this.runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "false");
            this.runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "false");
            this.runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "false");
            this.runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "false");
            for (Map.Entry entry : map.entrySet()) {
                this.runner.setProperty((PropertyDescriptor)entry.getKey(), (String)entry.getValue());
            }
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.enqueue(Files.readAllBytes(inputPath));
            this.runner.run();
            this.runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
            for (Map.Entry entry : expectedValues.entrySet()) {
                String attribute = (String)entry.getKey();
                String expectedValue = (String)entry.getValue();
                if (!flowFile.getAttributes().containsKey(attribute)) continue;
                flowFile.assertAttributeEquals(attribute, expectedValue);
            }
        }
    }

    @Test
    void testShouldCountWordsSplitOnSymbol() throws IOException {
        Path inputPath = Paths.get("src/test/resources/TestCountText/jabberwocky.txt", new String[0]);
        String EXPECTED_WORD_COUNT = "167";
        this.runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "false");
        this.runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "false");
        this.runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "false");
        this.runner.setProperty(CountText.SPLIT_WORDS_ON_SYMBOLS_PD, "true");
        this.runner.clearProvenanceEvents();
        this.runner.clearTransferState();
        this.runner.enqueue(Files.readAllBytes(inputPath));
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(TWC, "167");
    }

    @Test
    void testShouldCountIndependentlyPerFlowFile() throws IOException {
        Path inputPath = Paths.get("src/test/resources/TestCountText/jabberwocky.txt", new String[0]);
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put(TLC, "34");
        expectedValues.put(TLNEC, "28");
        expectedValues.put(TWC, "166");
        expectedValues.put(TCC, "900");
        this.runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "true");
        for (int i = 0; i < 2; ++i) {
            this.runner.clearProvenanceEvents();
            this.runner.clearTransferState();
            this.runner.enqueue(Files.readAllBytes(inputPath));
            this.runner.run();
            this.runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
            for (Map.Entry entry : expectedValues.entrySet()) {
                String attribute = (String)entry.getKey();
                String expectedValue = (String)entry.getValue();
                flowFile.assertAttributeEquals(attribute, expectedValue);
            }
        }
    }

    @Test
    void testShouldTrackSessionCountersAcrossMultipleFlowfiles() throws IOException, NoSuchFieldException, IllegalAccessException {
        Path inputPath = Paths.get("src/test/resources/TestCountText/jabberwocky.txt", new String[0]);
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        expectedValues.put(TLC, "34");
        expectedValues.put(TLNEC, "28");
        expectedValues.put(TWC, "166");
        expectedValues.put(TCC, "900");
        this.runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "true");
        int n = 2;
        for (int i = 0; i < 2; ++i) {
            this.runner.clearTransferState();
            this.runner.enqueue(Files.readAllBytes(inputPath));
            this.runner.run();
            this.runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
            MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
            for (Map.Entry entry : expectedValues.entrySet()) {
                String attribute = (String)entry.getKey();
                String expectedValue = (String)entry.getValue();
                flowFile.assertAttributeEquals(attribute, expectedValue);
            }
        }
        Assertions.assertEquals((long)(Long.valueOf((String)expectedValues.get(TLC)) * 2L), (Long)this.runner.getCounterValue("Lines Counted"));
        Assertions.assertEquals((long)(Long.valueOf((String)expectedValues.get(TLNEC)) * 2L), (Long)this.runner.getCounterValue("Lines (non-empty) Counted"));
        Assertions.assertEquals((long)(Long.valueOf((String)expectedValues.get(TWC)) * 2L), (Long)this.runner.getCounterValue("Words Counted"));
        Assertions.assertEquals((long)(Long.valueOf((String)expectedValues.get(TCC)) * 2L), (Long)this.runner.getCounterValue("Characters Counted"));
    }

    @Test
    void testShouldHandleInternalError() {
        CountText ct = new CountText(){

            int countWordsInLine(String line, boolean splitWordsOnSymbols) throws IOException {
                throw new IOException("Expected exception");
            }
        };
        TestRunner runner = TestRunners.newTestRunner((Processor)ct);
        String INPUT_TEXT = "This flowfile should throw an error";
        runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "true");
        runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "true");
        runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "true");
        runner.setProperty(CountText.CHARACTER_ENCODING_PD, StandardCharsets.US_ASCII.displayName());
        runner.enqueue("This flowfile should throw an error".getBytes());
        runner.run(1, true, true);
        runner.assertAllFlowFilesTransferred(CountText.REL_FAILURE, 1);
    }

    @Test
    void testShouldIgnoreWhitespaceWordsWhenCounting() {
        String INPUT_TEXT = "a  b  c";
        String EXPECTED_WORD_COUNT = "3";
        this.runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "false");
        this.runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "false");
        this.runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        this.runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "false");
        this.runner.setProperty(CountText.SPLIT_WORDS_ON_SYMBOLS_PD, "true");
        this.runner.clearProvenanceEvents();
        this.runner.clearTransferState();
        this.runner.enqueue("a  b  c".getBytes());
        this.runner.run();
        this.runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)this.runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(TWC, "3");
    }

    @Test
    void testShouldIgnoreWhitespaceWordsWhenCountingDebugMode() {
        MockComponentLog componentLogger = (MockComponentLog)Mockito.spy((Object)new MockComponentLog("processorId", (Object)new CountText()));
        ((MockComponentLog)Mockito.doReturn((Object)true).when((Object)componentLogger)).isDebugEnabled();
        TestRunner runner = TestRunners.newTestRunner(CountText.class, (MockComponentLog)componentLogger);
        String INPUT_TEXT = "a  b  c";
        String EXPECTED_WORD_COUNT = "3";
        runner.setProperty(CountText.TEXT_LINE_COUNT_PD, "false");
        runner.setProperty(CountText.TEXT_LINE_NONEMPTY_COUNT_PD, "false");
        runner.setProperty(CountText.TEXT_WORD_COUNT_PD, "true");
        runner.setProperty(CountText.TEXT_CHARACTER_COUNT_PD, "false");
        runner.setProperty(CountText.SPLIT_WORDS_ON_SYMBOLS_PD, "true");
        runner.clearProvenanceEvents();
        runner.clearTransferState();
        runner.enqueue("a  b  c".getBytes());
        runner.run();
        runner.assertAllFlowFilesTransferred(CountText.REL_SUCCESS, 1);
        MockFlowFile flowFile = (MockFlowFile)runner.getFlowFilesForRelationship(CountText.REL_SUCCESS).get(0);
        flowFile.assertAttributeEquals(TWC, "3");
    }
}

