/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.nifi.avro.AvroReaderWithExplicitSchema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.csv.CSVUtils;
import org.apache.nifi.processors.standard.AbstractConversionIT;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.TestRunner;
import org.junit.jupiter.api.BeforeEach;

public class ConversionWithExplicitSchemaIT
extends AbstractConversionIT {
    private String schema;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.schema = new String(Files.readAllBytes(Paths.get("src/test/resources/TestConversions/explicit.schema.json", new String[0])));
    }

    @Override
    protected String csvPostfix() {
        return "without_header.csv";
    }

    @Override
    protected String jsonPostfix() {
        return "json";
    }

    @Override
    protected String avroPostfix() {
        return "without_schema.avro";
    }

    @Override
    protected String xmlPostfix() {
        return "xml";
    }

    @Override
    protected void commonReaderConfiguration(TestRunner testRunner) {
        testRunner.setProperty((ControllerService)this.reader, SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY);
        testRunner.setProperty((ControllerService)this.reader, SchemaAccessUtils.SCHEMA_TEXT, this.schema);
    }

    @Override
    protected void commonWriterConfiguration(TestRunner testRunner) {
        testRunner.setProperty((ControllerService)this.writer, "Schema Write Strategy", "no-schema");
        testRunner.setProperty((ControllerService)this.writer, CSVUtils.INCLUDE_HEADER_LINE, "false");
    }

    @Override
    protected List<Map<String, Object>> getRecords(byte[] avroData) throws IOException, MalformedRecordException {
        Schema avroSchema = new Schema.Parser().parse(this.schema);
        RecordSchema recordSchema = AvroTypeUtil.createSchema((Schema)avroSchema);
        try (AvroReaderWithExplicitSchema reader = new AvroReaderWithExplicitSchema((InputStream)new ByteArrayInputStream(avroData), recordSchema, avroSchema);){
            List<Map<String, Object>> list = this.getRecords((RecordReader)reader);
            return list;
        }
    }
}

