/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.AbstractParameterProvider;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterGroup;
import org.apache.nifi.parameter.ParameterProviderInitializationContext;
import org.apache.nifi.parameter.VerifiableParameterProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.util.StringUtils;

@Tags(value={"database", "dbcp", "sql"})
@CapabilityDescription(value="Fetches parameters from database tables")
public class DatabaseParameterProvider
extends AbstractParameterProvider
implements VerifiableParameterProvider {
    protected static final Map<String, DatabaseAdapter> dbAdapters = new HashMap<String, DatabaseAdapter>();
    public static final PropertyDescriptor DB_TYPE;
    static AllowableValue GROUPING_BY_COLUMN;
    static AllowableValue GROUPING_BY_TABLE_NAME;
    public static final PropertyDescriptor DBCP_SERVICE;
    public static final PropertyDescriptor PARAMETER_GROUPING_STRATEGY;
    public static final PropertyDescriptor TABLE_NAMES;
    public static final PropertyDescriptor TABLE_NAME;
    public static final PropertyDescriptor PARAMETER_NAME_COLUMN;
    public static final PropertyDescriptor PARAMETER_VALUE_COLUMN;
    public static final PropertyDescriptor PARAMETER_GROUP_NAME_COLUMN;
    public static final PropertyDescriptor SQL_WHERE_CLAUSE;
    private List<PropertyDescriptor> properties;

    protected void init(ParameterProviderInitializationContext config) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DB_TYPE);
        properties.add(DBCP_SERVICE);
        properties.add(PARAMETER_GROUPING_STRATEGY);
        properties.add(TABLE_NAME);
        properties.add(TABLE_NAMES);
        properties.add(PARAMETER_NAME_COLUMN);
        properties.add(PARAMETER_VALUE_COLUMN);
        properties.add(PARAMETER_GROUP_NAME_COLUMN);
        properties.add(SQL_WHERE_CLAUSE);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public List<ParameterGroup> fetchParameters(ConfigurationContext context) {
        boolean groupByColumn = GROUPING_BY_COLUMN.getValue().equals(context.getProperty(PARAMETER_GROUPING_STRATEGY).getValue());
        DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
        String whereClause = context.getProperty(SQL_WHERE_CLAUSE).getValue();
        String parameterNameColumn = context.getProperty(PARAMETER_NAME_COLUMN).getValue();
        String parameterValueColumn = context.getProperty(PARAMETER_VALUE_COLUMN).getValue();
        String parameterGroupNameColumn = context.getProperty(PARAMETER_GROUP_NAME_COLUMN).getValue();
        List<String> tableNames = groupByColumn ? Collections.singletonList(context.getProperty(TABLE_NAME).getValue()) : Arrays.stream(context.getProperty(TABLE_NAMES).getValue().split(",")).map(String::trim).collect(Collectors.toList());
        HashMap<String, List> parameterMap = new HashMap<String, List>();
        for (String tableName : tableNames) {
            try {
                Connection con = dbcpService.getConnection(Collections.emptyMap());
                try {
                    Statement st = con.createStatement();
                    try {
                        ArrayList<String> columns = new ArrayList<String>();
                        columns.add(parameterNameColumn);
                        columns.add(parameterValueColumn);
                        if (groupByColumn) {
                            columns.add(parameterGroupNameColumn);
                        }
                        String query = this.getQuery(context, tableName, columns, whereClause);
                        this.getLogger().info("Fetching parameters with query: " + query);
                        ResultSet rs = st.executeQuery(query);
                        try {
                            while (rs.next()) {
                                String parameterGroupName;
                                String parameterName = rs.getString(parameterNameColumn);
                                String parameterValue = rs.getString(parameterValueColumn);
                                this.validateValueNotNull(parameterName, parameterNameColumn);
                                this.validateValueNotNull(parameterValue, parameterValueColumn);
                                if (groupByColumn) {
                                    parameterGroupName = parameterGroupNameColumn == null ? null : rs.getString(parameterGroupNameColumn);
                                    this.validateValueNotNull(parameterGroupName, parameterGroupNameColumn);
                                } else {
                                    parameterGroupName = tableName;
                                }
                                ParameterDescriptor parameterDescriptor = new ParameterDescriptor.Builder().name(parameterName).build();
                                Parameter parameter = new Parameter(parameterDescriptor, parameterValue);
                                parameterMap.computeIfAbsent(parameterGroupName, key -> new ArrayList()).add(parameter);
                            }
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (st == null) continue;
                        st.close();
                    }
                }
                finally {
                    if (con == null) continue;
                    con.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().error("Encountered a database error when fetching parameters: {}", new Object[]{e.getMessage(), e});
                throw new RuntimeException("Encountered a database error when fetching parameters: " + e.getMessage(), e);
            }
        }
        return parameterMap.entrySet().stream().map(entry -> new ParameterGroup((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private void validateValueNotNull(String value, String columnName) {
        if (value == null) {
            throw new IllegalStateException(String.format("Expected %s column to be non-null", columnName));
        }
    }

    String getQuery(ConfigurationContext context, String tableName, List<String> columns, String whereClause) {
        DatabaseAdapter dbAdapter = dbAdapters.get(context.getProperty(DB_TYPE).getValue());
        return dbAdapter.getSelectStatement(tableName, StringUtils.join(columns, (String)", "), whereClause, null, null, null);
    }

    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            List<ParameterGroup> parameterGroups = this.fetchParameters(context);
            long parameterCount = parameterGroups.stream().flatMap(group -> group.getParameters().stream()).count();
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Fetch Parameters").explanation(String.format("Successfully fetched %s Parameter Groups containing %s Parameters matching the filter.", parameterGroups.size(), parameterCount)).build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to fetch Parameter Groups", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Fetch Parameters").explanation(String.format("Failed to parameters: " + e.getMessage(), new Object[0])).build());
        }
        return results;
    }

    static {
        ArrayList dbAdapterValues = new ArrayList();
        ServiceLoader<DatabaseAdapter> dbAdapterLoader = ServiceLoader.load(DatabaseAdapter.class);
        dbAdapterLoader.forEach(it -> {
            dbAdapters.put(it.getName(), (DatabaseAdapter)it);
            dbAdapterValues.add(new AllowableValue(it.getName(), it.getName(), it.getDescription()));
        });
        DB_TYPE = new PropertyDescriptor.Builder().name("db-type").displayName("Database Type").description("The type/flavor of database, used for generating database-specific code. In many cases the Generic type should suffice, but some databases (such as Oracle) require custom SQL clauses. ").allowableValues(dbAdapterValues.toArray(new AllowableValue[dbAdapterValues.size()])).defaultValue("Generic").required(true).build();
        GROUPING_BY_COLUMN = new AllowableValue("grouping-by-column", "Column", "A single table is partitioned by the 'Parameter Group Name Column'.  All rows with the same value in this column will map to a group of the same name.");
        GROUPING_BY_TABLE_NAME = new AllowableValue("grouping-by-table-name", "Table Name", "An entire table maps to a Parameter Group.  The group name will be the table name.");
        DBCP_SERVICE = new PropertyDescriptor.Builder().name("dbcp-service").displayName("Database Connection Pooling Service").description("The Controller Service that is used to obtain a connection to the database.").required(true).identifiesControllerService(DBCPService.class).build();
        PARAMETER_GROUPING_STRATEGY = new PropertyDescriptor.Builder().name("parameter-grouping-strategy").displayName("Parameter Grouping Strategy").description("The strategy used to group parameters.").required(true).allowableValues(new AllowableValue[]{GROUPING_BY_COLUMN, GROUPING_BY_TABLE_NAME}).defaultValue(GROUPING_BY_COLUMN.getValue()).build();
        TABLE_NAMES = new PropertyDescriptor.Builder().name("table-names").displayName("Table Names").description("A comma-separated list of names of the database tables containing the parameters.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).dependsOn(PARAMETER_GROUPING_STRATEGY, new AllowableValue[]{GROUPING_BY_TABLE_NAME}).build();
        TABLE_NAME = new PropertyDescriptor.Builder().name("table-name").displayName("Table Name").description("The name of the database table containing the parameters.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).dependsOn(PARAMETER_GROUPING_STRATEGY, new AllowableValue[]{GROUPING_BY_COLUMN}).build();
        PARAMETER_NAME_COLUMN = new PropertyDescriptor.Builder().name("parameter-name-column").displayName("Parameter Name Column").description("The name of a column containing the parameter name.").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
        PARAMETER_VALUE_COLUMN = new PropertyDescriptor.Builder().name("parameter-value-column").displayName("Parameter Value Column").description("The name of a column containing the parameter value.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).build();
        PARAMETER_GROUP_NAME_COLUMN = new PropertyDescriptor.Builder().name("parameter-group-name-column").displayName("Parameter Group Name Column").description("The name of a column containing the name of the parameter group into which the parameter should be mapped.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).dependsOn(PARAMETER_GROUPING_STRATEGY, new AllowableValue[]{GROUPING_BY_COLUMN}).build();
        SQL_WHERE_CLAUSE = new PropertyDescriptor.Builder().name("sql-where-clause").displayName("SQL WHERE clause").description("A optional SQL query 'WHERE' clause by which to filter all results.  The 'WHERE' keyword should not be included.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    }
}

