/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.spring.SpringDataExchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SpringContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextFactory.class);
    private static final String SC_DELEGATE_NAME = "org.apache.nifi.spring.bootstrap.SpringContextDelegate";

    SpringContextFactory() {
    }

    static SpringDataExchanger createSpringContextDelegate(String classpath, String config) {
        List<URL> urls = SpringContextFactory.gatherAdditionalClassPathUrls(classpath);
        SpringContextClassLoader contextCl = new SpringContextClassLoader(urls.toArray(new URL[0]), SpringContextFactory.class.getClassLoader());
        ClassLoader tContextCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(contextCl);
        try {
            InputStream delegateStream = contextCl.getResourceAsStream(SC_DELEGATE_NAME.replace('.', '/') + ".class");
            byte[] delegateBytes = IOUtils.toByteArray((InputStream)delegateStream);
            Class<?> clazz = contextCl.doDefineClass(SC_DELEGATE_NAME, delegateBytes, 0, delegateBytes.length);
            Constructor<?> ctr = clazz.getDeclaredConstructor(String.class);
            ctr.setAccessible(true);
            SpringDataExchanger springDelegate = (SpringDataExchanger)ctr.newInstance(config);
            if (logger.isInfoEnabled()) {
                logger.info("Successfully instantiated Spring Application Context from '" + config + "'");
            }
            SpringDataExchanger springDataExchanger = springDelegate;
            return springDataExchanger;
        }
        catch (Exception e) {
            try {
                contextCl.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException("Failed to instantiate Spring Application Context. Config path: '" + config + "'; Classpath: " + Arrays.asList(urls), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tContextCl);
        }
    }

    static List<URL> gatherAdditionalClassPathUrls(String classPathRoot) {
        File classPathRootFile;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding additional resources from '" + classPathRoot + "' to the classpath.");
        }
        if ((classPathRootFile = new File(classPathRoot)).exists() && classPathRootFile.isDirectory()) {
            String[] cpResourceNames = classPathRootFile.list();
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String resourceName : cpResourceNames) {
                    File r = new File(classPathRootFile, resourceName);
                    if (!r.getName().toLowerCase().endsWith(".jar") && !r.isDirectory()) continue;
                    URL url = r.toURI().toURL();
                    urls.add(url);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Identifying additional resource to the classpath: " + url);
                }
                urls.add(classPathRootFile.toURI().toURL());
                return urls;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse user libraries from '" + classPathRootFile.getAbsolutePath() + "'", e);
            }
        }
        throw new IllegalArgumentException("Path '" + classPathRootFile.getAbsolutePath() + "' is not valid because it doesn't exist or does not point to a directory.");
    }

    private static class SpringContextClassLoader
    extends URLClassLoader {
        public SpringContextClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public final Class<?> doDefineClass(String name, byte[] b, int off, int len) {
            return this.defineClass(name, b, off, len);
        }
    }
}

