/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.nifi.spring.SpringDataExchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.MessageBuilder;

final class SpringContextDelegate
implements Closeable,
SpringDataExchanger {
    private final Logger logger = LoggerFactory.getLogger(SpringContextDelegate.class);
    private final ClassPathXmlApplicationContext applicationContext;
    private final MessageChannel toSpringChannel;
    private final PollableChannel fromSpringChannel;
    private final String configName;

    private SpringContextDelegate(String configName) {
        this.configName = configName;
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using " + Thread.currentThread().getContextClassLoader() + " as context class loader while loading Spring Context '" + configName + "'.");
        }
        try {
            this.applicationContext = new ClassPathXmlApplicationContext(configName);
            if (this.applicationContext.containsBean("fromNiFi")) {
                this.toSpringChannel = (MessageChannel)this.applicationContext.getBean("fromNiFi", MessageChannel.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Spring Application Context defined in '" + configName + "' is capable of receiving messages from NiFi since 'fromNiFi' channel was discovered.");
                }
            } else {
                this.toSpringChannel = null;
            }
            if (this.applicationContext.containsBean("toNiFi")) {
                this.fromSpringChannel = (PollableChannel)this.applicationContext.getBean("toNiFi", PollableChannel.class);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Spring Application Context defined in '" + configName + "' is capable of sending messages to NiFi since 'toNiFi' channel was discovered.");
                }
            } else {
                this.fromSpringChannel = null;
            }
            if (this.logger.isInfoEnabled() && this.toSpringChannel == null && this.fromSpringChannel == null) {
                this.logger.info("Spring Application Context is headless since neither 'fromNiFi' nor 'toNiFi' channels were defined. No data will be exchanged.");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    @Override
    public <T> boolean send(T payload, Map<String, ?> messageHeaders, long timeout) {
        if (this.toSpringChannel != null) {
            return this.toSpringChannel.send(MessageBuilder.withPayload(payload).copyHeaders(messageHeaders).build(), timeout);
        }
        throw new IllegalStateException("Failed to send message to '" + this.configName + "'. There are no 'fromNiFi' channels configured which means the Application Conetxt is not set up to receive messages from NiFi");
    }

    @Override
    public <T> SpringDataExchanger.SpringResponse<T> receive(long timeout) {
        Message message;
        if (this.fromSpringChannel != null && (message = this.fromSpringChannel.receive(timeout)) != null) {
            if (!(message.getPayload() instanceof byte[]) && !(message.getPayload() instanceof String)) {
                throw new IllegalStateException("Failed while receiving message from Spring due to the payload type being other then byte[] or String which are the only types that are supported. Please apply transformation/conversion on Spring side when sending message back to NiFi");
            }
            return new SpringDataExchanger.SpringResponse<Object>(message.getPayload(), (Map<String, Object>)message.getHeaders());
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.logger.info("Closing Spring Application Context");
        this.applicationContext.close();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closing " + this.getClass().getClassLoader());
        }
        ((URLClassLoader)this.getClass().getClassLoader()).close();
        this.logger.info("Successfully closed Spring Application Context and its ClassLoader.");
    }
}

