/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.solr;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.solr.SolrProcessor;
import org.apache.nifi.processors.solr.SolrUtils;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;

@Tags(value={"Apache", "Solr", "Get", "Pull", "Records"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Queries Solr and outputs the results as a FlowFile in the format of XML or using a Record Writer")
@Stateful(scopes={Scope.CLUSTER}, description="Stores latest date of Date Field so that the same data will not be fetched multiple times.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="1 min")
public class GetSolr
extends SolrProcessor {
    public static final String STATE_MANAGER_FILTER = "stateManager_filter";
    public static final String STATE_MANAGER_CURSOR_MARK = "stateManager_cursorMark";
    public static final AllowableValue MODE_XML = new AllowableValue("XML");
    public static final AllowableValue MODE_REC = new AllowableValue("Records");
    public static final PropertyDescriptor RETURN_TYPE = new PropertyDescriptor.Builder().name("Return Type").displayName("Return Type").description("Write Solr documents to FlowFiles as XML or using a Record Writer").required(true).allowableValues(new AllowableValue[]{MODE_XML, MODE_REC}).defaultValue(MODE_XML.getValue()).build();
    public static final PropertyDescriptor SOLR_QUERY = new PropertyDescriptor.Builder().name("Solr Query").displayName("Solr Query").description("A query to execute against Solr").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DATE_FIELD = new PropertyDescriptor.Builder().name("Date Field").displayName("Date Field").description("The name of a date field in Solr used to filter results").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor DATE_FILTER = new PropertyDescriptor.Builder().name("Initial Date Filter").displayName("Initial Date Filter").description("Date value to filter results. Documents with an earlier date will not be fetched. The format has to correspond to the date pattern of Solr 'YYYY-MM-DDThh:mm:ssZ'").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor RETURN_FIELDS = new PropertyDescriptor.Builder().name("Return Fields").displayName("Return Fields").description("Comma-separated list of field names to return").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").displayName("Batch Size").description("Number of rows per Solr query").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).defaultValue("100").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("The results of querying Solr").build();
    private final AtomicBoolean clearState = new AtomicBoolean(false);
    private final AtomicBoolean dateFieldNotInSpecifiedFieldsList = new AtomicBoolean(false);
    private volatile String id_field = null;
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> descriptors;
    static final Set<String> propertyNamesForActivatingClearState;

    protected void init(ProcessorInitializationContext context) {
        super.init(context);
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(SolrUtils.SOLR_TYPE);
        descriptors.add(SolrUtils.SOLR_LOCATION);
        descriptors.add(SolrUtils.COLLECTION);
        descriptors.add(RETURN_TYPE);
        descriptors.add(SolrUtils.RECORD_WRITER);
        descriptors.add(SOLR_QUERY);
        descriptors.add(DATE_FIELD);
        descriptors.add(DATE_FILTER);
        descriptors.add(RETURN_FIELDS);
        descriptors.add(BATCH_SIZE);
        descriptors.add(SolrUtils.KERBEROS_CREDENTIALS_SERVICE);
        descriptors.add(SolrUtils.KERBEROS_USER_SERVICE);
        descriptors.add(SolrUtils.KERBEROS_PRINCIPAL);
        descriptors.add(SolrUtils.KERBEROS_PASSWORD);
        descriptors.add(SolrUtils.BASIC_USERNAME);
        descriptors.add(SolrUtils.BASIC_PASSWORD);
        descriptors.add(SolrUtils.SSL_CONTEXT_SERVICE);
        descriptors.add(SolrUtils.SOLR_SOCKET_TIMEOUT);
        descriptors.add(SolrUtils.SOLR_CONNECTION_TIMEOUT);
        descriptors.add(SolrUtils.SOLR_MAX_CONNECTIONS);
        descriptors.add(SolrUtils.SOLR_MAX_CONNECTIONS_PER_HOST);
        descriptors.add(SolrUtils.ZK_CLIENT_TIMEOUT);
        descriptors.add(SolrUtils.ZK_CONNECTION_TIMEOUT);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (propertyNamesForActivatingClearState.contains(descriptor.getName())) {
            this.clearState.set(true);
        }
    }

    @OnScheduled
    public void clearState(ProcessContext context) throws IOException {
        if (this.clearState.getAndSet(false)) {
            context.getStateManager().clear(Scope.CLUSTER);
        }
        HashMap<String, String> stateMap = new HashMap<String, String>();
        stateMap.putAll(context.getStateManager().getState(Scope.CLUSTER).toMap());
        AtomicBoolean stateMapHasChanged = new AtomicBoolean(false);
        if (stateMap.get(STATE_MANAGER_CURSOR_MARK) == null) {
            stateMap.put(STATE_MANAGER_CURSOR_MARK, "*");
            stateMapHasChanged.set(true);
        }
        if (stateMap.get(STATE_MANAGER_FILTER) == null) {
            String initialDate = context.getProperty(DATE_FILTER).getValue();
            if (StringUtils.isBlank((String)initialDate)) {
                stateMap.put(STATE_MANAGER_FILTER, "*");
            } else {
                stateMap.put(STATE_MANAGER_FILTER, initialDate);
            }
            stateMapHasChanged.set(true);
        }
        if (stateMapHasChanged.get()) {
            context.getStateManager().setState(stateMap, Scope.CLUSTER);
        }
        this.id_field = null;
    }

    @Override
    protected final Collection<ValidationResult> additionalCustomValidation(ValidationContext context) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (context.getProperty(RETURN_TYPE).evaluateAttributeExpressions().getValue().equals(MODE_REC.getValue()) && !context.getProperty(SolrUtils.RECORD_WRITER).isSet()) {
            problems.add(new ValidationResult.Builder().explanation("for writing records a record writer has to be configured").valid(false).subject("Record writer check").build());
        }
        return problems;
    }

    private String getFieldNameOfUniqueKey() {
        SolrQuery solrQuery = new SolrQuery();
        try {
            solrQuery.setRequestHandler("/schema/uniquekey");
            QueryRequest req = new QueryRequest((SolrParams)solrQuery);
            if (this.isBasicAuthEnabled()) {
                req.setBasicAuthCredentials(this.getUsername(), this.getPassword());
            }
            return ((QueryResponse)req.process(this.getSolrClient())).getResponse().get("uniqueKey").toString();
        }
        catch (IOException | SolrServerException e) {
            this.getLogger().error("Solr query to retrieve uniqueKey-field failed due to {}", new Object[]{solrQuery.toString(), e}, e);
            throw new ProcessException(e);
        }
    }

    @Override
    public void doOnTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ComponentLog logger = this.getLogger();
        AtomicBoolean continuePaging = new AtomicBoolean(true);
        SolrQuery solrQuery = new SolrQuery();
        try {
            if (this.id_field == null) {
                this.id_field = this.getFieldNameOfUniqueKey();
            }
            String dateField = context.getProperty(DATE_FIELD).getValue();
            HashMap<String, String> stateMap = new HashMap<String, String>();
            stateMap.putAll(session.getState(Scope.CLUSTER).toMap());
            solrQuery.setQuery("*:*");
            String query = context.getProperty(SOLR_QUERY).getValue();
            if (!StringUtils.isBlank((String)query) && !query.equals("*:*")) {
                solrQuery.addFilterQuery(new String[]{query});
            }
            StringBuilder automatedFilterQuery = new StringBuilder().append(dateField).append(":[").append((String)stateMap.get(STATE_MANAGER_FILTER)).append(" TO *]");
            solrQuery.addFilterQuery(new String[]{automatedFilterQuery.toString()});
            ArrayList<String> fieldList = new ArrayList<String>();
            String returnFields = context.getProperty(RETURN_FIELDS).getValue();
            if (!StringUtils.isBlank((String)returnFields)) {
                fieldList.addAll(Arrays.asList(returnFields.trim().split("[,]")));
                if (!fieldList.contains(dateField)) {
                    fieldList.add(dateField);
                    this.dateFieldNotInSpecifiedFieldsList.set(true);
                }
                for (String returnField : fieldList) {
                    solrQuery.addField(returnField.trim());
                }
            }
            solrQuery.setParam("cursorMark", new String[]{(String)stateMap.get(STATE_MANAGER_CURSOR_MARK)});
            solrQuery.setRows(context.getProperty(BATCH_SIZE).asInteger());
            StringBuilder sortClause = new StringBuilder().append(dateField).append(" asc,").append(this.id_field).append(" asc");
            solrQuery.setParam("sort", new String[]{sortClause.toString()});
            while (continuePaging.get()) {
                StopWatch timer = new StopWatch(true);
                QueryRequest req = new QueryRequest((SolrParams)solrQuery);
                if (this.isBasicAuthEnabled()) {
                    req.setBasicAuthCredentials(this.getUsername(), this.getPassword());
                }
                logger.debug(solrQuery.toQueryString());
                QueryResponse response = (QueryResponse)req.process(this.getSolrClient());
                SolrDocumentList documentList = response.getResults();
                if (response.getResults().size() > 0) {
                    SolrDocument lastSolrDocument = (SolrDocument)documentList.get(response.getResults().size() - 1);
                    String latestDateValue = df.format(lastSolrDocument.get((Object)dateField));
                    String newCursorMark = response.getNextCursorMark();
                    solrQuery.setParam("cursorMark", new String[]{newCursorMark});
                    stateMap.put(STATE_MANAGER_CURSOR_MARK, newCursorMark);
                    stateMap.put(STATE_MANAGER_FILTER, latestDateValue);
                    FlowFile flowFile = session.create();
                    flowFile = session.putAttribute(flowFile, "solrQuery", solrQuery.toString());
                    if (context.getProperty(RETURN_TYPE).getValue().equals(MODE_XML.getValue())) {
                        if (this.dateFieldNotInSpecifiedFieldsList.get()) {
                            for (SolrDocument doc : response.getResults()) {
                                doc.removeFields(dateField);
                            }
                        }
                        flowFile = session.write(flowFile, SolrUtils.getOutputStreamCallbackToTransformSolrResponseToXml(response));
                        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/xml");
                    } else {
                        final RecordSetWriterFactory writerFactory = (RecordSetWriterFactory)context.getProperty(SolrUtils.RECORD_WRITER).evaluateAttributeExpressions().asControllerService(RecordSetWriterFactory.class);
                        final RecordSchema schema = writerFactory.getSchema(null, null);
                        final RecordSet recordSet = SolrUtils.solrDocumentsToRecordSet((List<SolrDocument>)response.getResults(), schema);
                        final StringBuffer mimeType = new StringBuffer();
                        final FlowFile flowFileRef = flowFile;
                        flowFile = session.write(flowFile, new OutputStreamCallback(){

                            public void process(OutputStream out) throws IOException {
                                try {
                                    RecordSetWriter writer = writerFactory.createWriter(GetSolr.this.getLogger(), schema, out, flowFileRef);
                                    writer.write(recordSet);
                                    writer.flush();
                                    mimeType.append(writer.getMimeType());
                                }
                                catch (SchemaNotFoundException e) {
                                    throw new ProcessException("Could not parse Solr response", (Throwable)e);
                                }
                            }
                        });
                        flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), mimeType.toString());
                    }
                    timer.stop();
                    StringBuilder transitUri = new StringBuilder("solr://");
                    transitUri.append(this.getSolrLocation());
                    if (this.getSolrLocation().equals(SolrUtils.SOLR_TYPE_CLOUD.getValue())) {
                        transitUri.append(":").append(context.getProperty(SolrUtils.COLLECTION).evaluateAttributeExpressions().getValue());
                    }
                    long duration = timer.getDuration(TimeUnit.MILLISECONDS);
                    session.getProvenanceReporter().receive(flowFile, transitUri.toString(), duration);
                    session.transfer(flowFile, REL_SUCCESS);
                }
                continuePaging.set(response.getResults().size() == Integer.parseInt(context.getProperty(BATCH_SIZE).getValue()));
            }
            session.setState(stateMap, Scope.CLUSTER);
        }
        catch (IOException | SchemaNotFoundException | SolrServerException e) {
            context.yield();
            session.rollback();
            logger.error("Failed to execute query {} due to {}", new Object[]{solrQuery.toString(), e}, e);
            throw new ProcessException(e);
        }
        catch (Throwable t) {
            context.yield();
            session.rollback();
            logger.error("Failed to execute query {} due to {}", new Object[]{solrQuery.toString(), t}, t);
            throw t;
        }
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        propertyNamesForActivatingClearState = new HashSet<String>();
        propertyNamesForActivatingClearState.add(SolrUtils.SOLR_TYPE.getName());
        propertyNamesForActivatingClearState.add(SolrUtils.SOLR_LOCATION.getName());
        propertyNamesForActivatingClearState.add(SolrUtils.COLLECTION.getName());
        propertyNamesForActivatingClearState.add(SOLR_QUERY.getName());
        propertyNamesForActivatingClearState.add(DATE_FIELD.getName());
        propertyNamesForActivatingClearState.add(RETURN_FIELDS.getName());
        propertyNamesForActivatingClearState.add(DATE_FILTER.getName());
    }
}

