/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.io.socket.multicast;

import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.io.socket.multicast.DiscoverableService;

public class DiscoverableServiceImpl
implements DiscoverableService {
    private final String serviceName;
    private final InetSocketAddress serviceAddress;

    public DiscoverableServiceImpl(String serviceName, InetSocketAddress serviceAddress) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("Service name may not be null or empty.");
        }
        if (serviceAddress == null) {
            throw new IllegalArgumentException("Service address may not be null.");
        }
        this.serviceName = serviceName;
        this.serviceAddress = serviceAddress;
    }

    @Override
    public InetSocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public String toString() {
        return String.format("[Discoverable Service: %s available at %s:%d]", this.serviceName, this.serviceAddress.getHostName(), this.serviceAddress.getPort());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverableService)) {
            return false;
        }
        DiscoverableService other = (DiscoverableService)obj;
        return !(this.serviceName != null ? !this.serviceName.equals(other.getServiceName()) : other.getServiceName() != null);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        return hash;
    }
}

