/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.trap;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.nifi.snmp.configuration.V1TrapConfiguration;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Target;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;

public class V1TrapPDUFactory {
    private static final PDUFactory v1PduFactory = new DefaultPDUFactory(-92);
    final Target target;
    final Instant startTime;

    public V1TrapPDUFactory(Target target, Instant startTime) {
        this.target = target;
        this.startTime = startTime;
    }

    public PDU get(V1TrapConfiguration v1TrapConfiguration) {
        PDUv1 pdu = (PDUv1)v1PduFactory.createPDU(this.target);
        Optional.ofNullable(v1TrapConfiguration.getEnterpriseOid()).map(OID::new).ifPresent(arg_0 -> ((PDUv1)pdu).setEnterprise(arg_0));
        Optional.ofNullable(v1TrapConfiguration.getAgentAddress()).map(IpAddress::new).ifPresent(arg_0 -> ((PDUv1)pdu).setAgentAddress(arg_0));
        pdu.setGenericTrap(v1TrapConfiguration.getGenericTrapType());
        Optional.ofNullable(v1TrapConfiguration.getSpecificTrapType()).ifPresent(arg_0 -> ((PDUv1)pdu).setSpecificTrap(arg_0));
        long elapsedMillis = Duration.between(this.startTime, Instant.now()).toMillis();
        pdu.setTimestamp(elapsedMillis);
        return pdu;
    }
}

