/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.operations;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.snmp.dto.SNMPSingleResponse;
import org.apache.nifi.snmp.exception.RequestTimeoutException;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;

public class SetSNMPHandler {
    private static PDUFactory setPduFactory = new DefaultPDUFactory(-93);
    private final Snmp snmpManager;

    public SetSNMPHandler(Snmp snmpManager) {
        this.snmpManager = snmpManager;
    }

    public Optional<SNMPSingleResponse> set(Map<String, String> flowFileAttributes, Target target) throws IOException {
        PDU pdu = setPduFactory.createPDU(target);
        boolean isAnySnmpVariableInFlowFile = SNMPUtils.addVariables(pdu, flowFileAttributes);
        if (isAnySnmpVariableInFlowFile) {
            ResponseEvent response = this.snmpManager.set(pdu, target);
            PDU responsePdu = response.getResponse();
            if (responsePdu == null) {
                throw new RequestTimeoutException(String.format("Request timed out. Please check if (1). the agent host and port is correctly set, (2). the agent is running, (3). the agent SNMP version corresponds with the processor's one, (4) the community string is correct and has %1$s access, (5) In case of SNMPv3 check if the user credentials are valid and the user in a group with %1$s access.", "write"));
            }
            return Optional.of(new SNMPSingleResponse(target, responsePdu));
        }
        return Optional.empty();
    }

    static void setSetPduFactory(PDUFactory setPduFactory) {
        SetSNMPHandler.setPduFactory = setPduFactory;
    }
}

