/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.core;

import java.util.Optional;
import org.apache.nifi.snmp.configuration.SNMPConfiguration;
import org.apache.nifi.snmp.factory.core.SNMPContext;
import org.apache.nifi.snmp.factory.core.SNMPManagerFactory;
import org.apache.nifi.snmp.utils.SNMPUtils;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class V3SNMPFactory
extends SNMPManagerFactory
implements SNMPContext {
    @Override
    public Snmp createSnmpManagerInstance(SNMPConfiguration configuration) {
        Snmp snmpManager = super.createSnmpManagerInstance(configuration);
        OctetString localEngineId = new OctetString(MPv3.createLocalEngineID());
        USM usm = new USM(SecurityProtocols.getInstance(), localEngineId, 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        Optional.ofNullable(configuration.getSecurityName()).map(OctetString::new).ifPresent(securityName -> {
            OID authProtocol = Optional.ofNullable(configuration.getAuthProtocol()).map(SNMPUtils::getAuth).orElse(null);
            OctetString authPassphrase = Optional.ofNullable(configuration.getAuthPassphrase()).map(OctetString::new).orElse(null);
            OID privacyProtocol = Optional.ofNullable(configuration.getPrivacyProtocol()).map(SNMPUtils::getPriv).orElse(null);
            OctetString privacyPassphrase = Optional.ofNullable(configuration.getPrivacyPassphrase()).map(OctetString::new).orElse(null);
            snmpManager.getUSM().addUser(securityName, new UsmUser(securityName, authProtocol, authPassphrase, privacyProtocol, privacyPassphrase));
        });
        return snmpManager;
    }

    @Override
    public Target createTargetInstance(SNMPConfiguration configuration) {
        UserTarget userTarget = new UserTarget();
        this.setupTargetBasicProperties((Target)userTarget, configuration);
        int securityLevel = SecurityLevel.valueOf((String)configuration.getSecurityLevel()).getSnmpValue();
        userTarget.setSecurityLevel(securityLevel);
        String securityName = configuration.getSecurityName();
        Optional.ofNullable(securityName).map(OctetString::new).ifPresent(arg_0 -> ((UserTarget)userTarget).setSecurityName(arg_0));
        return userTarget;
    }
}

