/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.factory.trap;

import java.time.Duration;
import java.time.Instant;
import org.apache.nifi.snmp.configuration.V2TrapConfiguration;
import org.snmp4j.PDU;
import org.snmp4j.Target;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;

public class V2TrapPDUFactory {
    private static final PDUFactory v2PduFactory = new DefaultPDUFactory(-89);
    final Target target;
    final Instant startTime;

    public V2TrapPDUFactory(Target target, Instant startTime) {
        this.target = target;
        this.startTime = startTime;
    }

    public PDU get(V2TrapConfiguration v2TrapConfiguration) {
        PDU pdu = v2PduFactory.createPDU(this.target);
        pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OctetString(v2TrapConfiguration.getTrapOidValue())));
        long elapsedMillis = Duration.between(this.startTime, Instant.now()).toMillis();
        pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(elapsedMillis)));
        return pdu;
    }
}

