/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.smb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.smb.GetSmbFile;
import org.apache.nifi.processors.smb.ListSmb;
import org.apache.nifi.processors.smb.PutSmbFile;
import org.apache.nifi.processors.smb.util.CompletionStrategy;
import org.apache.nifi.services.smb.SmbClientProviderService;
import org.apache.nifi.services.smb.SmbClientService;
import org.apache.nifi.services.smb.SmbException;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"samba", "smb", "cifs", "files", "fetch"})
@CapabilityDescription(value="Fetches files from a SMB Share. Designed to be used in tandem with ListSmb.")
@SeeAlso(value={ListSmb.class, PutSmbFile.class, GetSmbFile.class})
@WritesAttributes(value={@WritesAttribute(attribute="error.code", description="The error code returned by SMB when the fetch of a file fails."), @WritesAttribute(attribute="error.message", description="The error message returned by SMB when the fetch of a file fails.")})
public class FetchSmb
extends AbstractProcessor {
    public static final String ERROR_CODE_ATTRIBUTE = "error.code";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "error.message";
    public static final PropertyDescriptor REMOTE_FILE = new PropertyDescriptor.Builder().name("remote-file").displayName("Remote File").description("The full path of the file to be retrieved from the remote server. Expression language is supported.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${path}/${filename}").addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).build();
    public static final PropertyDescriptor COMPLETION_STRATEGY = new PropertyDescriptor.Builder().name("Completion Strategy").description("Specifies what to do with the original file on the server once it has been processed. If the Completion Strategy fails, a warning will be logged but the data will still be transferred.").allowableValues(CompletionStrategy.class).defaultValue(CompletionStrategy.NONE.getValue()).required(true).build();
    public static final PropertyDescriptor DESTINATION_DIRECTORY = new PropertyDescriptor.Builder().name("Destination Directory").description("The directory on the remote server to move the original file to once it has been processed.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).dependsOn(COMPLETION_STRATEGY, (DescribedValue)CompletionStrategy.MOVE, new DescribedValue[0]).build();
    public static final PropertyDescriptor CREATE_DESTINATION_DIRECTORY = new PropertyDescriptor.Builder().name("Create Destination Directory").description("Specifies whether or not the remote directory should be created if it does not exist.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").dependsOn(COMPLETION_STRATEGY, (DescribedValue)CompletionStrategy.MOVE, new DescribedValue[0]).build();
    public static final PropertyDescriptor SMB_CLIENT_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("smb-client-provider-service").displayName("SMB Client Provider Service").description("Specifies the SMB client provider to use for creating SMB connections.").required(true).identifiesControllerService(SmbClientProviderService.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile will be routed here for each successfully fetched file.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile will be routed here when failed to fetch its content.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    private static final List<PropertyDescriptor> PROPERTIES = Arrays.asList(SMB_CLIENT_PROVIDER_SERVICE, REMOTE_FILE, COMPLETION_STRATEGY, DESTINATION_DIRECTORY, CREATE_DESTINATION_DIRECTORY);
    public static final String UNCATEGORIZED_ERROR = "-2";

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Map attributes = flowFile.getAttributes();
        String filePath = context.getProperty(REMOTE_FILE).evaluateAttributeExpressions(attributes).getValue();
        SmbClientProviderService clientProviderService = (SmbClientProviderService)context.getProperty(SMB_CLIENT_PROVIDER_SERVICE).asControllerService(SmbClientProviderService.class);
        try (SmbClientService client = clientProviderService.getClient();){
            flowFile = session.write(flowFile, outputStream -> client.readFile(filePath, outputStream));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Could not fetch file {}.", new Object[]{filePath, e});
            flowFile = session.putAttribute(flowFile, ERROR_CODE_ATTRIBUTE, this.getErrorCode(e));
            flowFile = session.putAttribute(flowFile, ERROR_MESSAGE_ATTRIBUTE, e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        session.commitAsync(() -> this.performCompletionStrategy(context, attributes));
    }

    private String getErrorCode(Exception exception) {
        return Optional.ofNullable(exception instanceof SmbException ? (SmbException)exception : null).map(SmbException::getErrorCode).map(String::valueOf).orElse(UNCATEGORIZED_ERROR);
    }

    private void performCompletionStrategy(ProcessContext context, Map<String, String> attributes) {
        CompletionStrategy completionStrategy = CompletionStrategy.valueOf(context.getProperty(COMPLETION_STRATEGY).getValue());
        if (completionStrategy == CompletionStrategy.NONE) {
            return;
        }
        String filePath = context.getProperty(REMOTE_FILE).evaluateAttributeExpressions(attributes).getValue();
        SmbClientProviderService clientProviderService = (SmbClientProviderService)context.getProperty(SMB_CLIENT_PROVIDER_SERVICE).asControllerService(SmbClientProviderService.class);
        try (SmbClientService client = clientProviderService.getClient();){
            if (completionStrategy == CompletionStrategy.MOVE) {
                String destinationDirectory = context.getProperty(DESTINATION_DIRECTORY).evaluateAttributeExpressions(attributes).getValue();
                boolean createDestinationDirectory = context.getProperty(CREATE_DESTINATION_DIRECTORY).asBoolean();
                if (createDestinationDirectory) {
                    client.ensureDirectory(destinationDirectory);
                }
                client.moveFile(filePath, destinationDirectory);
            } else if (completionStrategy == CompletionStrategy.DELETE) {
                client.deleteFile(filePath);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not perform completion strategy {} for file {}", new Object[]{completionStrategy, filePath, e});
        }
    }
}

