/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.smb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.smb.GetSmbFile;
import org.apache.nifi.processors.smb.ListSmb;
import org.apache.nifi.processors.smb.PutSmbFile;
import org.apache.nifi.services.smb.SmbClientProviderService;
import org.apache.nifi.services.smb.SmbClientService;
import org.apache.nifi.services.smb.SmbException;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"samba", "smb", "cifs", "files", "fetch"})
@CapabilityDescription(value="Fetches files from a SMB Share. Designed to be used in tandem with ListSmb.")
@SeeAlso(value={ListSmb.class, PutSmbFile.class, GetSmbFile.class})
@WritesAttributes(value={@WritesAttribute(attribute="error.code", description="The error code returned by SMB when the fetch of a file fails."), @WritesAttribute(attribute="error.message", description="The error message returned by SMB when the fetch of a file fails.")})
public class FetchSmb
extends AbstractProcessor {
    public static final String ERROR_CODE_ATTRIBUTE = "error.code";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "error.message";
    public static final PropertyDescriptor REMOTE_FILE = new PropertyDescriptor.Builder().name("remote-file").displayName("Remote File").description("The full path of the file to be retrieved from the remote server. Expression language is supported.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${path}/${filename}").addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).build();
    public static final PropertyDescriptor SMB_CLIENT_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("smb-client-provider-service").displayName("SMB Client Provider Service").description("Specifies the SMB client provider to use for creating SMB connections.").required(true).identifiesControllerService(SmbClientProviderService.class).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A flowfile will be routed here for each successfully fetched file.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A flowfile will be routed here when failed to fetch its content.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final String UNCATEGORIZED_ERROR = "-2";
    private static final List<PropertyDescriptor> PROPERTIES = Arrays.asList(SMB_CLIENT_PROVIDER_SERVICE, REMOTE_FILE);

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        SmbClientProviderService clientProviderService = (SmbClientProviderService)context.getProperty(SMB_CLIENT_PROVIDER_SERVICE).asControllerService(SmbClientProviderService.class);
        try (SmbClientService client = clientProviderService.getClient();){
            this.fetchAndTransfer(session, context, client, flowFile);
        }
        catch (Exception e) {
            this.getLogger().error("Couldn't connect to SMB.", (Throwable)e);
            flowFile = session.putAttribute(flowFile, ERROR_CODE_ATTRIBUTE, this.getErrorCode(e));
            flowFile = session.putAttribute(flowFile, ERROR_MESSAGE_ATTRIBUTE, e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    private void fetchAndTransfer(ProcessSession session, ProcessContext context, SmbClientService client, FlowFile flowFile) {
        Map attributes = flowFile.getAttributes();
        String filename = context.getProperty(REMOTE_FILE).evaluateAttributeExpressions(attributes).getValue();
        try {
            flowFile = session.write(flowFile, outputStream -> client.readFile(filename, outputStream));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Couldn't fetch file {}.", new Object[]{filename, e});
            flowFile = session.putAttribute(flowFile, ERROR_CODE_ATTRIBUTE, this.getErrorCode(e));
            flowFile = session.putAttribute(flowFile, ERROR_MESSAGE_ATTRIBUTE, this.getErrorMessage(e));
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private String getErrorCode(Exception exception) {
        return Optional.ofNullable(exception instanceof SmbException ? (SmbException)exception : null).map(SmbException::getErrorCode).map(String::valueOf).orElse(UNCATEGORIZED_ERROR);
    }

    private String getErrorMessage(Exception exception) {
        return Optional.ofNullable(exception.getMessage()).orElse(exception.getClass().getSimpleName());
    }
}

